/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jclient;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import progress.message.jclient.AbstractJMSContext;
import progress.message.jclient.JMSExceptionUtils;

public class JMSContext
extends AbstractJMSContext {
    private Connection connection;
    private Session session;

    public JMSContext(Connection connection, int sessionMode) {
        super(sessionMode);
        this.connection = connection;
    }

    @Override
    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    protected Session getSession() {
        return this.session;
    }

    @Override
    public javax.jms.JMSContext createContext(int sessionMode) {
        return new JMSContext(this.connection, sessionMode);
    }

    @Override
    protected void checkSession() {
        this.checkNotClosed();
        if (this.session == null) {
            try {
                this.session = this.getConnection().createSession(this.sessionMode);
            }
            catch (JMSException jmse) {
                throw JMSExceptionUtils.convertToRuntimeException(jmse);
            }
        }
    }
}

