/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jclient;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.naming.NamingException;
import javax.naming.Reference;
import progress.message.jclient.AdministeredObjectFactory;
import progress.message.jclient.ConnectionFactory;
import progress.message.jclient.api.ITopicConnectionFactory;
import progress.message.net.ProgressInetAddress;
import progress.message.zclient.SessionConfig;

public class TopicConnectionFactory
extends ConnectionFactory
implements ITopicConnectionFactory {
    static final long serialVersionUID = -2773995350633634265L;

    public TopicConnectionFactory() throws JMSException {
        super(ProgressInetAddress.getLocalHostName());
    }

    protected TopicConnectionFactory(Hashtable env) throws JMSException {
        super(env);
    }

    public TopicConnectionFactory(String brokerlist) throws JMSException {
        super(brokerlist);
    }

    public TopicConnectionFactory(String brokerlist, String connectID) throws JMSException {
        super(brokerlist, connectID);
    }

    public TopicConnectionFactory(String brokerlist, String defaultUserName, String defaultPassword) throws JMSException {
        super(brokerlist, defaultUserName, defaultPassword);
    }

    public TopicConnectionFactory(String brokerlist, String connectID, String defaultUserName, String defaultPassword) throws JMSException {
        super(brokerlist, connectID, defaultUserName, defaultPassword);
    }

    @Deprecated
    public TopicConnectionFactory(String brokerHostName, int brokerPort, String brokerProtocol, String defaultUserName, String defaultPassword) throws JMSException {
        super(brokerHostName, brokerPort, brokerProtocol, defaultUserName, defaultPassword);
    }

    @Deprecated
    public TopicConnectionFactory(String brokerHostName, int brokerPort, String brokerProtocol, String connectID, String defaultUserName, String defaultPassword) throws JMSException {
        super(brokerHostName, brokerPort, brokerProtocol, connectID, defaultUserName, defaultPassword);
    }

    @Override
    public TopicConnection createTopicConnection() throws JMSException {
        return this.createTopicConnection(this.getDefaultUser(), this.getDefaultPassword());
    }

    @Override
    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        this.checkSPILoginBind();
        SessionConfig.initHTTPSProxySetting();
        this.resolveConnectionURLs();
        return new progress.message.jimpl.TopicConnection(this.getConnectID(), userName, password, this.getApplet(), this.getClientID(), this.getEnv());
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(TopicConnectionFactory.class.getName(), AdministeredObjectFactory.class.getName(), null);
        this.addReferences(ref);
        return ref;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF("14.0");
        stream.writeObject(this.getBrokerURL());
        String brokerHost = this.getBrokerHostName() == null ? ProgressInetAddress.getLocalHostName() : this.getBrokerHostName();
        stream.writeUTF(brokerHost);
        stream.writeUTF(this.getBrokerProtocol());
        stream.writeInt(this.getBrokerPort());
        stream.writeUTF(this.getDefaultUser());
        stream.writeUTF(this.getDefaultPassword());
        stream.writeObject(this.getConnectID());
        stream.writeObject(this.getClientID());
        stream.writeBoolean(this.getSequential());
        stream.writeBoolean(this.getLoadBalancing());
        stream.writeObject(this.getConnectionURLs());
        stream.writeBoolean(this.getPersistentDelivery());
        stream.writeBoolean(this.getSelectorAtBroker());
        stream.writeInt(this.getMonitorInterval());
        stream.writeLong(this.getPingInterval());
        stream.writeBoolean(this.getDurableMessageOrder());
        stream.writeInt(this.getDefaultTxnBatchSize());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
    }
}

