/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import progress.message.client.prAccessor;
import progress.message.jimpl.Destination;
import progress.message.jimpl.MultiTopic;
import progress.message.jimpl.Queue;
import progress.message.jimpl.Topic;
import progress.message.resources.prMessageFormat;
import progress.message.util.DraDestUtil;
import progress.message.zclient.ISubject;
import progress.message.zclient.Subject;
import progress.message.zclient.SubjectUtil;

public class DestUtil {
    static final int MAX_TOPIC_LEN = 256;
    static final int MAX_QUEUE_LEN = 256;
    static final int MAX_ROUTING_LEN = 256;

    static boolean hasRoutingNode(String name) {
        return DestUtil.getRoutingName(name) != null;
    }

    static boolean isTemporaryTopic(String name) {
        return name.startsWith("$ISYS.USERS.TemporaryTopics");
    }

    static boolean isTemporaryQueue(String name) {
        return name.startsWith("$ISYS.USERS.TemporaryQueues");
    }

    static String getRoutingName(javax.jms.Destination dest) throws JMSException {
        if (dest == null) {
            return null;
        }
        if (dest instanceof Destination) {
            return ((Destination)dest).getRouting();
        }
        if (dest instanceof javax.jms.Queue) {
            return DestUtil.getRoutingName(((javax.jms.Queue)dest).getQueueName());
        }
        return DestUtil.getRoutingName(((javax.jms.Topic)dest).getTopicName());
    }

    public static String getRoutingName(String name) {
        String testStr;
        int lastPos = name.lastIndexOf("::");
        if (lastPos == -1) {
            return null;
        }
        if (lastPos == 0) {
            return "";
        }
        int prevPos = name.lastIndexOf("::", lastPos - 1);
        String string = testStr = prevPos == -1 ? name : name.substring(prevPos + 2);
        if (DraDestUtil.isHttpOrHttps(testStr)) {
            lastPos = prevPos;
        }
        return lastPos == -1 ? null : name.substring(0, lastPos);
    }

    static String getDestinationName(javax.jms.Destination dest) throws JMSException {
        if (dest == null) {
            return null;
        }
        if (dest instanceof javax.jms.Queue) {
            return DestUtil.getDestinationName(((javax.jms.Queue)dest).getQueueName());
        }
        return DestUtil.getDestinationName(((javax.jms.Topic)dest).getTopicName());
    }

    public static String getDestinationName(String name) {
        String node = DestUtil.getRoutingName(name);
        return node == null ? name : name.substring(node.length() + 2);
    }

    static boolean validateQueueName(String name) throws InvalidDestinationException {
        if (name == null || name.length() == 0) {
            throw new InvalidDestinationException(prAccessor.getString("QUEUE_EMPTY"));
        }
        int length = name.length();
        if (DraDestUtil.isHttpOrHttps(name)) {
            return DestUtil.validateURL(name);
        }
        if (length > 256) {
            String msgf = prAccessor.getString("QUEUE_NAME_TOO_LONG");
            Object[] obj = new Object[]{Integer.toString(256)};
            throw new InvalidDestinationException(prMessageFormat.format(msgf, obj));
        }
        if (name.indexOf("$") != -1) {
            throw new InvalidDestinationException(prAccessor.getString("QUEUE_INVALID_CHARS"));
        }
        StringBuffer buffer = new StringBuffer(name);
        char lastChar = buffer.charAt(0);
        for (int i = 1; i < length; ++i) {
            char currChar = buffer.charAt(i);
            if ((currChar == '*' || currChar == '#') && (lastChar != '.' || i + 1 < length && buffer.charAt(i + 1) != '.')) {
                throw new InvalidDestinationException(prAccessor.getString("QUEUE_INVALID_CHARS"));
            }
            lastChar = currChar;
        }
        if (name.equals("SonicMQ.routingQueue")) {
            throw new InvalidDestinationException(prAccessor.getString("QUEUE_INVALID_ACCESS"));
        }
        return true;
    }

    static boolean validateTopicName(String name) throws InvalidDestinationException {
        if (name == null || name.length() == 0) {
            throw new InvalidDestinationException(prAccessor.getString("TOPIC_EMPTY"));
        }
        int length = name.length();
        if (DraDestUtil.isHttpOrHttps(name)) {
            return DestUtil.validateURL(name);
        }
        if (length > 256) {
            String msgf = prAccessor.getString("TOPIC_NAME_TOO_LONG");
            Object[] obj = new Object[]{Integer.toString(256)};
            throw new InvalidDestinationException(prMessageFormat.format(msgf, obj));
        }
        if (name.indexOf("$") != -1 || name.indexOf("\\") != -1) {
            throw new InvalidDestinationException(prAccessor.getString("TOPIC_INVALID_CHARS"));
        }
        String topicName = name;
        if (DestUtil.hasGroupPrefix(name, 0)) {
            DestUtil.validateGroupName(name);
            name = SubjectUtil.getSubjectTopic(name);
            length = name.length();
        }
        if (name.indexOf("[") != -1 || name.indexOf("]") != -1) {
            throw new InvalidDestinationException(prAccessor.getString("TOPIC_INVALID_CHARS"));
        }
        StringBuffer buffer = new StringBuffer(name);
        char lastChar = buffer.charAt(0);
        for (int i = 1; i < length; ++i) {
            char currChar = buffer.charAt(i);
            if ((currChar == '*' || currChar == '#') && (lastChar != '.' || i + 1 < length && buffer.charAt(i + 1) != '.')) {
                throw new InvalidDestinationException(prAccessor.getString("TOPIC_INVALID_CHARS"));
            }
            lastChar = currChar;
        }
        return true;
    }

    public static boolean validateRoutingName(String name) throws InvalidDestinationException {
        if (name == null) {
            return true;
        }
        int length = name.length();
        if (length > 256) {
            String msgf = prAccessor.getString("ROUTING_NAME_TOO_LONG");
            Object[] obj = new Object[]{Integer.toString(256)};
            throw new InvalidDestinationException(prMessageFormat.format(msgf, obj));
        }
        if (length > 0) {
            if (name.indexOf("$") != -1 || name.indexOf("\"") != -1) {
                throw new InvalidDestinationException(prAccessor.getString("ROUTING_NAME_INVALID_CHARS"));
            }
            if (name.indexOf("::") != -1) {
                throw new InvalidDestinationException(prAccessor.getString("ROUTING_NAME_MULTI_HOP"));
            }
        }
        return true;
    }

    static boolean hasGroupPrefix(String topicName, int fromIndex) {
        return topicName.indexOf("[[", fromIndex) != -1;
    }

    public static boolean validateGroupName(String topicName) throws InvalidDestinationException {
        int errcode = SubjectUtil.validateGroupName(topicName);
        if (errcode >= 0) {
            return true;
        }
        switch (errcode) {
            case -1: {
                throw new InvalidDestinationException(prAccessor.getString("TOPIC_INVALID_GROUP_ROUTING_COMBINATION"));
            }
            case -4: {
                throw new InvalidDestinationException(prAccessor.getString("TOPIC_GROUP_INVALID_CHARS"));
            }
            case -3: {
                String msgf = prAccessor.getString("TOPIC_GROUP_NAME_TOO_LONG");
                Object[] obj = new Object[]{Integer.toString(64)};
                throw new InvalidDestinationException(prMessageFormat.format(msgf, obj));
            }
        }
        throw new InvalidDestinationException(prAccessor.getString("TOPIC_INVALID_GROUP_NAME"));
    }

    public static boolean validateGroupPrefix(String groupName) throws InvalidDestinationException {
        int errcode = SubjectUtil.validateGroupPrefix(groupName);
        if (errcode >= 0) {
            return true;
        }
        switch (errcode) {
            case -1: {
                throw new InvalidDestinationException(prAccessor.getString("TOPIC_INVALID_GROUP_ROUTING_COMBINATION"));
            }
            case -4: {
                throw new InvalidDestinationException(prAccessor.getString("TOPIC_GROUP_INVALID_CHARS"));
            }
            case -3: {
                String msgf = prAccessor.getString("TOPIC_GROUP_NAME_TOO_LONG");
                Object[] obj = new Object[]{Integer.toString(64)};
                throw new InvalidDestinationException(prMessageFormat.format(msgf, obj));
            }
        }
        throw new InvalidDestinationException(prAccessor.getString("TOPIC_INVALID_GROUP_NAME"));
    }

    public static boolean validateURL(String urlString) throws InvalidDestinationException {
        String dsn = DraDestUtil.getUrlHostName(urlString);
        if (dsn == null || dsn.equals("")) {
            throw new InvalidDestinationException(prAccessor.getString("URL_INVALID_SYNTAX"));
        }
        if (dsn.indexOf("#") != -1 || dsn.indexOf("*") != -1) {
            throw new InvalidDestinationException(prAccessor.getString("URL_INVALID_CHAR"));
        }
        return true;
    }

    public static final Destination createDestination(String routing, ISubject subject) throws JMSException {
        if ((subject = subject.clearSubjectTracking()).isMultiSubject()) {
            return new MultiTopic(routing, (Subject)subject.protectedClone());
        }
        if (subject.isQueue()) {
            return new Queue(routing, subject);
        }
        return new Topic(routing, subject);
    }
}

