/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.util.jclient.StreamMessageInputStream;
import progress.message.util.jclient.StreamMessageOutputStream;
import progress.message.zclient.Envelope;

public class MapMessage
extends Message
implements progress.message.jclient.MapMessage {
    private transient HashMap m_values = new HashMap();

    MapMessage(Envelope envelope) throws IOException, MessageFormatException {
        super(envelope);
        if (this.m_zenvelope.getMessage().cap() != 0) {
            this.m_zenvelope.getMessage().gotoByte(0);
        }
        int size = this.m_zenvelope.getMessage().readInt();
        StreamMessageInputStream in = new StreamMessageInputStream(this.m_zenvelope.getMessage());
        for (int i = 0; i < size; ++i) {
            String name = in.readString();
            Object value = in.readObject();
            this.m_values.put(name, value);
        }
    }

    public MapMessage() {
        super((short)3);
    }

    @Override
    public Object clone() {
        MapMessage msg = (MapMessage)super.clone();
        msg.m_values = (HashMap)this.m_values.clone();
        return msg;
    }

    @Override
    public Object protectedClone() {
        MapMessage msg = (MapMessage)super.protectedClone();
        msg.m_values = (HashMap)this.m_values.clone();
        return msg;
    }

    @Override
    public boolean getBoolean(String name) throws JMSException {
        Object value = this.m_values.get(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return ((String)value).equalsIgnoreCase("true");
        }
        throw new MessageFormatException("");
    }

    @Override
    public byte getByte(String name) throws JMSException {
        Object value = this.m_values.get(name);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        throw new MessageFormatException("");
    }

    @Override
    public short getShort(String name) throws JMSException {
        Object value = this.m_values.get(name);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).byteValue();
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        throw new MessageFormatException("");
    }

    @Override
    public char getChar(String name) throws JMSException {
        Object value = this.m_values.get(name);
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        throw new MessageFormatException("");
    }

    @Override
    public int getInt(String name) throws JMSException {
        Object value = this.m_values.get(name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new MessageFormatException("");
    }

    @Override
    public long getLong(String name) throws JMSException {
        Object value = this.m_values.get(name);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new MessageFormatException("");
    }

    @Override
    public float getFloat(String name) throws JMSException {
        Object value = this.m_values.get(name);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.valueOf((String)value).floatValue();
        }
        throw new MessageFormatException("");
    }

    @Override
    public double getDouble(String name) throws JMSException {
        Object value = this.m_values.get(name);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        throw new MessageFormatException("");
    }

    @Override
    public String getString(String name) throws JMSException {
        Object value = this.m_values.get(name);
        if (value instanceof Boolean) {
            return String.valueOf((Boolean)value);
        }
        if (value instanceof Byte) {
            return String.valueOf((Byte)value);
        }
        if (value instanceof Character) {
            return String.valueOf((Character)value);
        }
        if (value instanceof Double) {
            return String.valueOf((Double)value);
        }
        if (value instanceof Float) {
            return String.valueOf((Float)value);
        }
        if (value instanceof Integer) {
            return String.valueOf((Integer)value);
        }
        if (value instanceof Long) {
            return String.valueOf((Long)value);
        }
        if (value instanceof Short) {
            return String.valueOf((Short)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return null;
        }
        throw new MessageFormatException("");
    }

    @Override
    public byte[] getBytes(String name) throws JMSException {
        Object value = this.m_values.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new MessageFormatException("");
    }

    @Override
    public Object getObject(String name) throws JMSException {
        return this.m_values.get(name);
    }

    @Override
    public Enumeration getMapNames() throws JMSException {
        Set names = this.m_values.keySet();
        return new Vector(names).elements();
    }

    @Override
    public void setBoolean(String name, boolean value) throws JMSException {
        this.assertWriteEnabled();
        this.assertSettableMapName(name);
        this.m_values.put(name, new Boolean(value));
    }

    @Override
    public void setByte(String name, byte value) throws JMSException {
        this.assertWriteEnabled();
        this.assertSettableMapName(name);
        this.m_values.put(name, new Byte(value));
    }

    @Override
    public void setShort(String name, short value) throws JMSException {
        this.assertWriteEnabled();
        this.assertSettableMapName(name);
        this.m_values.put(name, new Short(value));
    }

    @Override
    public void setChar(String name, char value) throws JMSException {
        this.assertWriteEnabled();
        this.assertSettableMapName(name);
        this.m_values.put(name, new Character(value));
    }

    @Override
    public void setInt(String name, int value) throws JMSException {
        this.assertWriteEnabled();
        this.assertSettableMapName(name);
        this.m_values.put(name, new Integer(value));
    }

    @Override
    public void setLong(String name, long value) throws JMSException {
        this.assertWriteEnabled();
        this.assertSettableMapName(name);
        this.m_values.put(name, new Long(value));
    }

    @Override
    public void setFloat(String name, float value) throws JMSException {
        this.assertWriteEnabled();
        this.assertSettableMapName(name);
        this.m_values.put(name, new Float(value));
    }

    @Override
    public void setDouble(String name, double value) throws JMSException {
        this.assertWriteEnabled();
        this.assertSettableMapName(name);
        this.m_values.put(name, new Double(value));
    }

    @Override
    public void setString(String name, String value) throws JMSException {
        this.assertWriteEnabled();
        this.assertSettableMapName(name);
        this.m_values.put(name, value);
    }

    @Override
    public void setBytes(String name, byte[] value) throws JMSException {
        this.assertWriteEnabled();
        this.assertSettableMapName(name);
        this.m_values.put(name, value);
    }

    @Override
    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.assertWriteEnabled();
        this.assertSettableMapName(name);
        byte[] buf = new byte[length];
        System.arraycopy(value, offset, buf, 0, length);
        this.m_values.put(name, buf);
    }

    @Override
    public void setObject(String name, Object value) throws JMSException {
        this.assertWriteEnabled();
        this.assertSettableMapName(name);
        this.m_values.put(name, value);
    }

    @Override
    public boolean itemExists(String name) throws JMSException {
        return this.m_values.containsKey(name);
    }

    @Override
    public void marshal() throws JMSException {
        this.m_zenvelope.getMessage().setBody(null);
        this.m_zenvelope.getMessage().writeInt(this.m_values.size());
        StreamMessageOutputStream out = new StreamMessageOutputStream(this.m_zenvelope.getMessage());
        Set names = this.m_values.keySet();
        Enumeration elements = new Vector(names).elements();
        while (elements.hasMoreElements()) {
            try {
                String key = (String)elements.nextElement();
                out.writeString(key);
                out.writeObject(this.m_values.get(key));
            }
            catch (IOException e) {
                throw JMSExceptionUtil.createJMSException(e);
            }
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.m_values = new HashMap();
    }

    private void assertSettableMapName(String name) throws JMSException, IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Property names cannot be null or empty strings");
        }
    }

    private void assertWriteEnabled() throws MessageNotWriteableException {
        if (this.m_bodyReadOnly) {
            throw new MessageNotWriteableException("Message body is Read-Only");
        }
    }
}

