/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Hashtable;
import javax.jms.JMSException;
import progress.message.client.EDefaultHandlerNotSet;
import progress.message.client.EGeneralException;
import progress.message.client.EInvalidApplicationId;
import progress.message.client.EInvalidUserId;
import progress.message.client.prAccessor;
import progress.message.jclient.RejectionListener;
import progress.message.jimpl.Connection;
import progress.message.jimpl.IPSControl;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.RejectionProcessor;
import progress.message.zclient.MessageHandler;

public class ZConnectionFactory {
    static String PSCONTROL_CLASSNAME = "progress.message.sf.SaveAndRestoreSupportManager";
    Connection m_connection;
    boolean m_persistenceEnabled;
    Hashtable m_env;
    IPSControl m_psControl;

    public ZConnectionFactory(Connection conn, Hashtable env, String inputConnectId) throws JMSException {
        Boolean value;
        this.m_connection = conn;
        this.m_env = env;
        this.m_persistenceEnabled = env == null ? false : ((value = (Boolean)this.m_env.get("EnableLocalStore")) == null ? false : value);
        if (this.m_persistenceEnabled) {
            try {
                Class<?> c = Class.forName(PSCONTROL_CLASSNAME);
                Class[] argTypes = new Class[]{Hashtable.class, progress.message.jclient.Connection.class, String.class};
                Constructor<?> constructor = c.getConstructor(argTypes);
                Object[] argValues = new Object[]{this.m_env, conn, inputConnectId};
                Object control = constructor.newInstance(argValues);
                this.m_psControl = (IPSControl)control;
            }
            catch (InvocationTargetException ite) {
                try {
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("LOAD_CLASS_FAILED") + PSCONTROL_CLASSNAME, Integer.toString(-4001), (Exception)ite.getTargetException());
                }
                catch (ClassCastException cce) {
                    throw JMSExceptionUtil.createJMSException(prAccessor.getString("LOAD_CLASS_FAILED") + PSCONTROL_CLASSNAME, Integer.toString(-4001), ite);
                }
            }
            catch (Exception e) {
                throw JMSExceptionUtil.createJMSException(prAccessor.getString("LOAD_CLASS_FAILED") + PSCONTROL_CLASSNAME, Integer.toString(-4001), e);
            }
        }
    }

    public progress.message.zclient.Connection createZConnection(String appId, Principal principal, MessageHandler defaultMessageHandler, boolean recoverable, RejectionProcessor rejectionProc) throws EGeneralException, EDefaultHandlerNotSet, EInvalidApplicationId, EInvalidUserId {
        progress.message.zclient.Connection zconn = null;
        zconn = recoverable && this.m_persistenceEnabled ? this.m_psControl.createZConnection(appId, principal, defaultMessageHandler, rejectionProc) : new progress.message.zclient.Connection(appId, principal, defaultMessageHandler);
        return zconn;
    }

    void setRejectionListener(RejectionListener listener) {
        if (this.m_persistenceEnabled) {
            this.m_psControl.setRejectionListener(listener);
        }
    }

    boolean isPersistenceEnabled() {
        return this.m_persistenceEnabled;
    }
}

