/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import progress.message.client.ESecurityGeneralException;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IMgram;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.DefaultPayload;
import progress.message.msg.v26.Mgram;
import progress.message.util.StreamUtil;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.ESecurityInvalidLogistics;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.SecurityLogic;

public class BatchPayload
extends DefaultPayload
implements IBatchHandle {
    private ArrayList m_perMsgEncList = null;
    private byte m_batchBitField;
    private int m_tid = -1;
    static final int ATOMIC_MASK = 1;
    static final int HAS_ANY_TTE_MASK = 2;
    static final int HAS_TID_MASK = 3;

    public BatchPayload(Mgram m) {
        super(m);
    }

    public BatchPayload(BatchPayload bp, Mgram m) {
        super(bp, m);
        this.m_perMsgEncList = bp.m_perMsgEncList;
        this.m_batchBitField = bp.m_batchBitField;
        this.m_tid = bp.m_tid;
    }

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        BatchPayload bp = new BatchPayload(this, m);
        this.cloneInternalData(bp);
        this.retrieveMPerMsgEncList();
        return bp;
    }

    @Override
    public Object shallowClone(Mgram m) throws CloneNotSupportedException {
        BatchPayload bp = new BatchPayload(this, m);
        this.shallowCloneInternalData(bp);
        this.retrieveMPerMsgEncList();
        return bp;
    }

    private void retrieveMPerMsgEncList() {
        if (this.m_perMsgEncList != null) {
            this.m_perMsgEncList = (ArrayList)this.m_perMsgEncList.clone();
        }
    }

    @Override
    public Object protectedClone(Mgram m) throws CloneNotSupportedException {
        this.protectAll();
        BatchPayload dp = new BatchPayload(this, m);
        this.protectedCloneInternalData(dp);
        this.retrieveMPerMsgEncList();
        return dp;
    }

    @Override
    public boolean isPubSub() {
        return this.getOperationType() == 0;
    }

    @Override
    public boolean isPTP() {
        return this.getOperationType() == 1;
    }

    @Override
    public LinkedList getMgramList() {
        return super.getMgramListInternal();
    }

    @Override
    public void syncBatch() {
        this.syncSharedFields();
        this.syncSecurityFields();
    }

    @Override
    public Iterator getBatchIterator() {
        LinkedList ll = super.getMgramListInternal();
        if (ll != null) {
            return ll.iterator();
        }
        return null;
    }

    @Override
    public int getBatchSize() {
        LinkedList ll = super.getMgramListInternal();
        if (ll == null) {
            return 0;
        }
        return ll.size();
    }

    void setFirstMgram(IMgram m) {
        this.setSharedFields(m, this.m_mgram);
        this.setSecurityFields(m, this.m_mgram);
        if (m.isTTE()) {
            this.m_mgram.setTTE(m.getTTE());
            this.setHasAnyTTE(true);
        }
        this.m_mgram.setPriority(m.getPriority());
        this.m_mgram.setJMSPersistent(m.isJMSPersistent());
        this.m_mgram.setNonPersistentReplicated(m.isNonPersistentReplicated());
        this.m_mgram.setRouteLimit(m.getRouteLimit());
        if (m.isPTP()) {
            this.m_mgram.getOperationHandle().setOperationType(1);
        } else if (m.isPubSub()) {
            this.m_mgram.getOperationHandle().setOperationType(0);
        }
        if (m.getJMSClientHandle().isPerMsgEncrypted()) {
            if (this.m_perMsgEncList == null) {
                this.m_perMsgEncList = new ArrayList();
            }
            this.m_perMsgEncList.add(m);
        }
        super.addMgram(m);
    }

    @Override
    public void addMgram(IMgram m) {
        if (m.isJMSPersistent() && !this.m_mgram.isJMSPersistent()) {
            this.m_mgram.setJMSPersistent(true);
        }
        if (m.getPriority() > this.m_mgram.getPriority()) {
            this.m_mgram.setPriority(m.getPriority());
        }
        if (m.isTTE()) {
            this.setHasAnyTTE(true);
        }
        if (m.isTTE() && this.m_mgram.isTTE()) {
            long newTTE = m.getTTE();
            if (this.m_mgram.getTTE() < newTTE) {
                this.m_mgram.setTTE(newTTE);
            }
        } else if (this.m_mgram.isTTE() && !m.isTTE()) {
            this.m_mgram.removeTTE();
        }
        if (m.getJMSClientHandle().isPerMsgEncrypted()) {
            if (this.m_perMsgEncList == null) {
                this.m_perMsgEncList = new ArrayList();
            }
            this.m_perMsgEncList.add(m);
        }
        super.addMgram(m);
    }

    @Override
    public int getDurableBatchSerializedLength() {
        if (this.getMgramListInternal() == null || this.getMgramListInternal().size() == 0) {
            return 0;
        }
        int result = 0;
        for (IMgram subMgram : this.getMgramListInternal()) {
            int size = subMgram.getBrokerHandle().getTrackedSize();
            subMgram.getBrokerHandle().setTrackedSize(size);
            result += size;
        }
        return result;
    }

    @Override
    public byte[] encryptMessageWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.syncSecurityFields();
        this.syncSharedFields();
        return super.encryptMessageWithMessageKey(mp);
    }

    @Override
    public void macMgramListMessagesWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.syncSecurityFields();
        this.syncSharedFields();
        super.macMgramListMessagesWithMessageKey(mp);
    }

    @Override
    public void macMgramListHeadersWithMessageKey(IMessageProtection mp) throws ESecurityGeneralException {
        this.syncSecurityFields();
        this.syncSharedFields();
        super.macMgramListHeadersWithMessageKey(mp);
    }

    @Override
    boolean supportsOperationHandle() {
        return true;
    }

    @Override
    void setType(byte type) {
        switch (type) {
            case 12: {
                this.m_mgram.getOperationHandle().setOperationType(1);
                this.syncTypeFields(type);
                break;
            }
            case 2: {
                this.m_mgram.getOperationHandle().setOperationType(0);
                this.syncTypeFields(type);
                break;
            }
        }
    }

    private void syncSecurityFields() {
        LinkedList mgramList = this.getMgramListInternal();
        if (mgramList != null && !mgramList.isEmpty()) {
            for (Mgram m : mgramList) {
                if (m.isPerMsgEncrypted()) continue;
                this.setSecurityFields(this.m_mgram, m);
            }
        }
    }

    private void syncSharedFields() {
        LinkedList mgramList = this.getMgramListInternal();
        if (mgramList != null && !mgramList.isEmpty()) {
            for (Mgram m : mgramList) {
                this.setSharedFields(this.m_mgram, m);
            }
        }
    }

    private void syncTypeFields(byte type) {
        LinkedList mgramList = this.getMgramListInternal();
        if (mgramList != null && !mgramList.isEmpty()) {
            for (Mgram m : mgramList) {
                m.setType(type);
            }
        }
    }

    private void setSharedFields(IMgram origMgram, IMgram targetMgram) {
        if (targetMgram.isSecure() && targetMgram.getBrokerHandle().isEncrypted()) {
            return;
        }
        if (origMgram.hasTxn()) {
            targetMgram.setTxn(origMgram.getTxnId());
        }
        if (origMgram.getBrokerHandle().isTransactionalPublish()) {
            if (origMgram.getBrokerHandle().isTxnPublishFromLog()) {
                targetMgram.getBrokerHandle().setTxnPublishFromLog(true);
            }
            targetMgram.getBrokerHandle().setTxnPublish(origMgram.getBrokerHandle().getTxnPublishTid(), origMgram.getBrokerHandle().getTxnPublishTidSeqNo());
        }
        targetMgram.getBrokerHandle().setSenderID(origMgram.getBrokerHandle().getSenderID());
        targetMgram.getBrokerHandle().setFromRemoteBroker(origMgram.getBrokerHandle().isFromRemoteBroker());
        if (targetMgram.getSubject() == null || !targetMgram.getSubject().hasSubjectTracking()) {
            targetMgram.setSubject(origMgram.getSubject().protectedClone(), origMgram.getSubjectFormat());
        }
        if (targetMgram.getBrokerHandle().getSubjectFilters() == null) {
            targetMgram.getBrokerHandle().setSubjectFilters(origMgram.getBrokerHandle().getSubjectFilters());
        }
        targetMgram.getRoutingHandle().setRouting(origMgram.getRoutingHandle().getAllRoutingString());
        targetMgram.getRoutingHandle().setGSAPublication(origMgram.getRoutingHandle().isGSAPublication());
        targetMgram.setChannel(origMgram.getChannel());
        targetMgram.setRouteLimit(origMgram.getRouteLimit());
        targetMgram.setSuccessor(origMgram.isSuccessor());
    }

    private void setSecurityFields(IMgram origMgram, IMgram targetMgram) {
        if (origMgram.isSecure()) {
            targetMgram.setMgramSecure(origMgram.getMessageProtection());
            targetMgram.setSecurityAttribute(origMgram.getSecurity());
            targetMgram.setMessageKey(origMgram.getMessageKey());
        }
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        super.writeToStream(os);
    }

    @Override
    protected void writeToStream(OutputStream os, StreamUtilCounter sc) throws IOException {
        super.writeToStream(os, sc);
    }

    @Override
    public void writePreSecureData(OutputStream os) throws IOException {
        StreamUtil.writeByte(this.m_batchBitField, os);
        if ((this.m_batchBitField & 3) > 0) {
            StreamUtil.writeInt(this.m_tid, os);
        }
    }

    @Override
    public void readPreSecureData(InputStream is) throws IOException {
        this.m_batchBitField = StreamUtil.readByte(is);
        if ((this.m_batchBitField & 3) > 0) {
            this.m_tid = StreamUtil.readInt(is);
        }
    }

    @Override
    public void syncPerMsgEnc(ClientSecurityContext csc, IMessageProtection mp) throws ESecurityInvalidLogistics {
        if (this.m_perMsgEncList != null && !this.m_perMsgEncList.isEmpty()) {
            byte protection = SecurityLogic.AttribsFromPublic((byte)1, (byte)2);
            for (int count = 0; count < this.m_perMsgEncList.size(); ++count) {
                IMgram m = (IMgram)this.m_perMsgEncList.get(count);
                m.setMgramSecure(mp);
                m.setSecurityAttribute(protection);
            }
        }
    }

    @Override
    public void setAtomic(boolean b) {
        this.m_batchBitField = b ? (byte)(this.m_batchBitField | 1) : (byte)(this.m_batchBitField & 0xFFFFFFFE);
    }

    private void setHasAnyTTE(boolean b) {
        this.m_batchBitField = b ? (byte)(this.m_batchBitField | 2) : (byte)(this.m_batchBitField & 0xFFFFFFFD);
    }

    @Override
    public boolean isAtomic() {
        return (this.m_batchBitField & 1) > 0;
    }

    @Override
    public boolean hasAnyTTE() {
        return (this.m_batchBitField & 2) > 0;
    }

    @Override
    public IBatchHandle getBatchHandle() {
        return this;
    }

    public void setTid(int tid) {
        this.m_batchBitField = (byte)(this.m_batchBitField | 3);
        this.m_tid = tid;
    }

    @Override
    public boolean hasTid() {
        return (this.m_batchBitField & 3) > 0;
    }

    @Override
    public int getTid() {
        return this.m_tid;
    }

    @Override
    public void secureHeader(IMessageProtection mp) throws ESecurityGeneralException {
        if (this.m_mgram.isSecure()) {
            byte security = this.m_mgram.getSecurity();
            if (SecurityLogic.isMKeyEncryption(security)) {
                this.m_mgram.macPrimaryMessageWithMessageKey(mp);
                this.encryptPrimaryMgramWithMessageKey(mp);
            } else if (SecurityLogic.isMKeyMacHeader(security)) {
                this.m_mgram.macPrimaryHeaderWithMessageKey(mp);
            } else if (SecurityLogic.isMKeyDigest(security)) {
                this.m_mgram.macPrimaryMessageWithMessageKey(mp);
            }
        }
    }

    @Override
    public void syncBatchSecurity() {
        this.syncSecurityFields();
    }
}

