/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.msg.IConnectionSyncHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v26.DefaultPayload;
import progress.message.msg.v26.Mgram;
import progress.message.util.AutoVec;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.xonce.ConnectionSyncData;

final class ConnectionSyncPayload
extends DefaultPayload
implements IConnectionSyncHandle {
    private AutoVec m_syncData;
    boolean m_syncd = false;

    public ConnectionSyncPayload(Mgram m) {
        super(m);
    }

    public ConnectionSyncPayload(ConnectionSyncPayload csp, Mgram m) {
        super(m);
        this.m_syncData = csp.m_syncData;
        this.m_syncd = csp.m_syncd;
    }

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        ConnectionSyncPayload csp = new ConnectionSyncPayload(this, m);
        this.cloneInternalData(csp);
        return csp;
    }

    @Override
    public Object shallowClone(Mgram m) throws CloneNotSupportedException {
        ConnectionSyncPayload csp = new ConnectionSyncPayload(this, m);
        this.shallowCloneInternalData(csp);
        return csp;
    }

    @Override
    public Object protectedClone(Mgram m) throws CloneNotSupportedException {
        this.protectAll();
        ConnectionSyncPayload csp = new ConnectionSyncPayload(this, m);
        this.protectedCloneInternalData(csp);
        return csp;
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        super.initPayloadFromStream(is, sc);
        ObjectInput dis = this.getPayloadInputStreamHandle();
        this.m_syncData = new AutoVec();
        while (true) {
            ConnectionSyncData csd = null;
            try {
                csd = ConnectionSyncData.deserialize(dis);
                this.m_syncData.setElementAt(csd, csd.getChannel());
            }
            catch (EOFException e) {
                return;
            }
        }
    }

    @Override
    protected void syncPayload() {
        if (this.m_syncd) {
            return;
        }
        ObjectOutput os = this.getPayloadOutputStreamHandle();
        try {
            for (int i = 0; i < this.m_syncData.size(); ++i) {
                ConnectionSyncData c = (ConnectionSyncData)this.m_syncData.elementAt(i);
                if (c == null) continue;
                c.serialize(os);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_syncd = true;
        super.sync();
    }

    @Override
    public AutoVec getConnectionSyncData() {
        return this.m_syncData;
    }

    @Override
    public void setConnectionSyncData(AutoVec sync) {
        this.m_syncData = sync;
    }

    @Override
    public IConnectionSyncHandle getConnectionSyncHandle() {
        return this;
    }

    @Override
    public String summaryString() {
        StringBuffer sb = new StringBuffer();
        boolean needSeparator = false;
        for (int i = 0; i < this.m_syncData.size(); ++i) {
            if (this.m_syncData.elementAt(i) == null) continue;
            sb.append((needSeparator ? "," : "") + this.m_syncData.elementAt(i).toString());
            needSeparator = true;
        }
        return sb.toString();
    }
}

