/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v26;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import progress.message.util.ArrayUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.SessionConfig;

public final class StaticHeader
implements Cloneable {
    private static final byte JMS_PERSIST_MASK = 4;
    private static final byte TXN_MASK = 8;
    private static final byte SUCSR_MASK = 16;
    private static final byte TXNPUBLISH_MASK = 32;
    private static final byte REJECTABLE_MASK = 64;
    private static final int RTE_MASK1 = 3;
    private static final int RTE_SHIFT1 = 1;
    private static final int INSTRUMENTED_MASK = 128;
    private static final byte GUAR_MASK = 4;
    private static final byte TTE_MASK = 8;
    private static final int SECURITY_MASK = 16;
    private static final byte DISCARDABLE_MASK = 32;
    private static final byte ID_MASK = 64;
    private static final byte RRS_MASK = 3;
    private static final int RTE_MASK2 = 128;
    private static final int RTE_SHIFT2 = 7;
    private static final byte POST_V22_MASK = 1;
    private static final byte HAS_SESSION_VER_MASK = 2;
    private static final byte HAS_STRM_VER_MASK = 4;
    private static final byte COMPRESSION_MASK = 8;
    public static final int HEADER_LEN = 20;
    private static final int s_versionLoc = 0;
    private static final int s_typeLoc = 1;
    private static final int s_priorityLoc = 2;
    private static final int s_versionFlagsLoc = 2;
    private static final int s_postSV22Loc = 2;
    private static final int s_sessionVersByteLoc = 2;
    private static final int s_hasStreamVersLoc = 2;
    private static final int s_streamVersLoc = 3;
    private static final int s_streamFlagsLoc = 4;
    private static final int s_compressionIdLoc = 5;
    private static final int s_bitField1Loc = 5;
    private static final int s_bitField2Loc = 6;
    private static final int s_afByteLoc = 7;
    private static final int s_tteLoc = 8;
    private static final int s_channelLoc = 16;
    private static byte[] s_defaultStaticHeader = StaticHeader.buildDefaultStaticHeader();

    public StaticHeader clone() throws CloneNotSupportedException {
        return (StaticHeader)super.clone();
    }

    static void writeToStream(OutputStream os, byte[] buffer, int channel, boolean tteTTLConvert) throws IOException {
        os.write(buffer, 0, 8);
        long tte = StaticHeader.getTTE(buffer);
        if (tteTTLConvert && StaticHeader.hasTTE(buffer)) {
            StreamUtil.writeLong(tte - System.currentTimeMillis(), os);
        } else {
            StreamUtil.writeLong(tte, os);
        }
        if (channel != -1) {
            StreamUtil.writeInt(channel, os);
        } else {
            os.write(buffer, 16, 4);
        }
    }

    static void setPostV22(boolean value, byte[] buffer) {
        buffer[2] = value ? (byte)(buffer[2] | 1) : (byte)(buffer[2] & 0xFFFFFFFE);
    }

    static void setSessionVer(byte ver, byte[] buffer) {
        buffer[2] = (byte)(buffer[2] | 2);
    }

    static boolean hasStreamVersion(byte[] buffer) {
        return (buffer[2] & 4) > 0;
    }

    static byte getStreamVersion(byte[] buffer) {
        return buffer[3];
    }

    static void setStreamVersion(byte value, byte[] buffer) {
        buffer[2] = (byte)(buffer[2] & 0xFFFFFFFB);
        if (value != 0) {
            buffer[2] = (byte)(buffer[2] | 4);
        }
        buffer[3] = value;
    }

    static byte getStreamFlags(byte[] buffer) {
        return buffer[4];
    }

    static void setStreamFlags(byte value, byte[] buffer) {
        buffer[4] = value;
    }

    static void setCompressionEnabled(boolean value, byte[] buffer) {
        buffer[2] = value ? (byte)(buffer[2] | 8) : (byte)(buffer[2] & 0xFFFFFFF7);
    }

    static boolean isCompressionEnabled(byte[] buffer) {
        return (buffer[2] & 8) > 0;
    }

    static byte getCompressionId(byte[] buffer) {
        return buffer[5];
    }

    static void setCompressionId(byte id, byte[] buffer) {
        buffer[5] = id;
    }

    static boolean isRequest(byte[] buffer) {
        return StaticHeader.getRequestReplyFieldType(buffer) == 2;
    }

    static boolean isSend(byte[] buffer) {
        return StaticHeader.getRequestReplyFieldType(buffer) == 0;
    }

    static boolean isPostSV22(byte[] buffer) {
        return (buffer[2] & 1) > 0;
    }

    static boolean hasSessionVer(byte[] buffer) {
        return (buffer[2] & 2) > 0;
    }

    static boolean isReply(byte[] buffer) {
        return StaticHeader.getRequestReplyFieldType(buffer) == 3;
    }

    static boolean isSecure(byte[] buffer) {
        return (buffer[6] & 0x10) != 0;
    }

    static void setMgramSecure(boolean isSecure, byte[] buffer) {
        buffer[6] = (byte)(buffer[6] & 0xFFFFFFEF);
        if (isSecure) {
            buffer[6] = (byte)(buffer[6] | 0x10);
        }
    }

    public static final void setPriority(byte value, byte[] buffer) {
        buffer[2] = value;
    }

    static boolean hasID(byte[] buffer) {
        return (buffer[6] & 0x40) != 0;
    }

    static void enableID(byte[] buffer) {
        buffer[6] = (byte)(buffer[6] | 0x40);
    }

    static boolean hasTTE(byte[] buffer) {
        return (buffer[6] & 8) != 0;
    }

    static void enableTTE(boolean value, byte[] buffer) {
        buffer[6] = (byte)(buffer[6] & 0xFFFFFFF7);
        if (value) {
            buffer[6] = (byte)(buffer[6] | 8);
        }
    }

    static boolean isGuarenteed(byte[] buffer) {
        return (buffer[6] & 4) > 0;
    }

    static void setGuarenteed(boolean val, byte[] buffer) {
        buffer[6] = (byte)(buffer[6] & 0xFFFFFFFB);
        if (val) {
            buffer[6] = (byte)(buffer[6] | 4);
        }
    }

    static boolean hasTxn(byte[] buffer) {
        return (buffer[5] & 8) != 0;
    }

    static void setTTE(long value, byte[] buffer) {
        if (value == 0L) {
            StaticHeader.enableTTE(false, buffer);
        } else {
            StaticHeader.enableTTE(true, buffer);
            ArrayUtil.writeLong(buffer, 8, value);
        }
    }

    static void setTxn(boolean val, byte[] buffer) {
        buffer[5] = (byte)(buffer[5] & 0xFFFFFFF7);
        if (val) {
            buffer[5] = (byte)(buffer[5] | 8);
        }
    }

    static void setTxnPublish(boolean value, byte[] buffer) {
        buffer[5] = (byte)(buffer[5] & 0xFFFFFFDF);
        if (value) {
            buffer[5] = (byte)(buffer[5] | 0x20);
        }
    }

    static boolean isTxnPublish(byte[] buffer) {
        return (buffer[5] & 0x20) != 0;
    }

    static final void setRejectable(boolean value, byte[] buffer) {
        buffer[5] = (byte)(buffer[5] & 0xFFFFFFBF);
        if (value) {
            buffer[5] = (byte)(buffer[5] | 0x40);
        }
    }

    static final boolean isRejectable(byte[] buffer) {
        return (buffer[5] & 0x40) != 0;
    }

    static final void setInstrumented(boolean value, byte[] buffer) {
        buffer[5] = (byte)(buffer[5] & 0x7F);
        if (value) {
            buffer[5] = (byte)(buffer[5] | 0xFFFFFF80);
        }
    }

    static final boolean isInstrumented(byte[] buffer) {
        return (buffer[5] & 0x80) != 0;
    }

    static int getDestinationAddressFormat(byte[] buffer) {
        return buffer[7] & 0xF;
    }

    static void clearAddresses(byte[] buffer) {
        StaticHeader.setDestinationAddressFormat(0, buffer);
    }

    static int getRequestReplyFieldType(byte[] buffer) {
        return buffer[6] & 3 & 0xFF;
    }

    static int getRouteLimit(byte[] buffer) {
        return (buffer[5] & 3) << 1 | (buffer[6] & 0x80) >>> 7;
    }

    static long getTTE(byte[] buffer) {
        return ArrayUtil.readLong(buffer, 8);
    }

    static void setRouteLimit(int routeLimit, byte[] buffer) {
        buffer[5] = (byte)(buffer[5] & 0xFFFFFFFC);
        buffer[6] = (byte)(buffer[6] & 0xFFFFFF7F);
        buffer[5] = (byte)(buffer[5] | (routeLimit & 6) >> 1);
        buffer[6] = (byte)(buffer[6] | (routeLimit & 1) << 7);
    }

    static boolean isSucessor(byte[] buffer) {
        return (buffer[5] & 0x10) != 0;
    }

    static void setSucessor(boolean value, byte[] buffer) {
        buffer[5] = (byte)(buffer[5] & 0xFFFFFFEF);
        if (value) {
            buffer[5] = (byte)(buffer[5] | 0x10);
        }
    }

    static boolean isJMSPersistent(byte[] buffer) {
        return (buffer[5] & 4) != 0;
    }

    static void setJMSPersistent(boolean value, byte[] buffer) {
        buffer[5] = (byte)(buffer[5] & 0xFFFFFFFB);
        if (value) {
            buffer[5] = (byte)(buffer[5] | 4);
        }
    }

    static void setDiscardable(boolean value, byte[] buffer) {
        buffer[6] = (byte)(buffer[6] & 0xFFFFFFDF);
        if (value) {
            buffer[6] = (byte)(buffer[6] | 0x20);
        }
    }

    static boolean isDiscardable(byte[] buffer) {
        return (buffer[6] & 0x20) != 0;
    }

    static final byte getType(byte[] buffer) {
        return buffer[1];
    }

    public static final void setType(byte type, byte[] buffer) {
        buffer[1] = type;
    }

    static int getChannel(byte[] buffer) {
        return ArrayUtil.readInt(buffer, 16);
    }

    public static final void setChannel(int channel, byte[] buffer) {
        ArrayUtil.writeInt(buffer, 16, channel);
    }

    static byte getPriority(byte[] buffer) {
        return buffer[2];
    }

    public static final void setRequestReplyType(int value, byte[] buffer) {
        buffer[6] = (byte)(buffer[6] & 0xFFFFFFFC);
        buffer[6] = (byte)(buffer[6] | (byte)(value & 3));
    }

    static void setDestinationAddressFormat(int daf, byte[] buffer) {
        buffer[7] = (byte)(daf & 0xF);
    }

    static boolean canHaveReplyTracking(byte[] buffer) {
        int rrs = StaticHeader.getRequestReplyFieldType(buffer);
        return rrs == 3;
    }

    private static byte[] buildDefaultStaticHeader() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            os.write(26);
            os.write(2);
            os.write(0);
            os.write(0);
            os.write(0);
            os.write(0);
            os.write(0);
            os.write(0);
            StreamUtil.writeLong(0L, os);
            StreamUtil.writeInt(0, os);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return os.toByteArray();
    }

    public static byte[] getDefaultByteArray() {
        byte[] result = new byte[20];
        System.arraycopy(s_defaultStaticHeader, 0, result, 0, s_defaultStaticHeader.length);
        return result;
    }

    static byte getVersion(byte[] buffer) {
        return buffer[0];
    }

    static void setVersion(byte version, byte[] buffer) {
        buffer[0] = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dump(byte[] buffer) {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.println("Mgram Version: " + StaticHeader.getVersion(buffer));
            StaticHeader.printMgramType(buffer);
            byte type = StaticHeader.getType(buffer);
            if (type == 4) {
                StaticHeader.printVersionMgramFlags(buffer);
                log.println("Stream Version: " + StaticHeader.getStreamVersion(buffer));
                log.println("Stream Flags  : " + StaticHeader.getStreamFlags(buffer));
                if (StaticHeader.isCompressionEnabled(buffer)) {
                    log.println("Compression Id: " + StaticHeader.getCompressionId(buffer));
                }
                log.println("Channel       : " + StaticHeader.getChannel(buffer));
                return;
            }
            log.println("Mgram Priority: " + StaticHeader.getPriority(buffer));
            StaticHeader.printMgramFlags(buffer);
            StaticHeader.printMgramDestinationAddressFormat(buffer);
            StaticHeader.printMgramExpirationDate(buffer);
            log.println("Channel: " + StaticHeader.getChannel(buffer));
            log.println(StaticHeader.isSecure(buffer) ? "Mgram is Secure" : "Mgram is NOT secure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printMgramType(byte[] buffer) {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Mgam Type: ");
            byte type = StaticHeader.getType(buffer);
            switch (type) {
                case 3: {
                    log.println("ACK");
                    break;
                }
                case 2: {
                    log.println("NORMAL");
                    break;
                }
                case -1: {
                    log.println("ERROR");
                    break;
                }
                case 1: {
                    log.println("CONNECT");
                    break;
                }
                case 4: {
                    log.println("VERSION");
                    break;
                }
                case 0: {
                    log.println("PING");
                    break;
                }
                case 7: {
                    log.println("DISCONNECT");
                    break;
                }
                case 5: {
                    log.println("IB_CONVERT");
                    break;
                }
                case 6: {
                    log.println("FLOW_CONTROL_TYPE");
                    break;
                }
                case 14: {
                    log.println("QUEUE_ACK");
                    break;
                }
                case 13: {
                    log.println("QUEUE_GET");
                    break;
                }
                case 11: {
                    log.println("QUEUE_ACKFORWARD");
                    break;
                }
                case 12: {
                    log.println("QUEUE_NORMAL");
                    break;
                }
                case 20: {
                    log.println("NACK_TYPE");
                    break;
                }
                case 18: {
                    log.println("BLOCK_TYPE");
                    break;
                }
                case 19: {
                    log.println("RESUME_TYPE");
                    break;
                }
                default: {
                    log.println("UNKNOWN TYPE " + type);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printMgramDestinationAddressFormat(byte[] buffer) {
        PrintStream log = SessionConfig.getLog();
        int daf = StaticHeader.getDestinationAddressFormat(buffer);
        PrintStream printStream = log;
        synchronized (printStream) {
            log.print("Destination Address Format: ");
            StaticHeader.printAddressFormat(daf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printAddressFormat(int format) {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            switch (format) {
                case 0: {
                    log.println("NONE");
                    break;
                }
                case 1: {
                    log.println("AF_STRING");
                    break;
                }
                case 2: {
                    log.println("AF_FIXED");
                    break;
                }
                case 3: {
                    log.println("AF_VAR");
                    break;
                }
                default: {
                    log.println("UNKNOWN");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printVersionMgramFlags(byte[] buffer) {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Flags: ");
            if (StaticHeader.isPostSV22(buffer)) {
                log.print("postSV22 ");
            }
            if (StaticHeader.hasSessionVer(buffer)) {
                log.print("sessionVersion ");
            }
            if (StaticHeader.hasStreamVersion(buffer)) {
                log.print("streamVersion ");
            }
            if (StaticHeader.isCompressionEnabled(buffer)) {
                log.print("compression_on");
            }
            log.println("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printMgramFlags(byte[] buffer) {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Flags: ");
            if (StaticHeader.isSucessor(buffer)) {
                log.print("successor ");
            }
            if (StaticHeader.hasTxn(buffer)) {
                log.print("transactional ");
            }
            if (StaticHeader.isJMSPersistent(buffer)) {
                log.print("persistent ");
            }
            switch (StaticHeader.getRouteLimit(buffer)) {
                case 0: {
                    log.print("route_limit_broker ");
                    break;
                }
                case 1: {
                    log.print("route_limit_local ");
                    break;
                }
                case 2: {
                    log.print("route_limit_collective ");
                    break;
                }
                case 7: {
                    log.print("route_limit_global ");
                    break;
                }
            }
            if (StaticHeader.hasID(buffer)) {
                log.print("message_id ");
            }
            if (StaticHeader.isSecure(buffer)) {
                log.print("secure ");
            }
            if (StaticHeader.hasTTE(buffer)) {
                log.print("expiration ");
            }
            if (StaticHeader.isGuarenteed(buffer)) {
                log.print("guaranteed ");
            }
            if (StaticHeader.isSend(buffer)) {
                log.print("send ");
            }
            if (StaticHeader.isRequest(buffer)) {
                log.print("request ");
            }
            if (StaticHeader.isReply(buffer)) {
                log.print("reply ");
            }
            log.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printMgramExpirationDate(byte[] buffer) {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.print("Expiration Date: ");
            if (StaticHeader.hasTTE(buffer)) {
                log.println(StaticHeader.getTTE(buffer));
            } else {
                log.println("NONE");
            }
        }
    }
}

