/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import progress.message.broker.IAcceptor;
import progress.message.net.ISocket;
import progress.message.net.ProgressInetAddress;
import progress.message.security.cert.X509Certificate;
import progress.message.util.ExtendedBufferedInputStream;

public abstract class ProgressSocket
implements ISocket {
    protected Socket m_impl;
    private IAcceptor m_acceptor;
    private String m_remoteAddress = null;
    private String m_localAddress = null;

    @Override
    public InputStream getInputStream(int maxBufferSize, int minBufferSize, int initialBufferSize) throws IOException {
        return new ExtendedBufferedInputStream(this.m_impl.getInputStream(), maxBufferSize);
    }

    @Override
    public OutputStream getOutputStream(int maxBufferSize, int minBufferSize, int initialBufferSize) throws IOException {
        return new BufferedOutputStream(this.m_impl.getOutputStream(), maxBufferSize);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.m_impl.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.m_impl.getOutputStream();
    }

    @Override
    public long getKeepAliveTimeout() {
        return 0L;
    }

    @Override
    public void close() throws IOException {
        this.m_impl.close();
    }

    @Override
    public void startProgressHandshake() throws IOException {
    }

    @Override
    public void startProgressRenegotiate() throws IOException {
    }

    @Override
    public int getPort() {
        if (this.m_impl != null) {
            return this.m_impl.getPort();
        }
        return -1;
    }

    @Override
    public ProgressInetAddress getInetAddress() {
        if (this.m_impl == null || this.m_impl.getInetAddress() == null) {
            return null;
        }
        return new ProgressInetAddress(this.m_impl.getInetAddress());
    }

    @Override
    public int getLocalPort() {
        if (this.m_impl != null) {
            return this.m_impl.getLocalPort();
        }
        return -1;
    }

    @Override
    public ProgressInetAddress getLocalInetAddress() {
        if (this.m_impl == null || this.m_impl.getLocalAddress() == null) {
            return null;
        }
        return new ProgressInetAddress(this.m_impl.getLocalAddress());
    }

    @Override
    public void startTransportHandshake() throws IOException {
    }

    @Override
    public void setSoTimeout(int timeout) throws IOException {
    }

    @Override
    public X509Certificate getCertificate() {
        return null;
    }

    @Override
    public X509Certificate getPeerCertificate() {
        return null;
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() {
        return null;
    }

    @Override
    public final String getAcceptorName() {
        return this.m_acceptor == null ? null : this.m_acceptor.getAcceptorName();
    }

    public final IAcceptor getAcceptor() {
        return this.m_acceptor;
    }

    public final void setAcceptor(IAcceptor acceptor) {
        this.m_acceptor = acceptor;
    }

    @Override
    public synchronized String getRemoteAddress() {
        ProgressInetAddress addr;
        if (this.m_remoteAddress == null && (addr = this.getInetAddress()) != null) {
            this.m_remoteAddress = addr.getCanonicalHostName();
        }
        return this.m_remoteAddress;
    }

    @Override
    public synchronized String getLocalAddress() {
        if (this.m_localAddress == null && this.m_impl != null && this.m_impl.getLocalAddress() != null) {
            this.m_localAddress = this.m_impl.getLocalAddress().getCanonicalHostName();
        }
        return this.m_localAddress;
    }

    public String toString() {
        if (this.m_impl != null) {
            return this.m_impl.toString();
        }
        return super.toString();
    }
}

