/*
 * Decompiled with CFR 0.152.
 */
package progress.message.net.evs;

import com.sonicsw.blackbird.evs.EEvsIOException;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLink;
import com.sonicsw.blackbird.evs.nio.nwlink.EvsNetworkLinkFactory;
import com.sonicsw.blackbird.evs.nio.nwlink.IEvsNetworkLink;
import java.applet.Applet;
import java.io.IOException;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Properties;
import progress.message.net.ProgressInetAddress;
import progress.message.net.ProgressServerSocket;
import progress.message.net.ProgressSocket;
import progress.message.net.evs.EVSNetworkLinkConfig;
import progress.message.net.evs.ProgressEvsLinkInterceptor;
import progress.message.net.evs.ProgressEvsServerSocket;
import progress.message.net.evs.ProgressEvsSocket;
import progress.message.net.http.client.tunnel.IHttpProxyConfig;

public class ProgressEvsSocketFactory {
    public static final ProgressSocket createProgressSocket(String linkType, Principal principal, String host, int port, Object properties, IHttpProxyConfig pConfig) throws IOException {
        EVSNetworkLinkConfig config = null;
        config = properties instanceof Applet ? new EVSNetworkLinkConfig(linkType, host, port, (Applet)properties, pConfig) : new EVSNetworkLinkConfig(linkType, host, port, (Hashtable)properties, pConfig);
        try {
            IEvsNetworkLink link = EvsNetworkLinkFactory.create(config.getLinkType(), 1, null, config);
            ProgressEvsSocket ret = new ProgressEvsSocket(link, config);
            try {
                ret.connect();
            }
            catch (IOException ioe) {
                ret.close();
                throw ioe;
            }
            return ret;
        }
        catch (EEvsIOException ex) {
            IOException ioe = ProgressEvsSocketFactory.handleException(ex);
            throw ioe;
        }
    }

    public static ProgressServerSocket createProgressServerSocket(String linkType, Principal principal, int port, int backlog, ProgressInetAddress bindAddr, Properties properties) throws IOException {
        EVSNetworkLinkConfig config = new EVSNetworkLinkConfig(linkType, bindAddr, port, backlog, properties);
        try {
            return new ProgressEvsServerSocket(EvsNetworkLinkFactory.create(config.getLinkType(), 0, null, config), config);
        }
        catch (EEvsIOException ex) {
            IOException ioe = ProgressEvsSocketFactory.handleException(ex);
            throw ioe;
        }
    }

    private static IOException handleException(EEvsIOException ex) throws IOException {
        Exception e = ex.getExtendedException();
        if (e != null && e instanceof IOException) {
            throw (IOException)e;
        }
        IOException ioe = new IOException(ex.getMessage());
        ioe.initCause(ex);
        return ioe;
    }

    static {
        EvsNetworkLink.LINK_INTERCEPTOR = ProgressEvsLinkInterceptor.getInstance();
    }
}

