/*
 * Decompiled with CFR 0.152.
 */
package progress.message.strm.util;

import com.sonicsw.blackbird.evs.nio.nwlink.strm.EvsInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import progress.message.net.ISocket;
import progress.message.strm.IStreamSegment;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.ExtendedBufferedInputStream;
import progress.message.util.Hex;
import progress.message.util.IDumpable;
import progress.message.zclient.DebugObject;

public class BufferedStrmInputStream
extends InputStream
implements IDumpable {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private boolean DEBUG;
    private boolean DEBUG1;
    private DebugObject m_debugObj;
    private InputStream m_bis;
    private int m_initialBufSize;
    private byte[] m_buf;
    private int m_pos;
    private int m_count;
    private InputStream m_baseInputStream;
    private IStreamSegment m_streamSegment;
    private boolean m_isSegmented;

    public BufferedStrmInputStream(InputStream is) {
        this(is, 8192);
    }

    public BufferedStrmInputStream(InputStream is, int bufSize) {
        this.m_baseInputStream = is;
        this.m_bis = new ExtendedBufferedInputStream(is, bufSize);
        this.m_initialBufSize = bufSize;
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.m_debugObj = new DebugObject("BufferedStrmInputStream ");
            this.DEBUG = this.m_debugObj.getDebug();
            boolean bl = this.DEBUG1 = (this.m_debugObj.debugFlags & 0x40) > 0;
        }
        if (this.DEBUG1) {
            this.debug("Created BufferedInputStream; bufsize= " + bufSize);
        }
    }

    public synchronized void convertToSegmentedStream(IStreamSegment seg) {
        if (this.DEBUG1) {
            this.debug("convertToSegmentedStream called;");
        }
        this.m_buf = new byte[this.m_initialBufSize];
        this.m_pos = 0;
        this.m_count = 0;
        this.m_streamSegment = seg;
        this.m_isSegmented = true;
    }

    public synchronized InputStream convertToUnsegmentedStream(ISocket socket, int maxBufSize, int minBufSize, int initialBufSize) throws IOException {
        if (this.DEBUG1) {
            this.debug("convertToUnsegmentedStream called;");
        }
        if (this.m_isSegmented) {
            throw new EAssertFailure("Can't convert segmented stream to unsegmented");
        }
        if (this.m_baseInputStream instanceof EvsInputStream) {
            this.m_bis = this.m_baseInputStream = socket.getInputStream(maxBufSize, minBufSize, initialBufSize);
            return this.m_bis;
        }
        return this;
    }

    public synchronized byte getStreamVersion() {
        if (this.m_isSegmented) {
            return this.m_streamSegment.getVersion();
        }
        return 0;
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.m_isSegmented) {
            return this.m_bis.read();
        }
        this.checkOpen();
        if (this.m_pos >= this.m_count) {
            this.refill();
            if (this.m_pos >= this.m_count) {
                return -1;
            }
        }
        return this.m_buf[this.m_pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (!this.m_isSegmented) {
            return this.m_bis.read(b);
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        if (!this.m_isSegmented) {
            return this.m_bis.read(b, off, len);
        }
        this.checkOpen();
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int totRead = this.readInto(b, off, len);
        if (totRead <= 0) {
            return totRead;
        }
        while (totRead < len && this.m_baseInputStream.available() > 0 && (bytesRead = this.readInto(b, off + totRead, len - totRead)) > 0) {
            totRead += bytesRead;
        }
        if (this.DEBUG1 && totRead <= 0) {
            this.debug("read[buf, off, len] completed: returning totRead= " + totRead + " " + Thread.currentThread());
        }
        return totRead;
    }

    private int readInto(byte[] b, int off, int len) throws IOException {
        int avail = this.m_count - this.m_pos;
        if (avail <= 0) {
            this.refill();
            avail = this.m_count - this.m_pos;
            if (avail <= 0) {
                if (this.DEBUG1) {
                    this.debug("readInto: avail= " + avail + " returning -1 " + Thread.currentThread());
                }
                return -1;
            }
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.m_buf, this.m_pos, b, off, cnt);
        this.m_pos += cnt;
        return cnt;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (!this.m_isSegmented) {
            return this.m_bis.skip(n);
        }
        this.checkOpen();
        if (n <= 0L) {
            return 0L;
        }
        int available = this.m_count - this.m_pos;
        if (available <= 0) {
            this.refill();
            available = this.m_count - this.m_pos;
            if (available <= 0) {
                return 0L;
            }
        }
        long skipped = (long)available < n ? (long)available : n;
        this.m_pos = (int)((long)this.m_pos + skipped);
        return skipped;
    }

    @Override
    public synchronized int available() throws IOException {
        if (!this.m_isSegmented) {
            return this.m_bis.available();
        }
        int avail = this.m_count - this.m_pos;
        return avail;
    }

    @Override
    public void close() throws IOException {
        if (!this.m_isSegmented) {
            this.m_bis.close();
            return;
        }
        if (this.m_buf == null) {
            return;
        }
        this.m_bis.close();
        if (this.m_baseInputStream != null) {
            this.m_baseInputStream.close();
            this.m_baseInputStream = null;
        }
        this.m_buf = null;
    }

    @Override
    public void mark(int readlimit) {
        if (!this.m_isSegmented) {
            this.m_bis.mark(readlimit);
            return;
        }
    }

    @Override
    public void reset() throws IOException {
        if (!this.m_isSegmented) {
            this.m_bis.reset();
            return;
        }
        if (this.DEBUG1) {
            this.debug("Reset **** called ");
        }
        throw new IOException("BufferedCRCInputStream: reset not supported");
    }

    @Override
    public boolean markSupported() {
        if (!this.m_isSegmented) {
            return this.m_bis.markSupported();
        }
        return false;
    }

    private void refill() throws IOException {
        this.m_pos = 0;
        this.m_count = 0;
        this.refillFromSegmentedStream();
        if (this.DEBUG) {
            this.debug("refill completed; currentSize " + this.m_count);
        }
    }

    private void refillFromSegmentedStream() throws IOException {
        int bytesRead = 0;
        try {
            bytesRead = this.getNextSegment(true);
            if (bytesRead <= 0) {
                if (this.DEBUG1) {
                    this.debug("refillFromSegmentedStream returning; bytesread= " + bytesRead);
                }
                return;
            }
        }
        catch (EOFException ex) {
            if (this.DEBUG1) {
                this.debug("refillFromSegmentedStream returned EOFException");
            }
            return;
        }
    }

    private int getNextSegment(boolean waitForData) throws IOException {
        int bytesRead = 0;
        try {
            int newlen = this.m_streamSegment.getNextSegmentLength(this.m_baseInputStream);
            int avail = this.m_buf.length - this.m_count;
            while (newlen == 0) {
                int cnt;
                if (this.DEBUG1) {
                    this.debug("getNextSegment; got 0 length; continuing");
                }
                if ((cnt = this.m_streamSegment.readSegment(this.m_baseInputStream, this.m_buf, this.m_count, avail)) != 0) {
                    throw new IOException("Stream error incorrect length in segment; expected 0; actual " + cnt);
                }
                newlen = this.m_streamSegment.getNextSegmentLength(this.m_baseInputStream);
            }
            if (this.m_count == 0 && newlen > this.m_buf.length) {
                byte[] newbuf = new byte[newlen];
                bytesRead = this.m_streamSegment.readSegment(this.m_baseInputStream, newbuf, 0, newlen);
                if (bytesRead > 0) {
                    if (this.DEBUG1) {
                        this.debug("Buffer resized; new len= " + newlen);
                    }
                    this.m_buf = newbuf;
                    this.m_count = bytesRead;
                }
            } else if (newlen <= avail && (waitForData || !waitForData && this.m_baseInputStream.available() > 0) && (bytesRead = this.m_streamSegment.readSegment(this.m_baseInputStream, this.m_buf, this.m_count, avail)) > 0) {
                this.m_count += bytesRead;
            }
        }
        catch (EOFException ex) {
            if (this.DEBUG1) {
                this.debug("getNextSegment; got EOFException; returning -1");
            }
            return -1;
        }
        return bytesRead;
    }

    private void checkOpen() throws IOException {
        if (this.m_buf == null) {
            throw new IOException("Stream has been closed");
        }
    }

    @Override
    public final void dump(StringBuffer buf) {
        if (!this.m_isSegmented) {
            if (this.m_bis instanceof IDumpable) {
                ((IDumpable)((Object)this.m_bis)).dump(buf);
            }
        } else {
            buf.append("Dump of segmented BufferedStrmInputStream pos: " + this.m_pos + ", count: " + this.m_count + "\n");
            buf.append(Hex.dumpString(this.m_buf) + "\n");
        }
    }

    private void debug(String s) {
        this.m_debugObj.debug(s);
    }
}

