/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import progress.message.util.DebugState;
import progress.message.util.IMetricsListener;
import progress.message.zclient.DebugObject;

public class CompressedBlockInputStream
extends FilterInputStream {
    private byte[] m_inBuf = null;
    private int m_inLength = 0;
    private byte[] m_outBuf = null;
    private int m_outOffs = 0;
    private int m_outLength = 0;
    private Inflater m_inflater = new Inflater();
    private IMetricsListener m_metricsListener = null;
    private boolean DEBUG;
    private DebugObject m_debugObj;

    public CompressedBlockInputStream(InputStream is, IMetricsListener listener) throws IOException {
        super(is);
        this.m_metricsListener = listener;
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.m_debugObj = new DebugObject("CompressedBlockInputStream");
            this.DEBUG = this.m_debugObj.getDebug();
        }
    }

    private void readAndDecompress() throws IOException {
        int inCount;
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.m_inLength = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.m_outLength = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        if (this.DEBUG) {
            this.debug("Bytes to read from network = " + this.m_inLength + ", expected bytes after de-compression = " + this.m_outLength);
        }
        if (this.m_inBuf == null || this.m_inLength > this.m_inBuf.length) {
            this.m_inBuf = new byte[this.m_inLength];
        }
        if (this.m_outBuf == null || this.m_outLength > this.m_outBuf.length) {
            this.m_outBuf = new byte[this.m_outLength];
        }
        for (int inOffs = 0; inOffs < this.m_inLength; inOffs += inCount) {
            inCount = this.in.read(this.m_inBuf, inOffs, this.m_inLength - inOffs);
            if (inCount != -1) continue;
            throw new EOFException();
        }
        if (this.m_metricsListener != null) {
            this.m_metricsListener.updateBytesRcvdStats(this.m_inLength);
        }
        this.m_inflater.setInput(this.m_inBuf, 0, this.m_inLength);
        try {
            this.m_inflater.inflate(this.m_outBuf);
        }
        catch (DataFormatException dfe) {
            throw new IOException("Data format exception - " + dfe.getMessage());
        }
        this.m_inflater.reset();
        this.m_outOffs = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.m_outOffs >= this.m_outLength) {
            try {
                this.readAndDecompress();
            }
            catch (EOFException eof) {
                return -1;
            }
        }
        return this.m_outBuf[this.m_outOffs++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        int toCopy;
        for (count = 0; count < len; count += toCopy) {
            if (this.m_outOffs >= this.m_outLength) {
                try {
                    if (count > 0 && this.in.available() == 0) {
                        return count;
                    }
                    this.readAndDecompress();
                }
                catch (EOFException eof) {
                    if (count == 0) {
                        count = -1;
                    }
                    return count;
                }
            }
            toCopy = Math.min(this.m_outLength - this.m_outOffs, len - count);
            System.arraycopy(this.m_outBuf, this.m_outOffs, b, off + count, toCopy);
            this.m_outOffs += toCopy;
        }
        return count;
    }

    @Override
    public int available() throws IOException {
        return this.m_outLength - this.m_outOffs + this.in.available();
    }

    private void debug(String s) {
        this.m_debugObj.debug(s);
    }
}

