/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.util.Enumeration;
import java.util.Iterator;
import progress.message.util.ListEnum;
import progress.message.util.ListNode;

public class LinkedList<V> {
    protected ListNode<V> m_head = null;
    protected ListNode<V> m_tail = null;

    public synchronized ListNode<V> head() {
        return this.m_head;
    }

    public synchronized ListNode<V> tail() {
        return this.m_tail;
    }

    public synchronized ListNode<V> append(V obj) {
        ListNode<V> node = new ListNode<V>(obj, this);
        return this.appendNode(node);
    }

    public synchronized ListNode<V> append(ListNode<V> node) {
        return this.appendNode(node);
    }

    private ListNode<V> appendNode(ListNode<V> node) {
        if (this.m_tail == null) {
            this.m_tail = node;
            this.m_head = this.m_tail;
        } else {
            this.m_tail.m_next = node;
            node.m_prev = this.m_tail;
            this.m_tail = node;
        }
        return node;
    }

    public synchronized ListNode<V> insert(V obj, ListNode<V> before) {
        if (before == null) {
            return this.append(obj);
        }
        ListNode<V> newnode = new ListNode<V>(obj, this);
        newnode.m_next = before;
        newnode.m_prev = before.m_prev;
        before.m_prev = newnode;
        if (newnode.m_prev != null) {
            newnode.m_prev.m_next = newnode;
        }
        if (this.m_head == before) {
            this.m_head = newnode;
        }
        return newnode;
    }

    public synchronized ListNode<V> prepend(V obj) {
        this.insert(obj, this.m_head);
        return this.m_head;
    }

    public synchronized void remove(ListNode<V> node) {
        if (node == null) {
            return;
        }
        if (node.m_prev != null) {
            node.m_prev.m_next = node.m_next;
        }
        if (node.m_next != null) {
            node.m_next.m_prev = node.m_prev;
        }
        if (this.m_head == node) {
            this.m_head = node.m_next;
        }
        if (this.m_tail == node) {
            this.m_tail = node.m_prev;
        }
        node.m_next = null;
        node.m_prev = null;
    }

    public synchronized V dequeue() {
        if (this.m_head == null) {
            return null;
        }
        Object obj = this.m_head.obj;
        this.remove(this.m_head);
        return obj;
    }

    public synchronized Enumeration<V> elements(ListNode<V> start, ListNode<V> end) {
        return new ListEnum<V>(start, end, this);
    }

    public synchronized Enumeration<V> elements() {
        return new ListEnum<V>(this.m_head, null, this);
    }

    public synchronized Enumeration<V> elementsInReverse() {
        return this.elementsInReverse(null, this.m_tail);
    }

    public synchronized Enumeration<V> elementsInReverse(ListNode<V> start, ListNode<V> end) {
        return new ListEnum<V>(start, end, this, true);
    }

    public synchronized Iterator<V> values() {
        return this.values(this.m_head, null);
    }

    public synchronized Iterator<V> values(ListNode<V> start, ListNode<V> end) {
        return new ListEnum<V>(start, end, this);
    }

    public synchronized Iterator<V> valuesInReverse() {
        return this.valuesInReverse(null, this.m_tail);
    }

    public synchronized Iterator<V> valuesInReverse(ListNode<V> start, ListNode<V> end) {
        return new ListEnum<V>(start, end, this, true);
    }

    public synchronized boolean isEmpty() {
        return this.m_head == null;
    }

    public synchronized void clearList() {
        ListNode<V> node = this.m_head;
        while (node != null) {
            ListNode next = node.m_next;
            node.m_prev = null;
            node.m_next = null;
            node = next;
        }
        this.m_head = null;
        this.m_tail = null;
        node = null;
    }

    public synchronized int count() {
        if (this.m_head == null) {
            return 0;
        }
        ListNode<V> node = this.m_head;
        int count = 0;
        while (node != null) {
            ++count;
            node = node.m_next;
        }
        return count;
    }
}

