/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import progress.message.util.LinkedList;
import progress.message.util.ListNode;

class ListEnum<V>
implements Enumeration<V>,
Iterator<V> {
    private ListNode<V> m_next;
    private ListNode<V> m_end;
    private ListNode<V> m_current = null;
    private LinkedList<V> m_list = null;
    private boolean m_reverseTraversal = false;

    ListEnum(ListNode<V> start, ListNode<V> end, LinkedList<V> list, boolean reverseTraversal) {
        if (reverseTraversal) {
            this.m_end = start;
            this.m_next = end;
        } else {
            this.m_end = end;
            this.m_next = start;
        }
        this.m_list = list;
        this.m_reverseTraversal = reverseTraversal;
    }

    ListEnum(ListNode<V> start, ListNode<V> end, LinkedList<V> list) {
        this(start, end, list, false);
    }

    @Override
    public final boolean hasMoreElements() {
        return this.m_next != null;
    }

    @Override
    public final V nextElement() {
        if (this.m_next == null) {
            throw new NoSuchElementException();
        }
        Object ret = this.m_next.obj;
        this.m_current = this.m_next;
        ListNode listNode = this.m_next = this.m_reverseTraversal ? this.m_next.m_prev : this.m_next.next();
        if (this.m_next == this.m_end) {
            this.m_next = null;
        }
        return ret;
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreElements();
    }

    @Override
    public V next() {
        return this.nextElement();
    }

    @Override
    public void remove() {
        this.m_list.remove(this.m_current);
    }
}

