/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import progress.message.util.EnhancedOutputStream;

public final class StreamUtil {
    static byte[] m_skip = new byte[255];

    public static short readShort(InputStream is) throws IOException {
        int retValue = StreamUtil.readByte(is) << 8;
        return (short)(retValue |= StreamUtil.readByte(is) & 0xFF);
    }

    public static long readLong(InputStream is) throws IOException {
        long retValue = ((long)StreamUtil.readByte(is) & 0xFFL) << 56;
        retValue |= ((long)StreamUtil.readByte(is) & 0xFFL) << 48;
        return StreamUtil.read6ByteLongValue(is, retValue |= ((long)StreamUtil.readByte(is) & 0xFFL) << 40);
    }

    public static long read6ByteLong(InputStream is) throws IOException {
        long retValue = ((long)StreamUtil.readByte(is) & 0xFFL) << 40;
        return StreamUtil.read6ByteLongValue(is, retValue);
    }

    private static long read6ByteLongValue(InputStream is, long retValueParam) throws IOException {
        long retValue = retValueParam;
        retValue |= ((long)StreamUtil.readByte(is) & 0xFFL) << 32;
        retValue |= ((long)StreamUtil.readByte(is) & 0xFFL) << 24;
        retValue |= ((long)StreamUtil.readByte(is) & 0xFFL) << 16;
        retValue |= ((long)StreamUtil.readByte(is) & 0xFFL) << 8;
        return retValue |= (long)StreamUtil.readByte(is) & 0xFFL;
    }

    public static int readInt(InputStream is) throws IOException {
        int retValue = (StreamUtil.readByte(is) & 0xFF) << 24;
        retValue |= (StreamUtil.readByte(is) & 0xFF) << 16;
        retValue |= (StreamUtil.readByte(is) & 0xFF) << 8;
        return retValue |= StreamUtil.readByte(is) & 0xFF;
    }

    public static byte[] readUTFString(InputStream is) throws IOException {
        byte byte1 = StreamUtil.readByte(is);
        byte byte2 = StreamUtil.readByte(is);
        int len = (byte1 & 0xFF) << 8 | byte2 & 0xFF;
        byte[] string = new byte[len + 2];
        string[0] = byte1;
        string[1] = byte2;
        StreamUtil.readBytes(is, string, 2, len);
        return string;
    }

    public static final String readUTF(InputStream in) throws IOException {
        byte byte1 = StreamUtil.readByte(in);
        byte byte2 = StreamUtil.readByte(in);
        int utflen = (byte1 & 0xFF) << 8 | byte2 & 0xFF;
        char[] str = new char[utflen];
        byte[] bytearr = new byte[utflen];
        int count = 0;
        int strlen = 0;
        StreamUtil.readBytes(in, bytearr, 0, utflen);
        block5: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str, 0, strlen);
    }

    public static void writeUTF(String str, OutputStream os) throws IOException {
        char[] charr;
        int utflen = 0;
        for (char c : charr = str.toCharArray()) {
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        int count = 0;
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        for (char c : charr) {
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        os.write(bytearr);
    }

    public static void skip(InputStream is, int len) throws IOException {
        if (len > 0) {
            int tempResult;
            for (int result = 0; result < len; result += tempResult) {
                tempResult = 0;
                tempResult = len - result > m_skip.length ? is.read(m_skip, 0, m_skip.length) : (tempResult += is.read(m_skip, 0, len - result));
                if (tempResult != -1) continue;
                throw new EOFException();
            }
        }
    }

    public static void readBytes(InputStream is, byte[] target, int offset, int length) throws IOException {
        int amountRead = 0;
        for (int pos = 0; pos < length; pos += amountRead) {
            amountRead = is.read(target, offset + pos, length - pos);
            if (amountRead != -1) continue;
            throw new EOFException();
        }
    }

    public static final byte readByte(InputStream is) throws IOException {
        int result = is.read();
        if (result == -1) {
            throw new EOFException();
        }
        return (byte)(result & 0xFF);
    }

    public static final boolean readBoolean(InputStream is) throws IOException {
        byte result = StreamUtil.readByte(is);
        return result == 1;
    }

    public static void writeLong(long value, OutputStream os) throws IOException {
        if (os instanceof EnhancedOutputStream) {
            StreamUtil.writeLong(value, (EnhancedOutputStream)os);
        } else {
            os.write((byte)(value >>> 56));
            os.write((byte)(value >>> 48));
            StreamUtil.osWrite6ByteLong(os, value);
        }
    }

    public static void writeInt(int value, OutputStream os) throws IOException {
        if (os instanceof EnhancedOutputStream) {
            StreamUtil.writeInt(value, (EnhancedOutputStream)os);
        } else {
            os.write((byte)(value >>> 24));
            os.write((byte)(value >>> 16));
            os.write((byte)(value >>> 8));
            os.write((byte)value);
        }
    }

    public static void writeByte(byte value, OutputStream os) throws IOException {
        os.write(value);
    }

    public static void writeShort(short value, OutputStream os) throws IOException {
        os.write((byte)(value >>> 8));
        os.write((byte)value);
    }

    public static void write6ByteLong(long value, OutputStream os) throws IOException {
        StreamUtil.osWrite6ByteLong(os, value);
    }

    private static void osWrite6ByteLong(OutputStream os, long value) throws IOException {
        os.write((byte)(value >>> 40));
        os.write((byte)(value >>> 32));
        os.write((byte)(value >>> 24));
        os.write((byte)(value >>> 16));
        os.write((byte)(value >>> 8));
        os.write((byte)value);
    }

    public static void writeBoolean(boolean value, OutputStream os) throws IOException {
        os.write(value ? 1 : 0);
    }

    public static void writeInt(int value, EnhancedOutputStream os) throws IOException {
        os.writeInt(value);
    }

    public static void writeLong(long value, EnhancedOutputStream os) throws IOException {
        os.writeLong(value);
    }
}

