/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import java.util.HashMap;
import progress.message.util.SubjectCacheEntry;
import progress.message.zclient.ISubject;

public class SubjectCache {
    private HashMap m_table;
    private final int m_maxEntries;
    private SubjectCacheEntry m_head;
    private SubjectCacheEntry m_tail;

    public SubjectCache(int initialCapacity, int maxEntries) {
        this.m_table = new HashMap(initialCapacity);
        this.m_maxEntries = maxEntries;
    }

    public final int size() {
        return this.m_table.size();
    }

    public final boolean isEmpty() {
        return this.m_table.isEmpty();
    }

    public final Object get(ISubject subject) {
        SubjectCacheEntry memo = (SubjectCacheEntry)this.m_table.get(subject);
        if (memo != null) {
            this.moveKeyToTail(memo);
            return memo.m_value;
        }
        return null;
    }

    public final Object put(ISubject subject, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        SubjectCacheEntry memo = (SubjectCacheEntry)this.m_table.get(subject);
        if (memo != null) {
            this.moveKeyToTail(memo);
            Object ret = memo.m_value;
            memo.m_value = value;
            return ret;
        }
        if (this.m_table.size() >= this.m_maxEntries) {
            this.removeHead();
        }
        SubjectCacheEntry entry = new SubjectCacheEntry(subject, value);
        this.m_table.put(subject, entry);
        this.addToTail(entry);
        return value;
    }

    private final void removeHead() {
        if (this.m_head == null) {
            return;
        }
        SubjectCacheEntry old_head = this.m_head;
        this.m_head = old_head.m_next;
        if (this.m_head == null) {
            this.m_tail = null;
        } else {
            this.m_head.m_prev = null;
        }
        old_head.m_next = null;
        this.m_table.remove(old_head.m_subject);
    }

    private final void addToTail(SubjectCacheEntry entry) {
        if (this.m_tail == null) {
            this.m_head = this.m_tail = entry;
        } else {
            this.m_tail.m_next = entry;
            entry.m_prev = this.m_tail;
            entry.m_next = null;
            this.m_tail = entry;
        }
    }

    private final void remove(SubjectCacheEntry entry) {
        if (entry == null) {
            return;
        }
        if (entry.m_prev != null) {
            entry.m_prev.m_next = entry.m_next;
        }
        if (entry.m_next != null) {
            entry.m_next.m_prev = entry.m_prev;
        }
        if (this.m_head == entry) {
            this.m_head = entry.m_next;
        }
        if (this.m_tail == entry) {
            this.m_tail = entry.m_prev;
        }
        entry.m_prev = null;
        entry.m_next = null;
    }

    private void moveKeyToTail(SubjectCacheEntry entry) {
        if (this.m_tail == entry) {
            return;
        }
        this.remove(entry);
        this.addToTail(entry);
    }

    public final void clearLRUStack() {
        SubjectCacheEntry node = this.m_head;
        while (node != null) {
            SubjectCacheEntry next = node.m_next;
            node.m_prev = null;
            node.m_next = null;
            node = next;
        }
        this.m_head = null;
        this.m_tail = null;
        node = null;
    }

    public Object remove(ISubject subject) throws NullPointerException {
        if (subject == null) {
            throw new NullPointerException();
        }
        SubjectCacheEntry entry = (SubjectCacheEntry)this.m_table.remove(subject);
        if (entry != null) {
            this.remove(entry);
            return entry.m_value;
        }
        return null;
    }

    public void clear() {
        this.m_table.clear();
        this.clearLRUStack();
    }
}

