/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.capture;

import progress.message.util.Hex;
import progress.message.util.IDumpable;

public class CaptureBuffer
implements IDumpable {
    private static final boolean VERBOSE;
    private static final String UNANNOTATED;
    private byte[] m_buf;
    private int m_pos = 0;
    private boolean m_wrapped;
    private Annotation m_aHead;
    private Annotation m_aTail;
    private Annotation m_aPointer;
    private int m_aCount = 0;

    public CaptureBuffer(int size) {
        this.m_buf = new byte[size];
        this.m_aHead = this.m_aTail = new Annotation();
        this.m_aPointer = this.m_aTail;
        this.m_aHead.pos = 0;
    }

    public final void capture(byte b) {
        if (this.m_buf == null) {
            return;
        }
        if (this.m_pos == this.m_buf.length) {
            this.m_pos = 0;
        }
        this.m_buf[this.m_pos++] = b;
        this.updateAnnotationPointer();
    }

    public final void capture(byte[] b, int off, int len) {
        if (this.m_buf == null) {
            return;
        }
        int rem = this.m_buf.length - this.m_pos;
        if (len <= rem) {
            System.arraycopy(b, off, this.m_buf, this.m_pos, len);
            this.m_pos += len;
        } else if (len >= this.m_buf.length) {
            System.arraycopy(b, off, this.m_buf, 0, this.m_buf.length);
            this.m_pos = this.m_buf.length;
            this.m_aHead = this.m_aPointer = new Annotation();
            this.m_aTail = this.m_aPointer;
            this.m_wrapped = false;
        } else {
            System.arraycopy(b, off, this.m_buf, this.m_pos, rem);
            System.arraycopy(b, off + rem, this.m_buf, 0, len - rem);
            this.m_pos = len - rem;
        }
        this.updateAnnotationPointer();
    }

    public final void resize(int size) {
        if (size == 0) {
            this.m_buf = null;
            this.m_aPointer = null;
            this.m_aTail = null;
            this.m_aHead = null;
            this.m_aCount = 0;
            this.m_pos = 0;
        } else {
            if (this.m_buf == null) {
                this.m_aHead = this.m_aTail = new Annotation();
                this.m_aPointer = this.m_aTail;
                this.m_aHead.pos = 0;
                this.m_buf = new byte[size];
                this.m_aCount = 0;
                return;
            }
            if (this.m_buf.length == size) {
                return;
            }
            byte[] newBuf = new byte[size];
            this.compact(null);
            if (newBuf.length >= Math.min(this.m_buf.length, this.m_pos)) {
                System.arraycopy(this.m_buf, 0, newBuf, 0, Math.min(this.m_buf.length, this.m_pos));
                this.m_buf = newBuf;
            } else {
                int trimPos = this.m_buf.length - newBuf.length;
                System.arraycopy(this.m_buf, trimPos, newBuf, 0, newBuf.length);
                Annotation ann = this.m_aHead;
                Annotation newHead = null;
                while (ann != null) {
                    ann.pos -= trimPos;
                    if (newHead == null && ann.pos >= 0) {
                        newHead = ann;
                    }
                    if (ann.pos < 0) {
                        --this.m_aCount;
                    }
                    ann = ann.next;
                }
                if (newHead == null) {
                    this.m_aHead = this.m_aTail = new Annotation();
                    this.m_aPointer = this.m_aTail;
                } else {
                    this.m_aHead = newHead;
                    if (newHead.prev != null) {
                        newHead.prev.next = null;
                        newHead.prev = null;
                    }
                }
            }
        }
    }

    private final void updateAnnotationPointer() {
        if (this.m_pos < this.m_aPointer.pos) {
            this.m_wrapped = true;
            if (this.m_aPointer != this.m_aHead) {
                this.m_aTail = this.m_aPointer.prev;
                this.m_aTail.next = null;
                this.m_aPointer.prev = null;
                this.m_aPointer.next = this.m_aHead;
                this.m_aHead.prev = this.m_aPointer;
                this.m_aHead = this.m_aPointer;
            } else {
                if (this.m_aPointer.next != null) {
                    this.m_aPointer.next.prev = null;
                }
                this.m_aPointer.next = null;
                this.m_aTail = this.m_aPointer;
            }
        }
        while (this.m_aPointer.next != null && this.m_aPointer.next.pos <= this.m_pos) {
            Annotation next = this.m_aPointer.next;
            this.m_aPointer.next = next.next;
            this.populatePrevAndTail(this.m_aPointer);
            next.next = null;
            next.prev = null;
            --this.m_aCount;
        }
        this.m_aPointer.pos = this.m_pos;
    }

    public final void annotate(String str) {
        if (this.m_buf == null) {
            return;
        }
        this.m_aPointer.annotation = str;
        Annotation a = new Annotation();
        a.prev = this.m_aPointer;
        a.next = this.m_aPointer.next;
        a.pos = this.m_pos;
        this.m_aPointer.next = a;
        this.populatePrevAndTail(a);
        this.m_aPointer = a;
        ++this.m_aCount;
    }

    private void populatePrevAndTail(Annotation a) {
        if (a.next != null) {
            a.next.prev = a;
        } else {
            this.m_aTail = a;
        }
    }

    private void dump() {
        StringBuffer buf = new StringBuffer();
        this.dump(buf);
        System.out.println(buf);
    }

    @Override
    public final void dump(StringBuffer buf) {
        try {
            this.compact(buf);
            Annotation ann = this.m_aHead;
            int end = 0;
            while (ann != null) {
                int start = 0;
                if (ann.prev != null) {
                    start = ann.prev.pos;
                }
                if ((end = ann.pos) - start > 0) {
                    buf.append("###Pos: " + start + "," + ann.annotation + "\n");
                    buf.append(Hex.dumpString(this.m_buf, start, end - start) + "\n");
                }
                ann = ann.next;
            }
            if (end < this.m_pos) {
                buf.append("###Pos: " + end + ", UNANNOTATED\n");
                buf.append(Hex.dumpString(this.m_buf, end, this.m_pos - end) + "\n");
            }
        }
        catch (Throwable thrown) {
            System.out.println(buf.toString());
            thrown.printStackTrace();
        }
    }

    private final void compact(StringBuffer buf) {
        if (this.m_buf == null) {
            return;
        }
        if (this.m_wrapped) {
            if (VERBOSE && buf != null) {
                buf.append("Dump of captured data, pos is " + this.m_pos + "\n");
                buf.append(Hex.dumpString(this.m_buf, 0, this.m_buf.length) + "\n");
                this.appendAnnotations(buf);
            }
            byte[] tmpBuf = new byte[this.m_buf.length];
            System.arraycopy(this.m_buf, 0, tmpBuf, this.m_buf.length - this.m_pos, this.m_pos);
            System.arraycopy(this.m_buf, this.m_pos, tmpBuf, 0, this.m_buf.length - this.m_pos);
            if (VERBOSE && buf != null) {
                buf.append("Compacted data: \n");
                buf.append(Hex.dumpString(tmpBuf, 0, tmpBuf.length) + "\n");
            }
            if (this.m_aHead != null) {
                Annotation a = this.m_aHead;
                Annotation wrap = null;
                while (a != null) {
                    if (a.pos > this.m_pos) {
                        a.pos -= this.m_pos;
                        if (wrap == null) {
                            wrap = a;
                        }
                    } else {
                        a.pos = this.m_buf.length - this.m_pos + a.pos;
                    }
                    a = a.next;
                }
                if (wrap != null) {
                    this.m_aTail.next = this.m_aHead;
                    this.m_aHead.prev = this.m_aTail;
                    wrap.prev.next = null;
                    this.m_aTail = wrap.prev;
                    wrap.prev = null;
                    this.m_aHead = wrap;
                }
            }
            if (VERBOSE && buf != null) {
                this.appendAnnotations(buf);
            }
            this.m_pos = this.m_buf.length;
            this.m_buf = tmpBuf;
            this.m_wrapped = false;
        }
    }

    private void appendAnnotations(StringBuffer buf) {
        if (this.m_aHead != null) {
            Annotation a = this.m_aHead;
            while (a != null) {
                buf.append("###: " + a.pos + "-" + a.annotation + "\n");
                a = a.next;
            }
        }
    }

    static /* synthetic */ String access$100() {
        return UNANNOTATED;
    }

    static {
        UNANNOTATED = new String("UNNANOTATED");
        boolean verbose = false;
        try {
            verbose = Boolean.getBoolean("SonicMQ.CaptureBuffer.verbose");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        VERBOSE = verbose;
    }

    private class Annotation {
        int pos;
        String annotation = CaptureBuffer.access$100();
        Annotation next;
        Annotation prev;

        private Annotation() {
        }
    }
}

