/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.capture;

import java.io.IOException;
import java.io.OutputStream;
import progress.message.util.IDumpable;
import progress.message.util.OutputStreamWrapper;
import progress.message.util.capture.CaptureBuffer;

public class CaptureOutputStream
extends OutputStreamWrapper
implements IDumpable {
    private final CaptureBuffer m_cb;

    public CaptureOutputStream(OutputStream os, int size) {
        super(os);
        this.m_cb = new CaptureBuffer(size);
    }

    @Override
    public final void write(int b) throws IOException {
        this.m_os.write(b);
        this.m_cb.capture((byte)b);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        this.m_os.write(b, off, len);
        this.m_cb.capture(b, off, len);
    }

    @Override
    public final void close() throws IOException {
        this.m_os.close();
    }

    @Override
    public final void flush() throws IOException {
        this.m_os.flush();
    }

    public final CaptureBuffer getCaptureBuffer() {
        return this.m_cb;
    }

    @Override
    public final void dump(StringBuffer buf) {
        buf.append("Dump of CaptureOutputStream:\n");
        this.m_cb.dump(buf);
    }
}

