/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.jclient;

import java.io.DataInput;
import java.io.IOException;
import javax.jms.MessageFormatException;
import progress.message.zclient.Message;

public class StreamMessageInputStream {
    static final int TYPE_BOOLEAN = 0;
    static final int TYPE_BYTE = 1;
    static final int TYPE_SHORT = 2;
    static final int TYPE_CHAR = 3;
    static final int TYPE_INT = 4;
    static final int TYPE_LONG = 5;
    static final int TYPE_FLOAT = 6;
    static final int TYPE_DOUBLE = 7;
    static final int TYPE_STRING = 8;
    static final int TYPE_BYTES = 9;
    static final int TYPE_NULL = 10;
    private int m_type = -1;
    private DataInput m_datain = null;
    private boolean m_inBytes = false;
    private int m_bytesLength = -1;
    private int m_bytesRead = 0;

    public StreamMessageInputStream(DataInput in) {
        this.m_datain = in;
    }

    public boolean readBoolean() throws IOException, MessageFormatException {
        this.checkInBytes();
        switch (this.getType()) {
            case 0: {
                this.clearType();
                return this.m_datain.readBoolean();
            }
            case 8: {
                this.clearType();
                return Boolean.valueOf(this.m_datain.readUTF());
            }
        }
        throw new MessageFormatException("");
    }

    public byte readByte() throws IOException, MessageFormatException {
        this.checkInBytes();
        switch (this.getType()) {
            case 1: {
                this.clearType();
                return this.m_datain.readByte();
            }
            case 8: {
                byte b = ((Message)this.m_datain).readUTFToByte();
                this.clearType();
                return b;
            }
        }
        throw new MessageFormatException("");
    }

    public int readBytes(byte[] value) throws IOException, MessageFormatException {
        int count;
        if (this.m_bytesLength == this.m_bytesRead && this.m_bytesLength != -1) {
            this.clearInBytes();
            return -1;
        }
        if (!this.m_inBytes) {
            this.m_inBytes = true;
            switch (this.getType()) {
                case 9: {
                    int count2;
                    this.clearType();
                    this.m_bytesLength = this.m_datain.readInt();
                    int n = count2 = value.length > this.m_bytesLength ? this.m_bytesLength : value.length;
                    if (count2 < value.length) {
                        this.clearInBytes();
                    }
                    this.m_datain.readFully(value, 0, count2);
                    this.m_bytesRead = count2;
                    return this.m_bytesRead;
                }
                case 10: {
                    this.clearType();
                    return 0;
                }
            }
            throw new MessageFormatException("");
        }
        int n = count = value.length > this.m_bytesLength - this.m_bytesRead ? this.m_bytesLength - this.m_bytesRead : value.length;
        if (count < value.length) {
            this.clearInBytes();
        }
        this.m_datain.readFully(value, 0, count);
        this.m_bytesRead += count;
        return count;
    }

    private void clearInBytes() {
        this.m_inBytes = false;
        this.m_bytesRead = 0;
        this.m_bytesLength = -1;
    }

    public char readChar() throws IOException, MessageFormatException {
        this.checkInBytes();
        switch (this.getType()) {
            case 3: {
                this.clearType();
                return this.m_datain.readChar();
            }
            case 10: {
                throw new NullPointerException();
            }
        }
        throw new MessageFormatException("");
    }

    public double readDouble() throws IOException, MessageFormatException {
        this.checkInBytes();
        switch (this.getType()) {
            case 7: {
                this.clearType();
                return this.m_datain.readDouble();
            }
            case 6: {
                this.clearType();
                return new Float(this.m_datain.readFloat()).doubleValue();
            }
            case 8: {
                this.clearType();
                return Double.valueOf(this.m_datain.readUTF());
            }
        }
        throw new MessageFormatException("");
    }

    public float readFloat() throws IOException, MessageFormatException {
        this.checkInBytes();
        switch (this.getType()) {
            case 6: {
                this.clearType();
                return this.m_datain.readFloat();
            }
            case 8: {
                this.clearType();
                return Float.valueOf(this.m_datain.readUTF()).floatValue();
            }
        }
        throw new MessageFormatException("");
    }

    public int readInt() throws IOException, MessageFormatException {
        this.checkInBytes();
        switch (this.getType()) {
            case 4: {
                this.clearType();
                return this.m_datain.readInt();
            }
            case 1: {
                this.clearType();
                return this.m_datain.readByte();
            }
            case 2: {
                this.clearType();
                return this.m_datain.readShort();
            }
            case 8: {
                this.clearType();
                return Integer.valueOf(this.m_datain.readUTF());
            }
        }
        throw new MessageFormatException("");
    }

    public long readLong() throws IOException, MessageFormatException {
        this.checkInBytes();
        switch (this.getType()) {
            case 5: {
                this.clearType();
                return this.m_datain.readLong();
            }
            case 1: {
                this.clearType();
                return this.m_datain.readByte();
            }
            case 2: {
                this.clearType();
                return this.m_datain.readShort();
            }
            case 4: {
                this.clearType();
                return this.m_datain.readInt();
            }
            case 8: {
                this.clearType();
                return Long.valueOf(this.m_datain.readUTF());
            }
        }
        throw new MessageFormatException("");
    }

    public Object readObject() throws IOException, MessageFormatException {
        this.checkInBytes();
        switch (this.getType()) {
            case 0: {
                this.clearType();
                return new Boolean(this.m_datain.readBoolean());
            }
            case 1: {
                this.clearType();
                return new Byte(this.m_datain.readByte());
            }
            case 9: {
                this.clearType();
                int length = this.m_datain.readInt();
                byte[] value = new byte[length];
                this.m_datain.readFully(value);
                return value;
            }
            case 3: {
                this.clearType();
                return new Character(this.m_datain.readChar());
            }
            case 7: {
                this.clearType();
                return new Double(this.m_datain.readDouble());
            }
            case 6: {
                this.clearType();
                return new Float(this.m_datain.readFloat());
            }
            case 4: {
                this.clearType();
                return new Integer(this.m_datain.readInt());
            }
            case 5: {
                this.clearType();
                return new Long(this.m_datain.readLong());
            }
            case 2: {
                this.clearType();
                return new Short(this.m_datain.readShort());
            }
            case 8: {
                this.clearType();
                return this.m_datain.readUTF();
            }
            case 10: {
                this.clearType();
                return null;
            }
        }
        throw new IOException("Unexpected type code found in stream");
    }

    public short readShort() throws IOException, MessageFormatException {
        this.checkInBytes();
        switch (this.getType()) {
            case 2: {
                this.clearType();
                return this.m_datain.readShort();
            }
            case 1: {
                this.clearType();
                return this.m_datain.readByte();
            }
            case 8: {
                this.clearType();
                return Short.valueOf(this.m_datain.readUTF());
            }
        }
        throw new MessageFormatException("");
    }

    public String readString() throws IOException, MessageFormatException {
        this.checkInBytes();
        switch (this.getType()) {
            case 8: {
                this.clearType();
                return this.m_datain.readUTF();
            }
            case 0: {
                this.clearType();
                return String.valueOf(this.m_datain.readBoolean());
            }
            case 1: {
                this.clearType();
                return String.valueOf(this.m_datain.readByte());
            }
            case 3: {
                this.clearType();
                return String.valueOf(this.m_datain.readChar());
            }
            case 7: {
                this.clearType();
                return String.valueOf(this.m_datain.readDouble());
            }
            case 6: {
                this.clearType();
                return String.valueOf(this.m_datain.readFloat());
            }
            case 4: {
                this.clearType();
                return String.valueOf(this.m_datain.readInt());
            }
            case 5: {
                this.clearType();
                return String.valueOf(this.m_datain.readLong());
            }
            case 2: {
                this.clearType();
                return String.valueOf(this.m_datain.readShort());
            }
            case 10: {
                this.clearType();
                return null;
            }
        }
        throw new MessageFormatException("");
    }

    private void checkInBytes() throws MessageFormatException {
        if (this.m_inBytes) {
            throw new MessageFormatException("");
        }
    }

    private int getType() throws IOException {
        if (this.m_type == -1) {
            this.m_type = this.m_datain.readByte();
        }
        return this.m_type;
    }

    private void clearType() {
        this.m_type = -1;
    }
}

