/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Stack;

public class BlockedDestList {
    private String m_dest;
    private Stack m_nacked;
    private Stack m_unsent;
    private boolean m_resuming;
    public boolean m_forRoutingQueue;

    public BlockedDestList(String destination) {
        this.m_dest = destination;
        this.m_nacked = new Stack();
        this.m_unsent = new Stack();
    }

    public synchronized Stack buildOrderedStack() {
        Stack st = this.createStackAndPush();
        return this.popNackedStack(st);
    }

    public synchronized Stack buildOrderedUnsentStack() {
        Stack st = this.createStackAndPush();
        return st;
    }

    private Stack createStackAndPush() {
        Stack st = new Stack();
        while (!this.m_unsent.empty()) {
            st.push(this.m_unsent.pop());
        }
        return st;
    }

    public synchronized Stack buildOrderedNackStack() {
        Stack st = new Stack();
        return this.popNackedStack(st);
    }

    private Stack popNackedStack(Stack st) {
        while (!this.m_nacked.empty()) {
            st.push(this.m_nacked.pop());
        }
        return st;
    }

    public synchronized void addNacked(Object obj) {
        this.m_nacked.push(obj);
    }

    public synchronized void addUnsent(Object obj) {
        this.m_unsent.push(obj);
    }

    public synchronized boolean isEmpty() {
        return this.m_nacked.isEmpty() && this.m_unsent.isEmpty();
    }

    public synchronized void emptyBlockedList() {
        while (!this.m_unsent.isEmpty()) {
            this.m_unsent.pop();
        }
        while (!this.m_nacked.isEmpty()) {
            this.m_nacked.pop();
        }
    }

    public String getBlockedDestination() {
        return this.m_dest;
    }

    public boolean isForRoutingQueue() {
        return this.m_forRoutingQueue;
    }

    public void setForRoutingQueue() {
        this.m_forRoutingQueue = true;
    }

    public void setResuming(boolean resuming) {
        this.m_resuming = resuming;
    }

    public boolean isResuming() {
        return this.m_resuming;
    }
}

