/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import progress.message.util.EAssertFailure;
import progress.message.util.Hex;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.SessionConfig;

public final class ClientSecurityContext
implements Cloneable {
    private static final byte CURRENT_VERSION = 1;
    private transient Principal m_principal;
    private String m_uid;
    private String m_appid;
    private long m_clientId;
    private byte[] m_directedAddr;
    private String m_directedAddrString;
    private static volatile ISecurityContextDisplayInfoFactory s_displayInfoFactory;
    ISecurityContextDisplayInfo m_displayInfo = null;
    private long m_parentID;
    private long m_faultTolerantReconnectTimeout;
    private String m_clientIPAddress = "";
    public static final long NO_PARENT = -1L;
    private HashSet m_childIDs = null;
    private Object m_childIDsSync = new Object();
    private boolean m_isFaultTolerant = false;
    private boolean m_isAnonymous = false;
    private boolean m_isSecurityEnabled;
    private boolean m_isQopSecurityEnabled;
    private transient byte[] m_digestKey;
    private transient byte[] m_sessionKey;

    void debug(String s) {
        System.out.println(s);
    }

    protected ClientSecurityContext() {
    }

    public ClientSecurityContext(Principal principal, String uid, String appid, long clientId, boolean isSecurityEnabled, boolean isQopSecurityEnabled, byte[] digestKey, byte[] sessionKey, long parentID) {
        if (clientId == parentID) {
            throw new EAssertFailure("Invalid parentID specified: parent id and client id are equal: " + uid + "/" + appid);
        }
        this.m_principal = principal;
        this.m_uid = uid;
        this.m_appid = appid;
        this.m_clientId = clientId;
        this.m_isSecurityEnabled = isSecurityEnabled;
        this.m_isQopSecurityEnabled = isQopSecurityEnabled;
        this.m_digestKey = digestKey;
        this.m_sessionKey = sessionKey;
        this.m_parentID = parentID;
    }

    public String getUid() {
        return this.m_uid;
    }

    public String getAppid() {
        return this.m_appid;
    }

    public long getClientId() {
        return this.m_clientId;
    }

    public boolean isAnonymous() {
        return this.m_isAnonymous;
    }

    public boolean isSecurityEnabled() {
        return this.m_isSecurityEnabled;
    }

    public boolean isQopSecurityEnabled() {
        return this.m_isQopSecurityEnabled;
    }

    public byte[] getSessionKey() {
        return this.m_sessionKey;
    }

    public byte[] getDigestKey() {
        return this.m_digestKey;
    }

    public long getParentId() {
        return this.m_parentID;
    }

    public void setDirectedAddr(byte[] da) {
        this.m_directedAddr = da;
    }

    public byte[] getDirectedAddr() {
        return this.m_directedAddr;
    }

    public void setDirectedAddrString(String da) {
        this.m_directedAddrString = da;
    }

    public String getDirectedAddrString() {
        return this.m_directedAddrString;
    }

    private void updateClientId() {
        this.m_clientId = SessionConfig.stringToClientId(this.m_uid, this.m_appid);
    }

    public void setAppid(String appid) {
        this.m_appid = appid;
        this.updateClientId();
        this.m_displayInfo = null;
    }

    public void setUidAppid(String uid, String appid) {
        this.m_uid = uid;
        this.m_appid = appid;
        this.updateClientId();
        this.m_displayInfo = null;
    }

    public void setSessionKey(byte[] sessionKey) {
        this.m_sessionKey = sessionKey;
    }

    public void setDigestKey(byte[] digestKey) {
        this.m_digestKey = digestKey;
    }

    public void setFaultTolerant(boolean t) {
        this.m_isFaultTolerant = t;
    }

    public boolean isFaultTolerant() {
        return this.m_isFaultTolerant;
    }

    public void setFaultTolerantReconnectTimeout(long l) {
        this.m_faultTolerantReconnectTimeout = l;
    }

    public long getFaultTolerantReconnectTimeout() {
        return this.m_faultTolerantReconnectTimeout;
    }

    public void setClientIPAddress(String i) {
        this.m_clientIPAddress = i == null ? "" : i;
    }

    public String getClientIPAddress() {
        if (this.m_clientIPAddress != null && this.m_clientIPAddress.length() == 0) {
            return null;
        }
        return this.m_clientIPAddress;
    }

    public void reset() {
        this.m_digestKey = null;
        this.m_sessionKey = null;
    }

    public Object clone() {
        try {
            return (ClientSecurityContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new EAssertFailure(e.toString(), e);
        }
    }

    public final Principal getPrincipal() {
        return this.m_principal;
    }

    public final void setPrincipal(Principal principal) {
        this.m_principal = principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildId(long childId) {
        Object object = this.m_childIDsSync;
        synchronized (object) {
            if (this.m_childIDs == null) {
                this.m_childIDs = new HashSet(4);
            }
            this.m_childIDs.add(new Long(childId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildId(long childId) {
        Object object = this.m_childIDsSync;
        synchronized (object) {
            if (this.m_childIDs != null) {
                this.m_childIDs.remove(new Long(childId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getChildIds() {
        Object object = this.m_childIDsSync;
        synchronized (object) {
            Set result = null;
            if (this.m_childIDs != null) {
                result = (Set)this.m_childIDs.clone();
            }
            return result;
        }
    }

    public void serialize(OutputStream os) throws IOException {
        StreamUtil.writeUTF(this.m_uid, os);
        StreamUtil.writeUTF(this.m_appid, os);
        StreamUtil.writeBoolean(this.m_isFaultTolerant, os);
        StreamUtil.writeBoolean(true, os);
        StreamUtil.writeByte((byte)1, os);
        StreamUtil.writeLong(this.m_parentID, os);
        StreamUtil.writeLong(this.m_faultTolerantReconnectTimeout, os);
        StreamUtil.writeUTF(this.m_clientIPAddress, os);
    }

    public void serialize(DataOutput os) throws IOException {
        os.writeUTF(this.m_uid);
        os.writeUTF(this.m_appid);
        os.writeBoolean(this.m_isFaultTolerant);
        os.writeBoolean(true);
        os.writeByte(1);
        os.writeLong(this.m_parentID);
        os.writeLong(this.m_faultTolerantReconnectTimeout);
        os.writeUTF(this.m_clientIPAddress);
    }

    public static ClientSecurityContext unserialize(InputStream in) throws IOException {
        ClientSecurityContext csc = new ClientSecurityContext();
        csc.m_uid = StreamUtil.readUTF(in);
        csc.m_appid = StreamUtil.readUTF(in);
        csc.m_isFaultTolerant = StreamUtil.readBoolean(in);
        boolean hasVersion = StreamUtil.readBoolean(in);
        if (!hasVersion) {
            return csc;
        }
        StreamUtil.readByte(in);
        csc.m_parentID = StreamUtil.readLong(in);
        csc.m_faultTolerantReconnectTimeout = StreamUtil.readLong(in);
        csc.m_clientIPAddress = StreamUtil.readUTF(in);
        csc.updateClientId();
        return csc;
    }

    public static ClientSecurityContext unserialize(DataInput in) throws IOException {
        ClientSecurityContext csc = new ClientSecurityContext();
        csc.m_uid = in.readUTF();
        csc.m_appid = in.readUTF();
        csc.m_isFaultTolerant = in.readBoolean();
        boolean hasVersion = in.readBoolean();
        if (!hasVersion) {
            return csc;
        }
        in.readByte();
        csc.m_parentID = in.readLong();
        csc.m_faultTolerantReconnectTimeout = in.readLong();
        csc.m_clientIPAddress = in.readUTF();
        csc.updateClientId();
        return csc;
    }

    public int length() {
        return StringUtil.lengthUTF(this.m_uid) + StringUtil.lengthUTF(this.m_appid) + 1 + 1 + 1 + 8 + 8 + StringUtil.lengthUTF(this.m_clientIPAddress);
    }

    public void writeToStream(DataOutput stream, short version) throws IOException {
        stream.writeUTF(this.m_uid);
        stream.writeUTF(this.m_appid);
        stream.writeLong(this.m_clientId);
        stream.writeShort(this.m_directedAddr.length);
        stream.write(this.m_directedAddr, 0, this.m_directedAddr.length);
        stream.writeUTF(this.m_directedAddrString);
        stream.writeLong(this.m_parentID);
        stream.writeBoolean(this.m_isAnonymous);
        stream.writeBoolean(this.m_isSecurityEnabled);
        stream.writeBoolean(this.m_isQopSecurityEnabled);
    }

    public void readFromStream(DataInput stream, short version) throws IOException {
        this.m_uid = stream.readUTF();
        this.m_appid = stream.readUTF();
        this.m_clientId = stream.readLong();
        this.m_directedAddr = new byte[stream.readShort()];
        stream.readFully(this.m_directedAddr, 0, this.m_directedAddr.length);
        this.m_directedAddrString = stream.readUTF();
        this.m_parentID = stream.readLong();
        this.m_isAnonymous = stream.readBoolean();
        this.m_isSecurityEnabled = stream.readBoolean();
        this.m_isQopSecurityEnabled = stream.readBoolean();
    }

    public static ClientSecurityContext getClientSecurityContext(DataInput stream, short version) throws IOException {
        ClientSecurityContext csc = new ClientSecurityContext();
        csc.readFromStream(stream, version);
        return csc;
    }

    public final void dump(StringBuffer buf) {
        buf.append("UID: " + this.m_uid + "\n");
        buf.append("AID: " + this.m_appid + "\n");
        buf.append("CID: " + this.m_clientId + "\n");
        buf.append("Sec: " + this.m_isSecurityEnabled + "\n");
        buf.append("QoP: " + this.m_isQopSecurityEnabled + "\n");
        if (this.m_sessionKey != null) {
            buf.append("a: " + Hex.dumpString(this.m_sessionKey) + "\n");
        }
        if (this.m_digestKey != null) {
            buf.append("b: " + Hex.dumpString(this.m_digestKey) + "\n");
        }
    }

    public static void setDisplayInfoFactory(ISecurityContextDisplayInfoFactory factory) {
        s_displayInfoFactory = factory;
    }

    public ISecurityContextDisplayInfo getDisplayInfo() {
        if (this.m_displayInfo == null && s_displayInfoFactory != null) {
            this.m_displayInfo = s_displayInfoFactory.createSecurityContextDisplayInfo(this);
        }
        return this.m_displayInfo;
    }

    public static interface ISecurityContextDisplayInfo {
        public short getType();

        public String getName();
    }

    public static interface ISecurityContextDisplayInfoFactory {
        public ISecurityContextDisplayInfo createSecurityContextDisplayInfo(ClientSecurityContext var1);
    }
}

