/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import progress.message.resources.prMessageFormat;
import progress.message.util.DebugFilterData;
import progress.message.util.DebugFilterManager;
import progress.message.util.DebugFormatter;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.FilterTypeEnumeration;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IDebugCallback;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.prAccessor;

public abstract class DebugThread
extends Thread {
    private boolean m_shutdown = false;
    private boolean m_started = false;
    private Object m_shutdownMutex = new Object();
    public boolean DEBUG = false;
    public boolean CALLBACK = false;
    public boolean DEBUG_UNEXPECTED = false;
    private IDebugCallback m_callbackClass = null;
    protected String m_name;
    private boolean m_name_changed = false;
    public int debugFlags = 0;
    private static Object syncObj = new Object();
    private static int numNotStarted;
    private static final DebugFormatter FORMATTER;
    private final DebugFilterData m_filterData;

    public DebugThread(String name) {
        super(name);
        this.m_name = name;
        String className = DebugState.getFirstToken(name);
        this.m_filterData = new DebugFilterData(className);
        this.m_filterData.add(FilterTypeEnumeration.ADMINCLIENT, "false");
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.setFlags();
        }
        if (DebugState.GLOBAL_DEBUG_ON) {
            DebugThread.updateCounter(1, this);
        }
        if ((this.debugFlags & 0x200) > 0) {
            this.debug("Thread constructed: hash=" + this.hashCodeHelper() + " activeCt= " + Thread.activeCount() + " notStarted " + numNotStarted);
        }
    }

    private int hashCodeHelper() {
        return this.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.m_shutdownMutex;
        synchronized (object) {
            this.m_started = true;
            super.start();
        }
        if (DebugState.GLOBAL_DEBUG_ON) {
            DebugThread.updateCounter(-1, this);
        }
        if ((this.debugFlags & 0x200) > 0) {
            this.debug("Thread starting   : hash=" + this.hashCode() + " activeCt= " + Thread.activeCount() + " notStarted " + numNotStarted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startIfNotStartedOrShutdown() {
        boolean started = false;
        Object object = this.m_shutdownMutex;
        synchronized (object) {
            if (!(this.isAlive() || this.m_shutdown || this.m_started)) {
                this.start();
                started = true;
            }
        }
        return started;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean interrupt) {
        Object object = this.m_shutdownMutex;
        synchronized (object) {
            if (this.m_shutdown) {
                return;
            }
            this.m_shutdown = true;
            if (this.isAlive()) {
                if (interrupt) {
                    this.interrupt();
                }
            } else if (!this.m_started) {
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShuttingDown() {
        Object object = this.m_shutdownMutex;
        synchronized (object) {
            return this.m_shutdown || this.isInterrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCounter(int value, Thread t) {
        Object object = syncObj;
        synchronized (object) {
            numNotStarted += value;
        }
    }

    @Override
    public final void run() {
        if (this.m_shutdown) {
            return;
        }
        try {
            this.threadMain();
        }
        catch (Exception e) {
            String message = prMessageFormat.format(prAccessor.getString("EXCEPTION_IN_THREAD"), new Object[]{this.m_name_changed ? this.m_name : this.getName()});
            SessionConfig.logMessage(message, e, SessionConfig.getLevelWarning());
        }
        catch (EAssertFailure e) {
            String message = prMessageFormat.format(prAccessor.getString("ASSERTION_FAILURE_IN_THREAD"), new Object[]{this.m_name_changed ? this.m_name : this.getName()});
            SessionConfig.logMessage(message, e, SessionConfig.getLevelWarning());
        }
        catch (OutOfMemoryError e) {
            String message = prMessageFormat.format(prAccessor.getString("OOM_DETECTED_BY_THREAD"), new Object[]{this.m_name_changed ? this.m_name : this.getName()});
            SessionConfig.logMessage(message, e, SessionConfig.getLevelSevere());
            if (SessionConfig.IN_BROKER) {
                try {
                    Class<?> bcClass = Class.forName("com.sonicsw.mq.components.BrokerComponent");
                    Method getBrokerComponentMethod = bcClass.getMethod("getBrokerComponent", new Class[0]);
                    Object brokerComponent = getBrokerComponentMethod.invoke(null, new Object[0]);
                    Method abortMethod = bcClass.getMethod("abort", String.class, Throwable.class, Integer.TYPE);
                    Field immediateStopBit = bcClass.getField("STOP_IMMEDIATE");
                    abortMethod.invoke(brokerComponent, prAccessor.getString("STR180"), e, immediateStopBit.getInt(null));
                }
                catch (InvocationTargetException ex) {
                    SessionConfig.logMessage(ex.getTargetException(), SessionConfig.getLevelWarning());
                    Runtime.getRuntime().halt(1);
                }
                catch (Exception ex) {
                    SessionConfig.logMessage(ex, SessionConfig.getLevelWarning());
                    Runtime.getRuntime().halt(1);
                }
            } else {
                SessionConfig.logln(prAccessor.getString("STR181"));
            }
            throw e;
        }
        catch (Error e) {
            if (!(e instanceof ThreadDeath)) {
                String message = prMessageFormat.format(prAccessor.getString("ERROR_IN_THREAD"), new Object[]{this.m_name_changed ? this.m_name : this.getName()});
                SessionConfig.logMessage(message, e, SessionConfig.getLevelWarning());
            }
            throw e;
        }
    }

    public abstract void threadMain() throws Exception;

    protected void callback(String text, int method, Object params) {
        if (this.m_callbackClass != null) {
            this.m_callbackClass.callback(text, method, params);
        } else {
            this.debug(text);
        }
    }

    public final void debug(boolean d) {
        this.DEBUG = d;
    }

    protected void logDebug(int level, String s) {
        this.logDebug(level, s, true);
    }

    protected void logDebug(int level, String s, boolean logTimestamp) {
        if (this.checkDebugFlags(level) && !DebugFilterManager.getInstance().isFilteredOut(this.m_filterData)) {
            this.debug(s, logTimestamp);
        }
    }

    public final void debug(String s) {
        this.debug(s, true);
    }

    public final void debug(String s, boolean logTimestamp) {
        if (this.debugFlags > 0) {
            SessionConfig.logln(FORMATTER.format(this.m_name, s, logTimestamp));
        }
    }

    public final void debug(String s, Throwable th) {
        if (this.debugFlags > 0) {
            StringBuilder sb = new StringBuilder();
            if (s != null) {
                sb.append(s).append("\n");
            }
            if (th != null) {
                sb.append(DebugObject.getStackTrace(th));
            }
            this.debug(sb.toString());
        }
    }

    public static void class_debug(String class_name, String s) {
        DebugThread.class_debug(class_name, 128, s);
    }

    public static void class_debug(String class_name, int debugItems, String s) {
        if (DebugState.GLOBAL_DEBUG_ON && (DebugState.getDiagnosticFlags(class_name) & debugItems) > 0) {
            SessionConfig.logln(FORMATTER.format(class_name, s));
        }
    }

    protected final DebugFilterData getFilterData() {
        return this.m_filterData;
    }

    public void debugName(String name) {
        this.m_name = name;
        this.m_name_changed = true;
        String className = DebugState.getFirstToken(name);
        this.m_filterData.setClassName(className);
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.setFlags();
        }
        if ((this.debugFlags & 0x200) > 0) {
            this.debug("Thread nameChange : hash=" + this.hashCode() + " activeCt= " + Thread.activeCount() + " notStarted " + numNotStarted);
        }
    }

    @Override
    public String toString() {
        return this.m_name;
    }

    public final boolean checkDebugFlags(int debugItems) {
        return (this.debugFlags & debugItems) > 0;
    }

    private void setFlags() {
        this.debugFlags = DebugState.getDiagnosticFlags(this.m_name);
        this.DEBUG = (this.debugFlags & 0x80) > 0;
        this.CALLBACK = (this.debugFlags & 0x400) > 0;
        this.DEBUG_UNEXPECTED = (this.debugFlags & 0x2000) > 0;
        try {
            String className;
            if (this.CALLBACK && (className = DebugState.getCallback(this.m_name)) != null) {
                this.m_callbackClass = (IDebugCallback)Class.forName(className).newInstance();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    static {
        FORMATTER = DebugFormatter.SINGLE_THREAD;
    }
}

