/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;
import progress.message.msg.IMgram;
import progress.message.msg.IPTPFlowControlHandle;
import progress.message.util.DebugState;
import progress.message.util.IndexedList;
import progress.message.util.PriorityQueue;
import progress.message.zclient.BlockedDestList;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IExpireCheck;
import progress.message.zclient.IFlowControllableOutputQueue;
import progress.message.zclient.INackable;
import progress.message.zclient.IPTPFlowControlHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.PrioQueueLimiter;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.xonce.IOutboundContext;

public class PTPFlowControlHandlerP28
extends DebugObject
implements IPTPFlowControlHandler {
    IFlowControllableOutputQueue m_queue;
    IOutboundContext m_outboundContext;
    PriorityQueue m_outQueue;
    PrioQueueLimiter m_outLimiter;
    IndexedList m_pendingQueue;
    private int m_blockedCount = 0;
    Hashtable m_ptpBlocked = new Hashtable();
    PSBlockedList m_psBlocked = new PSBlockedList();

    public PTPFlowControlHandlerP28(IFlowControllableOutputQueue queue, IOutboundContext outboundContext) {
        super(DebugState.GLOBAL_DEBUG_ON ? "PTPFlowControlHandler" : null);
        this.m_queue = queue;
        this.m_outboundContext = outboundContext;
        this.m_outQueue = queue.getOutputQueue();
        this.m_outLimiter = queue.getOutputQueueLimiter();
        this.m_pendingQueue = queue.getQueueMsgPendingQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePTPFlowControlMgram(IMgram m) {
        if (m.getType() != 37) {
            SessionConfig.logMessage("Unexpected flow control received.", SessionConfig.SEVERE);
            return;
        }
        IPTPFlowControlHandle handle = m.getPTPFlowControlHandle();
        if (this.DEBUG) {
            this.debug("PTP Flow Control mgram received: " + handle.getSubType());
        }
        switch (handle.getSubType()) {
            case 1: {
                Object object = this.m_outboundContext.getSyncObj();
                synchronized (object) {
                    this.onBlock(handle);
                }
                if (!this.CALLBACK) break;
                this.callback("", 101, new Object[]{handle.getFlowSubject().getJMSName(), handle.getRouting(), this.m_outboundContext.getUid(), this.m_outboundContext.getAppid()});
                break;
            }
            case 2: {
                handle.setSubType((byte)3);
                this.m_outboundContext.sendThrough(m);
                Object object = this.m_outboundContext.getSyncObj();
                synchronized (object) {
                    this.onResumeBegin(handle);
                }
                if (!this.CALLBACK) break;
                this.callback("", 102, new Object[]{handle.getFlowSubject().getJMSName(), handle.getRouting(), this.m_outboundContext.getUid(), this.m_outboundContext.getAppid()});
                break;
            }
            case 4: {
                Object object = this.m_outboundContext.getSyncObj();
                synchronized (object) {
                    this.onResumeComplete(handle);
                }
                if (!this.CALLBACK) break;
                this.callback("", 103, new Object[]{handle.getFlowSubject().getJMSName(), handle.getRouting(), this.m_outboundContext.getUid(), this.m_outboundContext.getAppid()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INackable handleNack(IMgram nack) {
        long tracking = nack.getAckHandle().getTrackingNumber();
        Object object = this.m_outboundContext.getSyncObj();
        synchronized (object) {
            INackable nackable = (INackable)this.m_pendingQueue.get(tracking);
            if (nackable == null) {
                return nackable;
            }
            if (nackable.isPubSub()) {
                this.m_psBlocked.onNack(nackable);
            } else {
                this.onNack(nackable);
            }
            if (this.CALLBACK) {
                this.callback("", 100, new Object[]{nackable.getSubject().getJMSName(), nackable.getRouting(), this.m_outboundContext.getUid(), this.m_outboundContext.getAppid()});
            }
            return nackable;
        }
    }

    @Override
    public final boolean interceptBlocked(INackable nackable) {
        if (nackable.isPubSub()) {
            return this.m_psBlocked.checkBlocked(nackable);
        }
        String fcDest = this.buildFullDestinationName(nackable);
        if (fcDest != null && this.m_ptpBlocked.containsKey(fcDest)) {
            if (this.DEBUG) {
                this.debug(this.m_queue.getFlowControlName() + ": Handling blocked on: " + fcDest + " trk: " + nackable.getGuarenteedTrackingNum());
            }
            if (nackable.isDiscardable()) {
                return true;
            }
            BlockedDestList bdl = (BlockedDestList)this.m_ptpBlocked.get(fcDest);
            bdl.addUnsent(nackable);
            ++this.m_blockedCount;
            return true;
        }
        return false;
    }

    @Override
    public final boolean hasBlocked() {
        return this.m_blockedCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onNack(INackable nackable) {
        String blockedDest = this.buildFullDestinationName(nackable);
        boolean notify = false;
        BlockedDestList bdl = (BlockedDestList)this.m_ptpBlocked.get(blockedDest);
        if (this.DEBUG) {
            this.debug(this.m_queue.getFlowControlName() + ": Handling Nack for " + blockedDest + " trk: " + nackable.getGuarenteedTrackingNum());
        }
        if (bdl != null) {
            BlockedDestList blockedDestList = bdl;
            synchronized (blockedDestList) {
                if (bdl.isResuming()) {
                    if (this.DEBUG) {
                        this.debug(this.m_queue.getFlowControlName() + ": Putting Nack on OQ for " + blockedDest + blockedDest + " trk: " + nackable.getGuarenteedTrackingNum());
                    }
                    this.m_outQueue.enqueue(nackable, nackable.getPriority());
                    this.m_outLimiter.add(nackable.getLimiterSize(), nackable.getPriority());
                    notify = true;
                } else {
                    if (this.DEBUG) {
                        this.debug(this.m_queue.getFlowControlName() + ": Putting Nack on block list for " + blockedDest + " trk: " + nackable.getGuarenteedTrackingNum());
                    }
                    bdl.addNacked(nackable);
                    this.m_outLimiter.add(nackable.getLimiterSize(), nackable.getPriority());
                    ++this.m_blockedCount;
                }
            }
        } else {
            if (this.DEBUG) {
                this.debug(this.m_queue.getFlowControlName() + ": Reenqueuing Nack on block list for " + blockedDest + " trk: " + nackable.getGuarenteedTrackingNum());
            }
            this.m_outQueue.enqueue(nackable, nackable.getPriority());
            this.m_outLimiter.add(nackable.getLimiterSize(), nackable.getPriority());
            notify = true;
        }
        if (notify) {
            this.m_outboundContext.notifyPTPFlowControlRelease();
        }
    }

    private final void onBlock(IPTPFlowControlHandle handle) {
        if (!handle.isPubSub()) {
            boolean notify;
            BlockedDestList bdl;
            String blockedDest = this.buildFullDestinationName(handle.getRouting(), handle.getFlowSubject(), handle.isPubSub());
            if (this.DEBUG) {
                this.debug(this.m_queue.getFlowControlName() + ": Removing blocked messages from outqueue - dest = " + blockedDest);
            }
            if ((bdl = (BlockedDestList)this.m_ptpBlocked.get(blockedDest)) == null) {
                bdl = new BlockedDestList(blockedDest);
                this.m_ptpBlocked.put(blockedDest, bdl);
            }
            PriorityQueue tempPQ = new PriorityQueue(this.m_outQueue.getNumPriorities());
            String dest = null;
            INackable nackable = null;
            while (!this.m_outQueue.isEmpty()) {
                nackable = (INackable)this.m_outQueue.dequeue();
                dest = this.buildFullDestinationName(nackable);
                if (dest != null && dest.equals(blockedDest)) {
                    if (nackable.isDiscardable()) {
                        if (!this.DEBUG) continue;
                        this.debug("Dropping discardable message");
                        continue;
                    }
                    if (this.DEBUG) {
                        this.debug(this.m_queue.getFlowControlName() + ": Adding to blocked for dest: " + blockedDest + " trk: " + nackable.getGuarenteedTrackingNum());
                    }
                    bdl.addUnsent(nackable);
                    ++this.m_blockedCount;
                    continue;
                }
                tempPQ.enqueue(nackable, nackable.getPriority());
            }
            nackable = null;
            boolean bl = notify = !tempPQ.isEmpty();
            while (!tempPQ.isEmpty()) {
                nackable = (INackable)tempPQ.dequeue();
                this.m_outQueue.enqueue(nackable, nackable.getPriority());
            }
            if (notify) {
                this.m_outboundContext.notifyPTPFlowControlRelease();
            }
            return;
        }
        this.m_psBlocked.onBlock(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onResumeBegin(IPTPFlowControlHandle handle) {
        if (handle.isPubSub()) {
            if (this.DEBUG) {
                this.debug(this.m_queue.getFlowControlName() + ": Handling Pub/Sub Resume begin on " + handle.getFlowSubject().getSubjectString());
            }
            this.m_psBlocked.onResumeBegin(handle);
        } else {
            String dest = this.buildFullDestinationName(handle.getRouting(), handle.getFlowSubject(), handle.isPubSub());
            BlockedDestList bdl = (BlockedDestList)this.m_ptpBlocked.get(dest);
            if (this.DEBUG) {
                this.debug(" PtpFlowControlHandler.onResumeBegin: " + this.m_queue.getFlowControlName() + ": Handling Resume begin on " + dest + " m_ptpBlocked.size " + this.m_ptpBlocked.size() + " " + this.m_outboundContext);
            }
            if (bdl != null) {
                BlockedDestList blockedDestList = bdl;
                synchronized (blockedDestList) {
                    bdl.setResuming(true);
                    Stack nacked = bdl.buildOrderedNackStack();
                    if (!nacked.isEmpty()) {
                        while (!nacked.isEmpty()) {
                            INackable nackable = (INackable)nacked.pop();
                            if (this.DEBUG) {
                                this.debug(this.m_queue.getFlowControlName() + ": Reenqueuing on Resume begin on " + dest + " trk: " + nackable.getGuarenteedTrackingNum());
                            }
                            this.m_outQueue.enqueue(nackable, nackable.getPriority());
                            --this.m_blockedCount;
                        }
                        this.m_outboundContext.notifyPTPFlowControlRelease();
                    }
                }
            }
            this.m_outboundContext.notifyPTPResumed(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onResumeComplete(IPTPFlowControlHandle handle) {
        if (handle.isPubSub()) {
            if (this.DEBUG) {
                this.debug(this.m_queue.getFlowControlName() + ": Handling Pub/Sub ResumeComplete on " + handle.getFlowSubject().getSubjectString());
            }
            this.m_psBlocked.onResumeComplete(handle);
        } else {
            String dest = this.buildFullDestinationName(handle.getRouting(), handle.getFlowSubject(), handle.isPubSub());
            BlockedDestList bdl = (BlockedDestList)this.m_ptpBlocked.remove(dest);
            if (this.DEBUG) {
                this.debug(this.m_queue.getFlowControlName() + ": Handling resume complete for: " + dest);
            }
            if (bdl != null) {
                boolean notify = false;
                BlockedDestList blockedDestList = bdl;
                synchronized (blockedDestList) {
                    bdl.setResuming(false);
                    Stack unsent = bdl.buildOrderedUnsentStack();
                    boolean bl = notify = !unsent.isEmpty();
                    while (!unsent.isEmpty()) {
                        INackable nackable = (INackable)unsent.pop();
                        this.m_outQueue.enqueue(nackable, nackable.getPriority());
                        --this.m_blockedCount;
                        if (!this.DEBUG) continue;
                        this.debug(this.m_queue.getFlowControlName() + ": Reenqueuing for: " + dest + " trk: " + nackable.getGuarenteedTrackingNum());
                    }
                }
                if (notify) {
                    this.m_outboundContext.notifyPTPFlowControlRelease();
                }
            }
        }
    }

    @Override
    public final boolean isDestinationBlocked(String routing, ISubject subject, boolean isPubSub) {
        if (isPubSub) {
            return this.m_psBlocked.isBlocked(subject);
        }
        String fcDest = this.buildFullDestinationName(routing, subject, isPubSub);
        return fcDest != null && this.m_ptpBlocked.containsKey(fcDest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExpired(IExpireCheck expChecker, Vector resultContainer) {
        boolean notify = false;
        if (!this.m_ptpBlocked.isEmpty()) {
            Hashtable hashtable = this.m_ptpBlocked;
            synchronized (hashtable) {
                BlockedDestList bdl = null;
                Stack unsent = null;
                Stack nacked = null;
                INackable nackable = null;
                Enumeration enu = this.m_ptpBlocked.elements();
                while (enu.hasMoreElements()) {
                    BlockedDestList blockedDestList = bdl = (BlockedDestList)enu.nextElement();
                    synchronized (blockedDestList) {
                        nacked = bdl.buildOrderedNackStack();
                        while (!nacked.isEmpty()) {
                            nackable = (INackable)nacked.pop();
                            if (expChecker.isMsgExpired(nackable)) {
                                resultContainer = this.decrementOutgoingMsgQueueLimiter(nackable, resultContainer);
                                notify = true;
                                continue;
                            }
                            bdl.addNacked(nackable);
                        }
                        unsent = bdl.buildOrderedUnsentStack();
                        while (!unsent.isEmpty()) {
                            nackable = (INackable)unsent.pop();
                            if (expChecker.isMsgExpired(nackable)) {
                                resultContainer = this.decrementOutgoingMsgQueueLimiter(nackable, resultContainer);
                                notify = true;
                                continue;
                            }
                            bdl.addUnsent(nackable);
                        }
                    }
                }
            }
        }
        if (notify) {
            this.m_outboundContext.notifyPTPFlowControlRelease();
        }
    }

    private Vector decrementOutgoingMsgQueueLimiter(INackable nackable, Vector resultContainerParam) {
        Vector<INackable> resultContainer = resultContainerParam;
        this.m_outLimiter.add(-nackable.getLimiterSize(), nackable.getPriority());
        if (resultContainer == null) {
            resultContainer = new Vector<INackable>();
        }
        resultContainer.addElement(nackable);
        --this.m_blockedCount;
        return resultContainer;
    }

    private final String buildFullDestinationName(INackable nackable) {
        if (nackable == null || nackable.getSubject() == null || !nackable.getSubject().isSubjectSet()) {
            return null;
        }
        return this.buildFullDestinationName(nackable.getRouting(), nackable.getSubject(), nackable.isPubSub());
    }

    private final String buildFullDestinationName(String routing, ISubject subject, boolean isPubSub) {
        if (subject == null || !subject.isSubjectSet() || subject.isMultiSubject()) {
            return null;
        }
        String dest = null;
        dest = routing != null && !isPubSub ? (routing.equals("") ? "::" + subject.getSubjectString() : routing + "::" + subject.getSubjectString()) : subject.getSubjectString();
        return dest;
    }

    @Override
    public final void dropBlocked() {
        if (!this.m_ptpBlocked.isEmpty()) {
            Enumeration enu = this.m_ptpBlocked.keys();
            Object dest = null;
            BlockedDestList bdl = null;
            while (enu.hasMoreElements()) {
                dest = enu.nextElement();
                bdl = (BlockedDestList)this.m_ptpBlocked.remove(dest);
                bdl.emptyBlockedList();
            }
        }
        this.m_psBlocked.dropBlocked();
        this.m_blockedCount = 0;
        this.m_outboundContext.notifyPTPFlowControlRelease();
    }

    @Override
    public final void releaseAll() {
        for (BlockedDestList bdl : this.m_ptpBlocked.values()) {
            Stack msgs = bdl.buildOrderedStack();
            while (!msgs.isEmpty()) {
                INackable nackable = (INackable)msgs.pop();
                if (this.DEBUG) {
                    this.debug(this.m_queue.getFlowControlName() + ": Reenqueuing on releaseAll on " + this.buildFullDestinationName(nackable) + " trk: " + nackable.getGuarenteedTrackingNum());
                }
                this.m_outQueue.enqueue(nackable, nackable.getPriority());
            }
        }
        this.m_ptpBlocked.clear();
        this.m_psBlocked.releaseAll();
        this.m_blockedCount = 0;
        this.m_outboundContext.notifyPTPFlowControlRelease();
    }

    @Override
    public final String[] getBlockedDestinations() {
        int count = this.m_ptpBlocked.size() + this.m_psBlocked.m_peerBlocked.size();
        String[] list = new String[count];
        int index = 0;
        Enumeration enu = this.m_ptpBlocked.keys();
        while (enu.hasMoreElements()) {
            list[index++] = (String)enu.nextElement();
        }
        for (ISubject blockedSub : this.m_psBlocked.m_peerBlocked) {
            list[index++] = blockedSub.getJMSName();
        }
        return list;
    }

    private class PSBlockedList {
        private HashSet m_peerBlocked = new HashSet();
        private HashSet m_implicitlyBlocked = new HashSet();
        private LinkedList m_unsentQueue = new LinkedList();
        private LinkedList m_nackedQueue = new LinkedList();

        private PSBlockedList() {
        }

        final boolean checkBlocked(INackable nackable) {
            ISubject subject = nackable.getSubject();
            if (subject == null || !subject.isSubjectSet()) {
                return false;
            }
            if (this.isBlocked(subject, this.m_implicitlyBlocked)) {
                if (nackable.isDiscardable()) {
                    return true;
                }
                if (PTPFlowControlHandlerP28.this.DEBUG) {
                    PTPFlowControlHandlerP28.this.debug("CheckBlocked: Adding to PS unsent list sub: " + subject.getSubjectString() + " trk: " + nackable.getGuarenteedTrackingNum());
                }
                this.addUnsent(nackable);
                return true;
            }
            return false;
        }

        final boolean isBlocked(ISubject subject) {
            if (subject == null) {
                return false;
            }
            return this.isBlocked(subject, this.m_implicitlyBlocked);
        }

        private final boolean isBlocked(ISubject subject, HashSet blockedSubjects) {
            if (blockedSubjects.isEmpty()) {
                return false;
            }
            if (subject.isMultiSubject()) {
                Iterator<ISubject> i = subject.getMultiSubjects();
                while (i.hasNext()) {
                    if (!blockedSubjects.contains(i.next())) continue;
                    return true;
                }
                return false;
            }
            return blockedSubjects.contains(subject);
        }

        private final void addUnsent(INackable nackable) {
            if (PTPFlowControlHandlerP28.this.DEBUG) {
                PTPFlowControlHandlerP28.this.debug("Adding to unsent list: " + nackable.getSubject().getSubjectString() + " trk: " + nackable.getGuarenteedTrackingNum());
            }
            this.m_unsentQueue.add(nackable);
            this.addBlocked(nackable.getSubject(), this.m_implicitlyBlocked);
            PTPFlowControlHandlerP28.this.m_blockedCount++;
        }

        private void addBlocked(ISubject s, HashSet set) {
            if (s.isMultiSubject()) {
                Iterator<ISubject> i = s.getMultiSubjects();
                while (i.hasNext()) {
                    this.addBlocked(i.next(), set);
                }
            } else {
                set.add(s);
            }
        }

        private void removeBlocked(ISubject s, HashSet set) {
            if (s.isMultiSubject()) {
                Iterator<ISubject> i = s.getMultiSubjects();
                while (i.hasNext()) {
                    this.removeBlocked(i.next(), set);
                }
            } else {
                set.remove(s);
            }
        }

        final void onBlock(IPTPFlowControlHandle handle) {
            boolean notify;
            ISubject blockSubject = handle.getFlowSubject();
            if (PTPFlowControlHandlerP28.this.DEBUG) {
                PTPFlowControlHandlerP28.this.debug("onBlock BEGIN for " + handle.getFlowSubject() + this);
            }
            this.addBlocked(handle.getFlowSubject(), this.m_peerBlocked);
            this.addBlocked(handle.getFlowSubject(), this.m_implicitlyBlocked);
            PriorityQueue tempPQ = new PriorityQueue(PTPFlowControlHandlerP28.this.m_outQueue.getNumPriorities());
            INackable nackable = null;
            while (!PTPFlowControlHandlerP28.this.m_outQueue.isEmpty()) {
                PriorityQueue.PriorityQueueElement elem = PTPFlowControlHandlerP28.this.m_outQueue.dequeueElem();
                nackable = (INackable)elem.m_payload;
                ISubject subject = nackable.getSubject();
                if (subject != null && subject.hasIntersect(blockSubject)) {
                    if (nackable.isDiscardable()) {
                        PTPFlowControlHandlerP28.this.m_outLimiter.add(-nackable.getLimiterSize(), nackable.getPriority());
                        continue;
                    }
                    if (PTPFlowControlHandlerP28.this.DEBUG) {
                        PTPFlowControlHandlerP28.this.debug(PTPFlowControlHandlerP28.this.m_queue.getFlowControlName() + ": OnBlock for  " + blockSubject.getSubjectString() + "Adding subject " + nackable.getSubject().getSubjectString() + " trk: " + nackable.getGuarenteedTrackingNum());
                    }
                    this.addUnsent(nackable);
                    continue;
                }
                tempPQ.enqueue(nackable, nackable.getPriority());
            }
            nackable = null;
            boolean bl = notify = !tempPQ.isEmpty();
            while (!tempPQ.isEmpty()) {
                PriorityQueue.PriorityQueueElement elem = tempPQ.dequeueElem();
                PTPFlowControlHandlerP28.this.m_outQueue.enqueue(elem.m_payload, elem.m_prio);
            }
            if (notify) {
                PTPFlowControlHandlerP28.this.m_outboundContext.notifyPTPFlowControlRelease();
            }
            if (PTPFlowControlHandlerP28.this.DEBUG) {
                PTPFlowControlHandlerP28.this.debug("onBlock END for " + handle.getFlowSubject() + this);
            }
        }

        final INackable onNack(INackable nackable) {
            if (this.isBlocked(nackable.getSubject(), this.m_implicitlyBlocked)) {
                if (PTPFlowControlHandlerP28.this.DEBUG) {
                    PTPFlowControlHandlerP28.this.debug(PTPFlowControlHandlerP28.this.m_queue.getFlowControlName() + ": PS Adding nack to nack list " + nackable.getSubject().getSubjectString() + " trk: " + nackable.getGuarenteedTrackingNum());
                }
                this.m_nackedQueue.add(nackable);
                PTPFlowControlHandlerP28.this.m_blockedCount++;
                PTPFlowControlHandlerP28.this.m_outLimiter.add(nackable.getLimiterSize(), nackable.getPriority());
                this.addBlocked(nackable.getSubject(), this.m_implicitlyBlocked);
            } else {
                if (PTPFlowControlHandlerP28.this.DEBUG) {
                    PTPFlowControlHandlerP28.this.debug(PTPFlowControlHandlerP28.this.m_queue.getFlowControlName() + ": PS Reenqueuing Nack with no block list list for " + nackable.getSubject().getSubjectString() + " trk: " + nackable.getGuarenteedTrackingNum());
                }
                PTPFlowControlHandlerP28.this.m_outQueue.enqueue(nackable, nackable.getPriority());
                PTPFlowControlHandlerP28.this.m_outLimiter.add(nackable.getLimiterSize(), nackable.getPriority());
                PTPFlowControlHandlerP28.this.m_outboundContext.notifyPTPFlowControlRelease();
            }
            return nackable;
        }

        final void onResumeBegin(IPTPFlowControlHandle handle) {
            if (PTPFlowControlHandlerP28.this.DEBUG) {
                PTPFlowControlHandlerP28.this.debug("ResumeBegin START for " + handle.getFlowSubject() + this);
            }
            this.removeBlocked(handle.getFlowSubject(), this.m_peerBlocked);
            boolean notify = false;
            for (int i = 0; i < this.m_nackedQueue.size(); ++i) {
                INackable nackable = (INackable)this.m_nackedQueue.get(i);
                if (!this.isBlocked(nackable.getSubject(), this.m_peerBlocked)) {
                    this.m_nackedQueue.remove(i--);
                    if (PTPFlowControlHandlerP28.this.DEBUG) {
                        PTPFlowControlHandlerP28.this.debug("Doing RB reenqueue for nacked message: " + nackable.getSubject().getSubjectString() + "trk: " + nackable.getGuarenteedTrackingNum());
                    }
                } else {
                    if (!PTPFlowControlHandlerP28.this.DEBUG) break;
                    PTPFlowControlHandlerP28.this.debug("PS RB: Found message in nacked that is still peer blocked, bailing: " + nackable.getSubject().getSubjectString() + "trk: " + nackable.getGuarenteedTrackingNum());
                    break;
                }
                notify = this.mOutQueueEnqueue(nackable);
            }
            if (notify) {
                PTPFlowControlHandlerP28.this.m_outboundContext.notifyPTPFlowControlRelease();
            }
            PTPFlowControlHandlerP28.this.m_outboundContext.notifyPTPResumed(handle.getFlowSubject().getJMSName());
            if (PTPFlowControlHandlerP28.this.DEBUG) {
                PTPFlowControlHandlerP28.this.debug("ResumeBegin DONE for " + handle.getFlowSubject() + this);
            }
        }

        final void onResumeComplete(IPTPFlowControlHandle handle) {
            INackable nackable;
            int i;
            if (PTPFlowControlHandlerP28.this.DEBUG) {
                PTPFlowControlHandlerP28.this.debug("ResumeComplete START for " + handle.getFlowSubject() + this);
            }
            if (PTPFlowControlHandlerP28.this.DEBUG) {
                PTPFlowControlHandlerP28.this.debug("Reenqueuing nacked messages:");
            }
            HashSet implicitlyBlocked = new HashSet();
            boolean notify = false;
            for (i = 0; i < this.m_nackedQueue.size(); ++i) {
                nackable = (INackable)this.m_nackedQueue.get(i);
                if (!this.isBlocked(nackable.getSubject(), this.m_peerBlocked) && !this.isBlocked(nackable.getSubject(), implicitlyBlocked)) {
                    this.m_nackedQueue.remove(i--);
                    if (PTPFlowControlHandlerP28.this.DEBUG) {
                        PTPFlowControlHandlerP28.this.debug("Doing RC reenqueue for nacked message: " + nackable.getSubject().getSubjectString() + "trk: " + nackable.getGuarenteedTrackingNum());
                    }
                    notify = this.mOutQueueEnqueue(nackable);
                    continue;
                }
                if (PTPFlowControlHandlerP28.this.DEBUG) {
                    PTPFlowControlHandlerP28.this.debug("Skipping RC nacked reenqueue b/c message is still blocked: " + nackable.getSubject().getSubjectString() + "trk: " + nackable.getGuarenteedTrackingNum());
                }
                this.addBlocked(nackable.getSubject(), implicitlyBlocked);
            }
            for (i = 0; i < this.m_unsentQueue.size(); ++i) {
                nackable = (INackable)this.m_unsentQueue.get(i);
                if (!this.isBlocked(nackable.getSubject(), this.m_peerBlocked) && !this.isBlocked(nackable.getSubject(), implicitlyBlocked)) {
                    this.m_unsentQueue.remove(i--);
                    if (PTPFlowControlHandlerP28.this.DEBUG) {
                        PTPFlowControlHandlerP28.this.debug("Doing RC reenqueue for unsent message: " + nackable.getSubject().getSubjectString() + "trk: " + nackable.getGuarenteedTrackingNum());
                    }
                    notify = this.mOutQueueEnqueue(nackable);
                    continue;
                }
                if (PTPFlowControlHandlerP28.this.DEBUG) {
                    PTPFlowControlHandlerP28.this.debug("Skipping RC unsent reenqueue b/c message is still blocked: " + nackable.getSubject().getSubjectString() + "trk: " + nackable.getGuarenteedTrackingNum());
                }
                this.addBlocked(nackable.getSubject(), implicitlyBlocked);
            }
            this.m_implicitlyBlocked = implicitlyBlocked;
            if (notify) {
                PTPFlowControlHandlerP28.this.m_outboundContext.notifyPTPFlowControlRelease();
            }
            if (PTPFlowControlHandlerP28.this.DEBUG) {
                PTPFlowControlHandlerP28.this.debug("ResumeComplete DONE for " + handle.getFlowSubject() + this);
            }
        }

        private boolean mOutQueueEnqueue(INackable nackable) {
            PTPFlowControlHandlerP28.this.m_outQueue.enqueue(nackable, nackable.getPriority());
            PTPFlowControlHandlerP28.this.m_blockedCount--;
            return true;
        }

        public String toString() {
            return "Nacked Count: " + this.m_nackedQueue.size() + " Unsent Count: " + this.m_unsentQueue.size() + " Implicitly Blocked: " + this.m_implicitlyBlocked + " Explicitly Blocked: " + this.m_peerBlocked;
        }

        final boolean isEmpty() {
            return this.m_unsentQueue.isEmpty() && this.m_nackedQueue.isEmpty();
        }

        final void dropBlocked() {
            this.m_peerBlocked.clear();
            this.m_implicitlyBlocked.clear();
            this.m_unsentQueue.clear();
            this.m_nackedQueue.clear();
        }

        final void releaseAll() {
            INackable nackable;
            while (!this.m_nackedQueue.isEmpty()) {
                nackable = (INackable)this.m_nackedQueue.removeFirst();
                if (PTPFlowControlHandlerP28.this.DEBUG) {
                    PTPFlowControlHandlerP28.this.debug("Doing releaseAll reenqueue for nacked message: " + nackable.getSubject().getSubjectString() + "trk: " + nackable.getGuarenteedTrackingNum());
                }
                PTPFlowControlHandlerP28.this.m_outQueue.enqueue(nackable, nackable.getPriority());
            }
            while (!this.m_unsentQueue.isEmpty()) {
                nackable = (INackable)this.m_unsentQueue.removeFirst();
                if (PTPFlowControlHandlerP28.this.DEBUG) {
                    PTPFlowControlHandlerP28.this.debug("Doing releaseAll reenqueue for blocked message: " + nackable.getSubject().getSubjectString() + "trk: " + nackable.getGuarenteedTrackingNum());
                }
                PTPFlowControlHandlerP28.this.m_outQueue.enqueue(nackable, nackable.getPriority());
            }
            this.m_peerBlocked.clear();
            this.m_implicitlyBlocked.clear();
        }
    }
}

