/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.io.PrintStream;
import progress.message.resources.prMessageFormat;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ESecurityInvalidLogistics;
import progress.message.zclient.prAccessor;

public class SecurityLogic {
    public static final byte INITIATOR = 1;
    public static final byte ROUTER_TOPIC = 2;
    public static final byte RESPONSE = 3;
    public static final byte ROUTER_QUEUE = 4;
    public static final int NONE = 0;
    public static final int INTEGRITY = 1;
    public static final int PRIVACY = 2;
    public static final byte SA_NONE = 0;
    public static final byte SA_QUERY = 1;
    public static final byte SA_ENCRYPT_MESSAGE_SESSION_KEY = 2;
    public static final byte SA_ENCRYPT_MESSAGE_MESSAGE_KEY = 4;
    public static final byte SA_MAC_HEADER_MESSAGE_KEY = 8;
    public static final byte SA_MAC_MESSAGE_SESSION_KEY = 16;
    public static final byte SA_MAC_MESSAGE_MESSAGE_KEY = 32;
    public static final byte SA_PROTECT_HEADER = 64;

    public static boolean isQuery(byte value) {
        return (value & 1) > 0;
    }

    public static boolean isMKeyEncryption(byte value) {
        return (value & 4) > 0;
    }

    public static boolean isSKeyEncryption(byte value) {
        return (value & 2) > 0;
    }

    public static boolean isBaseSecurity(byte value) {
        return value == 0;
    }

    public static boolean isMKeyMacHeader(byte value) {
        return (value & 8) > 0;
    }

    public static boolean isMKeyDigest(byte value) {
        return (value & 0x20) > 0;
    }

    public static boolean isSKeyDigest(byte value) {
        return (value & 0x10) > 0;
    }

    public static boolean isNoProtection(byte value) {
        return value == 0;
    }

    public static byte getPubAttr(byte priv) {
        if ((priv & 1) > 0) {
            throw new EAssertFailure(prAccessor.getString("STR123"));
        }
        switch (priv) {
            case 0: 
            case 8: {
                return 0;
            }
            case 16: 
            case 32: {
                return 1;
            }
            case 18: 
            case 36: {
                return 2;
            }
        }
        throw new EAssertFailure(prAccessor.getString("STR124"));
    }

    public static byte AttribsFromPrivate(byte location, byte priv) throws ESecurityInvalidLogistics {
        switch (location) {
            case 1: {
                throw new ESecurityInvalidLogistics();
            }
            case 4: {
                throw new ESecurityInvalidLogistics();
            }
            case 2: {
                switch (priv) {
                    case 0: 
                    case 8: {
                        return 8;
                    }
                    case 16: 
                    case 32: {
                        return 32;
                    }
                    case 18: 
                    case 36: {
                        return 36;
                    }
                }
                throw new ESecurityInvalidLogistics();
            }
            case 3: {
                switch (priv) {
                    case 0: 
                    case 8: {
                        return 0;
                    }
                    case 16: 
                    case 32: {
                        return 16;
                    }
                    case 18: 
                    case 36: {
                        return 18;
                    }
                }
                throw new ESecurityInvalidLogistics();
            }
        }
        throw new ESecurityInvalidLogistics();
    }

    public static byte AttribsFromPublic(byte location, byte pub) throws ESecurityInvalidLogistics {
        switch (location) {
            case 1: 
            case 4: {
                switch ((short)pub) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 16;
                    }
                    case 2: {
                        return 18;
                    }
                }
                throw new EAssertFailure(prMessageFormat.format(prAccessor.getString("STR125"), new Object[]{Byte.toString(pub)}));
            }
            case 2: {
                switch ((short)pub) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 32;
                    }
                    case 2: {
                        return 36;
                    }
                }
                throw new EAssertFailure(prMessageFormat.format(prAccessor.getString("STR126"), new Object[]{Byte.toString(pub)}));
            }
            case 3: {
                throw new ESecurityInvalidLogistics();
            }
        }
        throw new ESecurityInvalidLogistics();
    }

    public static byte AttribsFromQuery(byte pub) {
        switch ((short)pub) {
            case 0: {
                return 8;
            }
            case 1: {
                return 32;
            }
            case 2: {
                return 36;
            }
        }
        throw new EAssertFailure(prAccessor.getString("STR127"));
    }

    public static byte getQueryAttribs() {
        return 19;
    }

    public static boolean verifyQuery(byte b) {
        return b == SecurityLogic.getQueryAttribs();
    }

    private static boolean isBitSet(int value, int mask) {
        return (value & mask) > 0;
    }

    public static void debugPrintPrivate(byte sa) {
        System.out.print("flags[");
        if (sa == 0) {
            System.out.println("SA_NONE]");
            return;
        }
        if (SecurityLogic.isQuery(sa)) {
            System.out.print("SA_QUERY ");
        }
        if (SecurityLogic.isMKeyMacHeader(sa)) {
            System.out.print("SA_MAC_HEADER_MESSAGE_KEY");
        }
        if (SecurityLogic.isSKeyEncryption(sa)) {
            System.out.print("SA_ENCRYPT_MESSAGE_SESSION_KEY ");
        }
        if (SecurityLogic.isMKeyEncryption(sa)) {
            System.out.print("SA_ENCRYPT_MESSAGE_MESSAGE_KEY ");
        }
        if (SecurityLogic.isSKeyDigest(sa)) {
            System.out.print("SA_MAC_MESSAGE_SESSION_KEY ");
        }
        if (SecurityLogic.isMKeyDigest(sa)) {
            System.out.print("SA_MAC_MESSAGE_MESSAGE_KEY ");
        }
        System.out.println("]");
    }

    public static String debugStringPrivate(byte sa) {
        if (sa == 0) {
            return "None";
        }
        StringBuffer buf = new StringBuffer();
        if (SecurityLogic.isQuery(sa)) {
            buf.append("Query*");
        }
        if (SecurityLogic.isMKeyMacHeader(sa)) {
            buf.append("MacHeaderMKey*");
        }
        if (SecurityLogic.isSKeyEncryption(sa)) {
            buf.append("EncrSKey*");
        }
        if (SecurityLogic.isMKeyEncryption(sa)) {
            buf.append("EncrMkey*");
        }
        if (SecurityLogic.isSKeyDigest(sa)) {
            buf.append("MacMsgSKey*");
        }
        if (SecurityLogic.isMKeyDigest(sa)) {
            buf.append("MacMsgMKey*");
        }
        return buf.toString();
    }

    public static void debugPrintPublic(byte a) {
        SecurityLogic.debugPrint(System.out, a);
        System.out.println();
    }

    public static void debugPrint(PrintStream pos, byte a) {
        pos.print("flags[");
        if (a == 0) {
            pos.print("NONE ]");
        } else if (a == 1) {
            pos.print("INTEGRITY ]");
        } else if (a == 2) {
            pos.print("PRIVACY ]");
        }
    }
}

