/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IPrioQueueLimiter;
import progress.message.zclient.IQuencher;

public final class SingleMessageLimiter
extends DebugObject
implements IPrioQueueLimiter {
    private int m_msgCount = 0;
    private IQuencher m_quencher;
    private boolean m_isflowControlled = false;
    private boolean m_inRecovery = false;

    public SingleMessageLimiter(IQuencher quencher) {
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("SingleMessageLimiter");
        }
        this.m_quencher = quencher;
    }

    @Override
    public void add(int size, int priority) {
        if (size > 0) {
            ++this.m_msgCount;
            if (this.DEBUG) {
                this.debug("message received, total message count = " + this.m_msgCount);
            }
            if (!this.m_isflowControlled) {
                if (this.m_inRecovery) {
                    if (this.DEBUG) {
                        this.debug("surpressing flow control during recovery...");
                    }
                    return;
                }
                if (this.DEBUG) {
                    this.debug("notifying sender to stop sending...");
                }
                this.m_quencher.setMinEnqueuePriority(10);
                this.m_isflowControlled = true;
            }
        } else if (size < 0) {
            --this.m_msgCount;
            if (this.m_isflowControlled && this.m_msgCount <= 1) {
                if (this.DEBUG) {
                    this.debug("message count = " + this.m_msgCount + ", notifying sender to resume sending...");
                }
                this.m_quencher.setMinEnqueuePriority(0);
                this.m_isflowControlled = false;
            }
        }
    }

    @Override
    public void resetMinPriority(int prio) {
        this.m_quencher.setMinEnqueuePriority(prio);
    }

    @Override
    public int size() {
        return this.m_msgCount;
    }

    public void beginDisableFlowControl() {
        if (this.DEBUG) {
            this.debug("m_msgCount = " + this.m_msgCount + ", m_isflowControlled = " + this.m_isflowControlled + ", surpress flow control during recovery...");
        }
        this.m_inRecovery = true;
        this.m_isflowControlled = false;
    }

    public void endDisableFlowControl() {
        if (this.DEBUG) {
            this.debug("m_msgCount = " + this.m_msgCount + ", m_isflowControlled = " + this.m_isflowControlled + ", re-instate flow control after recovery...");
        }
        this.m_inRecovery = false;
    }
}

