/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import progress.message.zclient.DebugObject;
import progress.message.zclient.WeightedItem;

public class WeightedItemTable
extends DebugObject {
    private HashMap m_hashmap = new HashMap();
    private WeightedItemComparator m_comparator = new WeightedItemComparator();

    public void removeItem(Object item) {
        this.m_hashmap.remove(item);
    }

    public void loadInitialItems(Object item, long initialWeight) {
        this.m_hashmap.clear();
        WeightedItem wi = new WeightedItem(item, initialWeight);
        wi.setSecondaryWeight(0L);
        this.m_hashmap.put(item, wi);
    }

    public void loadInitialItems(Object[] item, long initialWeight) {
        this.loadInitialItems(item, 0, initialWeight);
    }

    public void loadInitialItems(Object[] items, int startItem, long initialWeight) {
        this.m_hashmap.clear();
        int numItems = items.length;
        for (int i = 0; i < numItems; ++i) {
            int itemIndex = (i + startItem) % numItems;
            Object item = items[itemIndex];
            WeightedItem wi = new WeightedItem(item, initialWeight);
            wi.setSecondaryWeight(i);
            this.m_hashmap.put(item, wi);
        }
    }

    public WeightedItem updateItem(Object item, long weight) {
        WeightedItem wi = (WeightedItem)this.m_hashmap.get(item);
        if (wi != null) {
            wi.setWeight(weight);
        } else {
            wi = new WeightedItem(item, weight);
            wi.setSecondaryWeight(this.m_hashmap.size() + 1);
            this.m_hashmap.put(item, wi);
        }
        return wi;
    }

    public long totalWeight() {
        long weight = 0L;
        Set a = this.m_hashmap.entrySet();
        Iterator it = a.iterator();
        Map.Entry e = null;
        while (it.hasNext()) {
            e = it.next();
            WeightedItem wi = (WeightedItem)e.getValue();
            weight += wi.getWeight();
        }
        return weight;
    }

    public long size() {
        return this.m_hashmap.size();
    }

    public void clear() {
        this.m_hashmap.clear();
    }

    public Collection sort() {
        ArrayList al = new ArrayList();
        al.addAll(this.m_hashmap.values());
        Collections.sort(al, this.m_comparator);
        return al;
    }

    public String dump() {
        StringBuffer sb = new StringBuffer("WeightedItemTable Dump\n");
        Collection c = this.sort();
        for (WeightedItem wi : c) {
            sb.append("WEIGHT=" + wi.getWeight() + ",ITEM=" + wi.getItem() + "\n");
        }
        sb.append("End Of Dump\n");
        return sb.toString();
    }

    class WeightedItemComparator
    implements Comparator {
        private static final int BEFORE = -1;
        private static final int AFTER = 1;
        private static final int EQUALS = 0;

        WeightedItemComparator() {
        }

        public int compare(Object o1, Object o2) {
            long w2;
            WeightedItem wi1 = (WeightedItem)o1;
            WeightedItem wi2 = (WeightedItem)o2;
            long w1 = wi1.getWeight();
            if (w1 > (w2 = wi2.getWeight())) {
                return -1;
            }
            if (w1 == w2) {
                long w22;
                long w12 = wi1.getSecondaryWeight();
                if (w12 < (w22 = wi2.getSecondaryWeight())) {
                    return -1;
                }
                if (w12 == w22) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
    }
}

