/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.io.IOException;
import progress.message.zclient.Connection;
import progress.message.zclient.Envelope;
import progress.message.zclient.IJobResolver;
import progress.message.zclient.Job;
import progress.message.zclient.SessionConfig;

public class AAFJobResolver
implements IJobResolver {
    private Envelope m_env = null;
    private Connection m_con = null;

    public AAFJobResolver(Envelope env, Connection con) {
        this.m_env = env;
        this.m_con = con;
    }

    @Override
    public void resolveJob(Job job) {
        boolean ackPersistent = (Boolean)this.m_env.getProperty("origPersistent");
        boolean forwardPersistent = this.m_env.getLabel().isPersistent() || this.m_env.isNonPersistentReplicated();
        try {
            if (!ackPersistent && !forwardPersistent) {
                job.setStatus(0);
            } else if (ackPersistent && forwardPersistent) {
                this.m_env.getProperties().put("retriedAfterRecovery", new Boolean(true));
                this.m_env.syncAll(this.m_con, this.m_con.getClientSender().getMessageProtection());
                this.m_con.send(this.m_env.getMgram());
            }
        }
        catch (IOException ioe) {
            SessionConfig.logMessage(ioe, SessionConfig.getLevelWarning());
        }
    }
}

