/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.io.IOException;
import progress.message.client.EBrokerStateDiscarded;
import progress.message.client.EConnectionNotResumable;
import progress.message.client.EGeneralException;
import progress.message.msg.IConnectionSyncHandle;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.resources.prMessageFormat;
import progress.message.util.AutoVec;
import progress.message.zclient.Connection;
import progress.message.zclient.DebugObject;
import progress.message.zclient.IDirectSender;
import progress.message.zclient.prAccessor;
import progress.message.zclient.xonce.ConnectionSyncData;
import progress.message.zclient.xonce.IConnectionSyncHandler;
import progress.message.zclient.xonce.IDoubtResolver;
import progress.message.zclient.xonce.IDoubtResolverCompletionListener;

public class ConnectionSyncResolver
extends DebugObject
implements IDoubtResolver,
IConnectionSyncHandler {
    private IDirectSender m_sender;
    private IDoubtResolverCompletionListener m_listener = null;
    private AutoVec m_channelsToResolve;
    private AutoVec m_mySyncData;

    public ConnectionSyncResolver(IDirectSender sender, AutoVec channelsToResolve) {
        super("ConnectionSyncResolver");
        this.m_sender = sender;
        this.m_channelsToResolve = channelsToResolve;
    }

    @Override
    public void initiateResolution() throws EGeneralException, IOException {
        this.m_mySyncData = new AutoVec();
        for (int i = 0; i < this.m_channelsToResolve.size(); ++i) {
            Connection c = (Connection)this.m_channelsToResolve.elementAt(i);
            if (c != null && c.needsConnectionSynchronization()) {
                this.m_mySyncData.setElementAt(c.getSyncData(), i);
                continue;
            }
            this.m_mySyncData.setElementAt(null, i);
        }
        IMgram m = MgramFactory.getMgramFactory().buildConnectionSyncMgram(this.m_mySyncData);
        this.m_sender.sendDirect(m);
    }

    @Override
    public void handleConnectionSync(IMgram mgram) throws IOException {
        Connection c;
        int i;
        IConnectionSyncHandle handle = mgram.getConnectionSyncHandle();
        AutoVec syncData = handle.getConnectionSyncData();
        for (i = 1; i < syncData.size(); ++i) {
            if (this.m_mySyncData == null) {
                throw new IOException("Unexpected connection sync received !");
            }
            ConnectionSyncData cbroker = (ConnectionSyncData)syncData.elementAt(i);
            if (cbroker == null) continue;
            c = (Connection)this.m_channelsToResolve.elementAt(i);
            c.setBrokerRetainsJMSNonDurableState((cbroker.getFlags() & 1) != 0);
            this.m_mySyncData.setElementAt(null, i);
            Connection clocal = (Connection)this.m_channelsToResolve.elementAt(i);
            if (clocal == null || cbroker.getState() != 0) continue;
            clocal.internallyConnectTunnel(cbroker);
        }
        for (i = 1; i < this.m_mySyncData.size(); ++i) {
            ConnectionSyncData myResidual = (ConnectionSyncData)this.m_mySyncData.elementAt(i);
            if (myResidual == null || myResidual.getState() != 0) continue;
            c = (Connection)this.m_channelsToResolve.elementAt(i);
            String text = prMessageFormat.format(prAccessor.getString("CONNECTION_PART_RESUMABLE"), new Object[]{c.getApplicationId()});
            EConnectionNotResumable ecnr = new EConnectionNotResumable(prAccessor.getString("CONNECTION_UNRESUMABLE"), new EBrokerStateDiscarded(text));
            this.m_listener.failed(this, ecnr);
            return;
        }
        if (this.m_listener != null) {
            this.m_listener.completed(this, 0);
        }
    }

    @Override
    public void onDisconnectDuringResolution() {
    }

    @Override
    public void setCompletionListener(IDoubtResolverCompletionListener listener) {
        this.m_listener = listener;
    }
}

