/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.util.List;
import java.util.Vector;
import progress.message.client.EGeneralException;
import progress.message.zclient.xonce.IDoubtResolverCompletionListener;
import progress.message.zclient.xonce.IIDRInboundSupport;
import progress.message.zclient.xonce.IIDRTransport;
import progress.message.zclient.xonce.IInboundContext;

public class IDRInboundAdapter
implements IIDRInboundSupport {
    private IInboundContext m_adaptee = null;
    private IDoubtResolverCompletionListener m_listener = null;
    private IIDRTransport m_transport = null;
    private boolean m_dnrsDone = false;
    private boolean m_ugasDone = false;
    private boolean m_preqsDone = false;
    private Vector m_requestsPendingReply = null;
    private List m_ptpUGA = new Vector();
    private List m_pubsubUGA = new Vector();

    public IDRInboundAdapter(IInboundContext adaptee) {
        this.m_adaptee = adaptee;
        this.m_requestsPendingReply = new Vector();
    }

    @Override
    public List getDNRTrackNums(int category) {
        if (category == 0) {
            return this.m_adaptee.getGuarQMsgTrkNums();
        }
        return this.m_adaptee.getGuarMsgTrkNums();
    }

    @Override
    public List getUGATrackNums(int category) {
        if (category == 0) {
            this.m_ptpUGA = this.m_adaptee.getUnconfirmedGuarQAcks();
            return this.m_ptpUGA;
        }
        this.m_pubsubUGA = this.m_adaptee.getUnconfirmedGuarAcks();
        return this.m_pubsubUGA;
    }

    @Override
    public List getPREPTrackNums() {
        return this.m_adaptee.getPendingReplies();
    }

    @Override
    public void setTransport(IIDRTransport transport) {
        this.m_transport = transport;
    }

    @Override
    public void initiateResolution() throws EGeneralException {
        this.m_ugasDone = false;
        this.m_dnrsDone = false;
        this.m_requestsPendingReply = new Vector();
    }

    @Override
    public void onDisconnectDuringResolution() {
    }

    @Override
    public void setCompletionListener(IDoubtResolverCompletionListener listener) {
        this.m_listener = listener;
    }

    @Override
    public void allDNRsConfirmed() {
        this.m_dnrsDone = true;
        this.checkComplete();
    }

    @Override
    public void allUGAsConfirmed() {
        this.m_ugasDone = true;
        this.checkComplete();
    }

    @Override
    public void PREQReceived(long tracking) {
        this.m_requestsPendingReply.add(new Long(tracking));
    }

    @Override
    public void allPREQsReceived() {
        this.m_preqsDone = true;
        this.checkComplete();
    }

    private void checkComplete() {
        if (this.m_dnrsDone && this.m_ugasDone && this.m_preqsDone) {
            this.m_adaptee.guarQAcksDone(this.m_ptpUGA);
            this.m_adaptee.guarAcksDone(this.m_pubsubUGA);
            this.m_adaptee.notifyRequestsPendingReply(this.m_requestsPendingReply);
            if (this.m_listener != null) {
                this.m_listener.completed(this, 0);
            }
        }
    }
}

