/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.util.List;
import java.util.Vector;
import progress.message.client.EGeneralException;
import progress.message.zclient.xonce.IDoubtResolverCompletionListener;
import progress.message.zclient.xonce.IIDROutboundSupport;
import progress.message.zclient.xonce.IIDRTransport;
import progress.message.zclient.xonce.IOutboundContext;

public class IDROutboundAdapter
implements IIDROutboundSupport {
    private IIDRTransport m_transport = null;
    private IDoubtResolverCompletionListener m_listener = null;
    private IOutboundContext m_adaptee = null;
    private boolean m_dnrsDone = false;
    private boolean m_ugasDone = false;
    private boolean m_prepsDone = false;
    private Vector leavePendingQMsgs = null;
    private Vector leavePendingMsgs = null;
    private Vector leavePendingRequests = null;

    public IDROutboundAdapter(IOutboundContext adaptee) {
        this.m_adaptee = adaptee;
        this.leavePendingQMsgs = new Vector();
        this.leavePendingMsgs = new Vector();
        this.leavePendingRequests = new Vector();
    }

    @Override
    public boolean hasGuaranteedMessagesPending() {
        return this.m_adaptee.hasInDoubtState();
    }

    @Override
    public void dnrReceived(long tracking, int category) {
        if (category == 0) {
            this.leavePendingQMsgs.add(new Long(tracking));
        } else {
            this.leavePendingMsgs.add(new Long(tracking));
        }
    }

    @Override
    public void allDNRsReceived() {
        this.m_dnrsDone = true;
        this.checkComplete();
    }

    @Override
    public void ugaReceived(long tracking, int category) {
        if (category == 0) {
            this.m_adaptee.inDoubtQMsgAcked(tracking);
        } else {
            this.m_adaptee.inDoubtMsgAcked(tracking);
        }
    }

    @Override
    public void allUGAsReceived() {
        this.m_ugasDone = true;
        this.checkComplete();
    }

    @Override
    public void PREPReceived(long tracking) {
        this.leavePendingRequests.add(new Long(tracking));
    }

    @Override
    public void allPREPsReceived() {
        this.m_prepsDone = true;
        this.checkComplete();
    }

    @Override
    public List getPREQTrackNums() {
        return this.m_adaptee.getPendingRequests();
    }

    @Override
    public void setTransport(IIDRTransport transport) {
        this.m_transport = transport;
    }

    @Override
    public void initiateResolution() throws EGeneralException {
        this.m_ugasDone = false;
        this.m_dnrsDone = false;
        this.m_prepsDone = false;
        this.leavePendingQMsgs = new Vector();
        this.leavePendingMsgs = new Vector();
        this.leavePendingRequests = new Vector();
    }

    @Override
    public void onDisconnectDuringResolution() {
    }

    @Override
    public void setCompletionListener(IDoubtResolverCompletionListener listener) {
        this.m_listener = listener;
    }

    private void checkComplete() {
        if (this.m_dnrsDone && this.m_ugasDone && this.m_prepsDone) {
            this.m_adaptee.allInDoubtMsgsAcked(this.leavePendingQMsgs, this.leavePendingMsgs, this.leavePendingRequests);
            if (this.m_listener != null) {
                this.m_listener.completed(this, 0);
            }
        }
    }
}

