/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient.xonce;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import progress.message.zclient.Connection;
import progress.message.zclient.Label;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subscription;
import progress.message.zclient.xonce.IDoubtResolver;
import progress.message.zclient.xonce.IDoubtResolverCompletionListener;

public class SecondaryStateResolver
implements IDoubtResolver,
IDoubtResolverCompletionListener {
    private IDoubtResolverCompletionListener m_listener = null;
    private Connection m_con = null;

    public SecondaryStateResolver(Connection c) {
        this.m_con = c;
    }

    @Override
    public void initiateResolution() throws IOException {
        IDoubtResolver appResolver = this.m_con.getApplicationLevelResolver();
        if (appResolver != null) {
            appResolver.setCompletionListener(this);
            appResolver.initiateResolution();
            return;
        }
        this.resubscribeSubscriptions();
        if (this.m_listener != null) {
            this.m_listener.completed(this, 0);
        }
    }

    @Override
    public void onDisconnectDuringResolution() {
    }

    @Override
    public void setCompletionListener(IDoubtResolverCompletionListener listener) {
        this.m_listener = listener;
    }

    @Override
    public void completed(IDoubtResolver res, int status) {
        if (this.m_listener != null) {
            this.m_listener.completed(this, 0);
        }
    }

    @Override
    public void failed(IDoubtResolver res, IOException ioe) {
        if (this.m_listener != null) {
            this.m_listener.failed(this, ioe);
        }
    }

    private void resubscribeSubscriptions() throws IOException {
        Vector v = new Vector();
        Enumeration e = this.m_con.getLocalSubscriptionTable().elements();
        while (e.hasMoreElements()) {
            Subscription s = (Subscription)e.nextElement();
            Label l = s.getDeliveryLabelNoLock();
            if (!l.isPersistent()) {
                if (this.m_con.isEnterpriseEdition() && SessionConfig.isNonDurableSubscriber(this.m_con.getApplicationId()) && this.m_con.getBrokerRetainsJMSNonDurableState()) continue;
                s.sendSubscribeRequestNoLock();
                continue;
            }
            if (this.m_con.isEnterpriseEdition() || s.getFlowToDisk() == 0) continue;
            s.sendSubscribeRequestNoLock();
        }
    }
}

