/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

import java.io.IOException;
import java.io.PrintStream;
import progress.message.crypto.MessageDigest;
import progress.message.crypto.prAccessor;
import progress.message.util.EAssertFailure;
import progress.message.util.Hex;

public final class MD5
extends MessageDigest
implements Cloneable {
    public static final boolean DEBUG = false;
    public static final int HASH_LENGTH = 16;
    public static final int DATA_LENGTH = 64;
    protected int[] data;
    protected int[] digest;
    protected byte[] tmp;
    private byte[] contextBuf;

    @Override
    public final int hash_length() {
        return 16;
    }

    @Override
    public final int data_length() {
        return 64;
    }

    @Override
    public String name() {
        return "MD5";
    }

    public MD5() {
        this.java_init();
        this.reset();
    }

    @Override
    public Object clone() {
        MD5 clone = (MD5)super.clone();
        if (this.data != null) {
            clone.data = (int[])this.data.clone();
        }
        if (this.digest != null) {
            clone.digest = (int[])this.digest.clone();
        }
        if (this.tmp != null) {
            clone.tmp = (byte[])this.tmp.clone();
        }
        if (this.contextBuf != null) {
            clone.contextBuf = (byte[])this.contextBuf.clone();
        }
        return clone;
    }

    private void java_init() {
        this.digest = new int[4];
        this.data = new int[16];
        this.tmp = new byte[64];
    }

    @Override
    public void md_reset() {
        this.java_reset();
    }

    private void java_reset() {
        this.digest[0] = 1732584193;
        this.digest[1] = -271733879;
        this.digest[2] = -1732584194;
        this.digest[3] = 271733878;
    }

    @Override
    protected void md_transform() {
        this.java_transform();
    }

    protected void java_transform() {
        MD5.byte2int(this.data, 0, this.buf(), 0, 16);
        this.transform(this.data);
    }

    @Override
    protected void md_digest(byte[] buf, int offset, int len) {
        if (len < 16) {
            throw new EAssertFailure("len < 16");
        }
        this.java_digest(buf, offset, len);
    }

    private void java_digest(byte[] buf, int off, int len) {
        int pos = this.buf_off();
        if (pos != 0) {
            System.arraycopy(this.buf(), 0, this.tmp, 0, pos);
        }
        this.tmp[pos++] = -128;
        if (pos > 56) {
            while (pos < 64) {
                this.tmp[pos++] = 0;
            }
            MD5.byte2int(this.data, 0, this.tmp, 0, 16);
            this.transform(this.data);
            pos = 0;
        }
        while (pos < 56) {
            this.tmp[pos++] = 0;
        }
        MD5.byte2int(this.data, 0, this.tmp, 0, 14);
        this.data[14] = (int)this.bitcount();
        this.data[15] = (int)(this.bitcount() >>> 32);
        this.transform(this.data);
        for (int i = 0; i < 4; ++i) {
            int d = this.digest[i];
            buf[off++] = (byte)d;
            buf[off++] = (byte)(d >>> 8);
            buf[off++] = (byte)(d >>> 16);
            buf[off++] = (byte)(d >>> 24);
        }
    }

    public static byte[] hash(String msg) {
        return MD5.hash(msg, (MessageDigest)new MD5());
    }

    public static byte[] hash(byte[] msg) {
        return MD5.hash(msg, (MessageDigest)new MD5());
    }

    protected static int F(int x, int y, int z) {
        return z ^ x & (y ^ z);
    }

    protected static int G(int x, int y, int z) {
        return y ^ z & (x ^ y);
    }

    protected static int H(int x, int y, int z) {
        return x ^ y ^ z;
    }

    protected static int I(int x, int y, int z) {
        return y ^ (x | ~z);
    }

    protected static int FF(int a, int b, int c, int d, int k, int s, int t) {
        a += k + t + MD5.F(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    protected static int GG(int a, int b, int c, int d, int k, int s, int t) {
        a += k + t + MD5.G(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    protected static int HH(int a, int b, int c, int d, int k, int s, int t) {
        a += k + t + MD5.H(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    protected static int II(int a, int b, int c, int d, int k, int s, int t) {
        a += k + t + MD5.I(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    protected void transform(int[] M) {
        int a = this.digest[0];
        int b = this.digest[1];
        int c = this.digest[2];
        int d = this.digest[3];
        a = MD5.FF(a, b, c, d, M[0], 7, -680876936);
        d = MD5.FF(d, a, b, c, M[1], 12, -389564586);
        c = MD5.FF(c, d, a, b, M[2], 17, 606105819);
        b = MD5.FF(b, c, d, a, M[3], 22, -1044525330);
        a = MD5.FF(a, b, c, d, M[4], 7, -176418897);
        d = MD5.FF(d, a, b, c, M[5], 12, 1200080426);
        c = MD5.FF(c, d, a, b, M[6], 17, -1473231341);
        b = MD5.FF(b, c, d, a, M[7], 22, -45705983);
        a = MD5.FF(a, b, c, d, M[8], 7, 1770035416);
        d = MD5.FF(d, a, b, c, M[9], 12, -1958414417);
        c = MD5.FF(c, d, a, b, M[10], 17, -42063);
        b = MD5.FF(b, c, d, a, M[11], 22, -1990404162);
        a = MD5.FF(a, b, c, d, M[12], 7, 1804603682);
        d = MD5.FF(d, a, b, c, M[13], 12, -40341101);
        c = MD5.FF(c, d, a, b, M[14], 17, -1502002290);
        b = MD5.FF(b, c, d, a, M[15], 22, 1236535329);
        a = MD5.GG(a, b, c, d, M[1], 5, -165796510);
        d = MD5.GG(d, a, b, c, M[6], 9, -1069501632);
        c = MD5.GG(c, d, a, b, M[11], 14, 643717713);
        b = MD5.GG(b, c, d, a, M[0], 20, -373897302);
        a = MD5.GG(a, b, c, d, M[5], 5, -701558691);
        d = MD5.GG(d, a, b, c, M[10], 9, 38016083);
        c = MD5.GG(c, d, a, b, M[15], 14, -660478335);
        b = MD5.GG(b, c, d, a, M[4], 20, -405537848);
        a = MD5.GG(a, b, c, d, M[9], 5, 568446438);
        d = MD5.GG(d, a, b, c, M[14], 9, -1019803690);
        c = MD5.GG(c, d, a, b, M[3], 14, -187363961);
        b = MD5.GG(b, c, d, a, M[8], 20, 1163531501);
        a = MD5.GG(a, b, c, d, M[13], 5, -1444681467);
        d = MD5.GG(d, a, b, c, M[2], 9, -51403784);
        c = MD5.GG(c, d, a, b, M[7], 14, 1735328473);
        b = MD5.GG(b, c, d, a, M[12], 20, -1926607734);
        a = MD5.HH(a, b, c, d, M[5], 4, -378558);
        d = MD5.HH(d, a, b, c, M[8], 11, -2022574463);
        c = MD5.HH(c, d, a, b, M[11], 16, 1839030562);
        b = MD5.HH(b, c, d, a, M[14], 23, -35309556);
        a = MD5.HH(a, b, c, d, M[1], 4, -1530992060);
        d = MD5.HH(d, a, b, c, M[4], 11, 1272893353);
        c = MD5.HH(c, d, a, b, M[7], 16, -155497632);
        b = MD5.HH(b, c, d, a, M[10], 23, -1094730640);
        a = MD5.HH(a, b, c, d, M[13], 4, 681279174);
        d = MD5.HH(d, a, b, c, M[0], 11, -358537222);
        c = MD5.HH(c, d, a, b, M[3], 16, -722521979);
        b = MD5.HH(b, c, d, a, M[6], 23, 76029189);
        a = MD5.HH(a, b, c, d, M[9], 4, -640364487);
        d = MD5.HH(d, a, b, c, M[12], 11, -421815835);
        c = MD5.HH(c, d, a, b, M[15], 16, 530742520);
        b = MD5.HH(b, c, d, a, M[2], 23, -995338651);
        a = MD5.II(a, b, c, d, M[0], 6, -198630844);
        d = MD5.II(d, a, b, c, M[7], 10, 1126891415);
        c = MD5.II(c, d, a, b, M[14], 15, -1416354905);
        b = MD5.II(b, c, d, a, M[5], 21, -57434055);
        a = MD5.II(a, b, c, d, M[12], 6, 1700485571);
        d = MD5.II(d, a, b, c, M[3], 10, -1894986606);
        c = MD5.II(c, d, a, b, M[10], 15, -1051523);
        b = MD5.II(b, c, d, a, M[1], 21, -2054922799);
        a = MD5.II(a, b, c, d, M[8], 6, 1873313359);
        d = MD5.II(d, a, b, c, M[15], 10, -30611744);
        c = MD5.II(c, d, a, b, M[6], 15, -1560198380);
        b = MD5.II(b, c, d, a, M[13], 21, 1309151649);
        a = MD5.II(a, b, c, d, M[4], 6, -145523070);
        d = MD5.II(d, a, b, c, M[11], 10, -1120210379);
        c = MD5.II(c, d, a, b, M[2], 15, 718787259);
        b = MD5.II(b, c, d, a, M[9], 21, -343485551);
        this.digest[0] = this.digest[0] + a;
        this.digest[1] = this.digest[1] + b;
        this.digest[2] = this.digest[2] + c;
        this.digest[3] = this.digest[3] + d;
    }

    @Override
    protected void md_update(byte[] input, int offset, int len) {
        this.java_update(input, offset, len);
    }

    public static final void byte2int(int[] dst, int dst_off, byte[] src, int src_off, int len) {
        while (len-- > 0) {
            dst[dst_off++] = src[src_off++] & 0xFF | src[src_off++] << 8 & 0xFF00 | src[src_off++] << 16 & 0xFF0000 | src[src_off++] << 24;
        }
    }

    public static final void main(String[] argv) throws IOException {
        try {
            MD5.self_test(System.out, argv);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void self_test(PrintStream out, String[] argv) throws Exception {
        MD5.test(out, "", "d41d8cd98f00b204e9800998ecf8427e");
        MD5.test(out, "a", "0cc175b9c0f1b6a831c399e269772661");
        MD5.test(out, "aa", "4124bc0a9335c27f086f24ba207a4912");
        MD5.test(out, "aaa", "47bce5c74f589f4867dbd57e9ca9f808");
        MD5.test(out, "bbb", "08f8e0260c64418510cefb2b06eee5cd");
        MD5.test(out, "ccc", "9df62e693988eb4e1e1444ece0578579");
        MD5.test(out, "abc", "900150983cd24fb0d6963f7d28e17f72");
        MD5.test(out, "abcdefg", "7ac66c0f148de9519b8bd264312c4d64");
        MD5.test(out, "abcdefghijk", "92b9cccc0b98c3a0b8d0df25a421c0e3");
        MD5.test(out, "message digest", "f96b697d7cb7938d525a2f31aaf161d0");
        MD5.test(out, "abcdefghijklmnopqrstuvwxyz", "c3fcd3d76192e4007dfb496cca67e13b");
        MD5.test(out, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", "d174ab98d277d9f5a5611c2c9f419d9f");
        MD5.test(out, "12345678901234567890123456789012345678901234567890123456789012345678901234567890", "57edf4a22be3c955ac49da2e2107b67a");
    }

    private static void test(PrintStream out, String msg, String hashStr) {
        hashStr = hashStr.toUpperCase();
        MD5 md5 = new MD5();
        md5.add(msg);
        String x = MD5.toString(md5.digest());
        out.println("Message " + msg);
        out.println("calculated: " + x);
        out.println("expected:   " + hashStr);
        if (hashStr.equals(x)) {
            out.println("Good");
        } else {
            out.println("************* MD5 FAILED **************");
        }
    }

    private static final String toString(byte[] buffer) {
        StringBuffer returnBuffer = new StringBuffer();
        int len = buffer.length;
        for (int pos = 0; pos < len; ++pos) {
            returnBuffer.append(MD5.hexToAscii(buffer[pos] >>> 4 & 0xF)).append(MD5.hexToAscii(buffer[pos] & 0xF));
        }
        return returnBuffer.toString();
    }

    private static char hexToAscii(int h) {
        if (h >= 10 && h <= 15) {
            return (char)(65 + (h - 10));
        }
        if (h >= 0 && h <= 9) {
            return (char)(48 + h);
        }
        throw new Error(prAccessor.getString("STR024"));
    }

    @Override
    public String toString() {
        String _contextBuf = this.contextBuf == null ? null : Hex.toString((byte[])this.contextBuf);
        String _digest = this.digest == null ? null : Hex.toString((int[])this.digest);
        String _tmp = this.tmp == null ? null : Hex.toString((byte[])this.tmp);
        return super.toString() + "\nprogress.message.crypto.MD5\ncontextBuf: " + _contextBuf + "\ndigest: " + _digest + "\ntmp: " + _tmp + "\n";
    }
}

