/*
 * Decompiled with CFR 0.152.
 */
package progress.message.crypto;

import java.util.Random;
import progress.message.crypto.MD5;
import progress.message.crypto.MessageDigest;
import progress.message.crypto.SHA;

public class KeyGen {
    private int m_sessionKeySize = 0;
    private int m_digestKeySize = 0;
    private int m_ivSize = 0;
    private byte[] m_keyBlock = null;
    private byte[] m_masterSecret = null;
    private byte[] m_seed = null;
    private SHA m_sha = new SHA();
    private MD5 m_md5 = new MD5();
    private static byte[] s_activeNonce = "active nonce".getBytes();
    private static byte[] s_passiveNonce = "passive nonce".getBytes();
    private static int HASH_SHA = 0;
    private static int HASH_MD5 = 1;

    public static byte[] getIV(byte[] keyMaterial) {
        KeyGen kg = new KeyGen();
        kg.init(null, s_activeNonce, s_passiveNonce, keyMaterial);
        return kg.getIV();
    }

    public void init(String transformation, byte[] activeNonce, byte[] passiveNonce, byte[] preMasterSecret) {
        this.m_keyBlock = null;
        if (transformation == null) {
            this.m_sessionKeySize = preMasterSecret.length;
            this.m_digestKeySize = preMasterSecret.length;
            this.m_ivSize = preMasterSecret.length;
        }
        this.m_seed = new byte[activeNonce.length + passiveNonce.length];
        System.arraycopy(activeNonce, 0, this.m_seed, 0, activeNonce.length);
        System.arraycopy(passiveNonce, 0, this.m_seed, activeNonce.length, passiveNonce.length);
        this.m_masterSecret = new byte[preMasterSecret.length];
        System.arraycopy(preMasterSecret, 0, this.m_masterSecret, 0, preMasterSecret.length);
    }

    public byte[] getDigestKey() {
        if (this.m_keyBlock == null) {
            this.generateKeyBlock();
        }
        byte[] digestKey = new byte[this.m_digestKeySize];
        System.arraycopy(this.m_keyBlock, 0, digestKey, 0, this.m_digestKeySize);
        return digestKey;
    }

    public byte[] getSessionKey() {
        if (this.m_keyBlock == null) {
            this.generateKeyBlock();
        }
        byte[] sessionKey = new byte[this.m_sessionKeySize];
        System.arraycopy(this.m_keyBlock, this.m_digestKeySize, sessionKey, 0, this.m_sessionKeySize);
        return sessionKey;
    }

    public byte[] getIV() {
        if (this.m_keyBlock == null) {
            this.generateKeyBlock();
        }
        byte[] IV = new byte[this.m_ivSize];
        System.arraycopy(this.m_keyBlock, this.m_digestKeySize + this.m_sessionKeySize, IV, 0, this.m_ivSize);
        return IV;
    }

    private void generateKeyBlock() {
        this.m_keyBlock = this.PRF(this.m_masterSecret, "key expansion", this.m_seed, this.m_sessionKeySize + this.m_digestKeySize + this.m_ivSize);
    }

    private byte[] HMAC(byte[] secret, byte[] seed, int hash) {
        MessageDigest md = hash == HASH_SHA ? this.m_sha : this.m_md5;
        md.add(secret, 0, secret.length);
        md.add(seed, 0, seed.length);
        byte[] tmp = md.digest();
        md.add(secret, 0, secret.length);
        md.add(tmp, 0, tmp.length);
        return md.digest();
    }

    private byte[] HMAC_SHA(byte[] secret, byte[] seed) {
        return this.HMAC(secret, seed, HASH_SHA);
    }

    private byte[] HMAC_MD5(byte[] secret, byte[] seed) {
        return this.HMAC(secret, seed, HASH_MD5);
    }

    private byte[] p_hash(byte[] secret, byte[] seed, int size, int hash) {
        byte[] next;
        int hashLen = hash == HASH_SHA ? 20 : 16;
        byte[] bytesNeeded = new byte[size];
        byte[] newSeed = new byte[hashLen + seed.length];
        byte[] A = seed;
        for (int count = 0; count < size; count += next.length) {
            A = hash == HASH_SHA ? this.HMAC_SHA(secret, A) : this.HMAC_MD5(secret, A);
            System.arraycopy(A, 0, newSeed, 0, A.length);
            System.arraycopy(seed, 0, newSeed, A.length, seed.length);
            next = hash == HASH_SHA ? this.HMAC_SHA(secret, newSeed) : this.HMAC_MD5(secret, newSeed);
            System.arraycopy(next, 0, bytesNeeded, count, Math.min(next.length, size - count));
        }
        return bytesNeeded;
    }

    private byte[] p_SHA(byte[] secret, byte[] seed, int size) {
        return this.p_hash(secret, seed, size, HASH_SHA);
    }

    private byte[] p_MD5(byte[] secret, byte[] seed, int size) {
        return this.p_hash(secret, seed, size, HASH_MD5);
    }

    public byte[] PRF(byte[] secret, String label, byte[] seed, int size) {
        int odd = secret.length % 2;
        int len = secret.length / 2 + odd;
        byte[] s1 = new byte[len];
        byte[] s2 = new byte[len];
        System.arraycopy(secret, 0, s1, 0, s1.length);
        if (odd == 0) {
            System.arraycopy(secret, len, s2, 0, s2.length);
        } else {
            System.arraycopy(secret, len - 1, s2, 0, s2.length);
        }
        byte[] labelBytes = label.getBytes();
        byte[] newSeed = new byte[labelBytes.length + seed.length];
        System.arraycopy(labelBytes, 0, newSeed, 0, labelBytes.length);
        System.arraycopy(seed, 0, newSeed, labelBytes.length, seed.length);
        byte[] b1 = this.p_MD5(s1, newSeed, size);
        byte[] b2 = this.p_SHA(s2, newSeed, size);
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (byte)(b1[i] ^ b2[i]);
        }
        return result;
    }

    public static void main(String[] argv) {
        Random random = new Random();
        byte[] key = new byte[8];
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            random.nextBytes(key);
            byte[] iv = KeyGen.getIV(key);
            try {
                boolean same = true;
                for (int j = 0; j < key.length; ++j) {
                    if (key[j] == iv[j]) continue;
                    same = false;
                    break;
                }
                if (!same) continue;
                System.out.println("FAILED on " + i + "th iteration");
                return;
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
                System.out.println("FAILED on " + i + "th iteration");
                return;
            }
        }
        System.out.println("SUCCEEDED, elapse time for 1000,000 iterations = " + (System.currentTimeMillis() - startTime));
    }
}

