/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.xa;

import javax.jms.JMSException;
import javax.jms.Session;
import progress.message.jimpl.Connection;
import progress.message.jimpl.EventHandler;
import progress.message.jimpl.TopicConnection;
import progress.message.jimpl.TopicSession;
import progress.message.jimpl.xa.XASession;

public class XATopicSession
extends XASession
implements progress.message.jclient.xa.XATopicSession {
    private TopicConnection m_connection = null;
    private boolean m_transacted;
    private int m_acknowledgeMode;

    XATopicSession(TopicConnection connection, boolean transacted, int acknowledgeMode, String sessionName) throws JMSException {
        super((Connection)connection, transacted, acknowledgeMode, sessionName);
        this.m_connection = connection;
        this.m_transacted = transacted;
        this.m_acknowledgeMode = acknowledgeMode;
    }

    @Override
    public Session getSession() throws JMSException {
        return this.getTopicSession();
    }

    public javax.jms.TopicSession getTopicSession() throws JMSException {
        if (this.isClosing()) {
            return (javax.jms.TopicSession)this.m_session;
        }
        if (this.m_session == null || this.m_session.isClosing()) {
            String sessname = this.getSessionName();
            sessname = (sessname == null ? "" : sessname) + "(XA JMS Session)";
            this.m_session = new TopicSession((Connection)this.m_connection, this.m_transacted, this.m_acknowledgeMode, sessname);
            this.m_session.setFromXASession(true);
            this.m_session.setEnforceLocallyTransactedOnXAEnlistment(this.getEnforceLocallyTransactedOnXAEnlistment());
            this.m_session.setUseInternalThreadForCCDelivery(this.getUseInternalThreadForCCDelivery());
            this.m_session.setAfterDeliveryListener(this.getAfterDeliveryListener());
            this.m_session.setBeforeDeliveryListener(this.getBeforeDeliveryListener());
            this.m_session.setServerSessionReleaseListener(this.getServerSessionReleaseListener());
            this.m_session.addEventHandler((EventHandler)this);
        }
        return (javax.jms.TopicSession)this.m_session;
    }

    @Override
    public void close() throws JMSException {
        super.close();
        this.closeTsession();
    }

    @Override
    public void setDeferredAck(boolean value) throws JMSException {
        ((TopicSession)this.getTopicSession()).setDeferredAckInXATxn(value);
    }

    @Override
    public boolean isDeferredAck() throws JMSException {
        return ((TopicSession)this.getTopicSession()).isDeferredAckInXATxn();
    }

    private synchronized void closeTsession() throws JMSException {
        if (this.m_session == null) {
            return;
        }
        this.m_session.removeEventHandler((EventHandler)this);
        this.m_session.closeInternal();
    }
}

