/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.xa;

import javax.jms.JMSException;
import javax.jms.Session;
import progress.message.jimpl.Connection;
import progress.message.jimpl.EventHandler;
import progress.message.jimpl.QueueConnection;
import progress.message.jimpl.QueueSession;
import progress.message.jimpl.xa.XASession;

public class XAQueueSession
extends XASession
implements progress.message.jclient.xa.XAQueueSession {
    private QueueConnection m_connection = null;
    private boolean m_transacted;
    private int m_acknowledgeMode;

    XAQueueSession(QueueConnection connection, boolean transacted, int acknowledgeMode, String sessionName) throws JMSException {
        super((Connection)connection, transacted, acknowledgeMode, sessionName);
        this.m_connection = connection;
        this.m_transacted = transacted;
        this.m_acknowledgeMode = acknowledgeMode;
    }

    @Override
    public Session getSession() throws JMSException {
        return this.getQueueSession();
    }

    public javax.jms.QueueSession getQueueSession() throws JMSException {
        if (this.isClosing()) {
            return (javax.jms.QueueSession)this.m_session;
        }
        if (this.m_session == null || this.m_session.isClosing()) {
            String sessname = this.getSessionName();
            sessname = (sessname == null ? "" : sessname) + "(XA JMS Session)";
            this.m_session = new QueueSession((Connection)this.m_connection, this.m_transacted, this.m_acknowledgeMode, sessname);
            this.m_session.setFromXASession(true);
            this.m_session.setEnforceLocallyTransactedOnXAEnlistment(this.getEnforceLocallyTransactedOnXAEnlistment());
            this.m_session.setUseInternalThreadForCCDelivery(this.getUseInternalThreadForCCDelivery());
            this.m_session.setAfterDeliveryListener(this.getAfterDeliveryListener());
            this.m_session.setBeforeDeliveryListener(this.getBeforeDeliveryListener());
            this.m_session.setServerSessionReleaseListener(this.getServerSessionReleaseListener());
            this.m_session.addEventHandler((EventHandler)this);
        }
        return (javax.jms.QueueSession)this.m_session;
    }

    @Override
    public void close() throws JMSException {
        super.close();
        this.closeQsession();
    }

    @Override
    public void setDeferredAck(boolean value) throws JMSException {
        ((QueueSession)this.getQueueSession()).setDeferredAckInXATxn(value);
    }

    @Override
    public boolean isDeferredAck() throws JMSException {
        return ((QueueSession)this.getQueueSession()).isDeferredAckInXATxn();
    }

    private synchronized void closeQsession() throws JMSException {
        if (this.m_session == null) {
            return;
        }
        this.m_session.removeEventHandler((EventHandler)this);
        this.m_session.closeInternal();
    }
}

