/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.xmessage;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import progress.message.client.prAccessor;
import progress.message.jclient.XMLMessage;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.Message;
import progress.message.jimpl.xmessage.Header;
import progress.message.jimpl.xmessage.MessagePart;
import progress.message.jimpl.xmessage.Part;
import progress.message.zclient.Envelope;

public class MultipartMessage
extends Message
implements progress.message.jclient.MultipartMessage {
    private int m_version = 1;
    private Vector m_parts;
    private int m_partCount;
    private ObjectInput m_in;
    private ObjectOutput m_out;
    private boolean m_dirty = false;
    private boolean m_needUnpack = false;

    public MultipartMessage() throws JMSException {
        this.setExtendedType("x-sonicmq-multipart");
        this.m_in = null;
        this.m_out = this.getEnvelope().getMessage();
        this.m_dirty = true;
    }

    public MultipartMessage(Envelope envelope) throws JMSException {
        super(envelope);
        if (this.m_zenvelope.getMessage().cap() != 0) {
            try {
                this.m_zenvelope.getMessage().gotoByte(0);
            }
            catch (IOException ioe) {
                throw JMSExceptionUtil.createJMSException((Exception)ioe);
            }
        }
        this.m_out = null;
        this.m_in = this.getEnvelope().getMessage();
        try {
            this.m_version = this.m_in.readInt();
            this.m_partCount = this.m_in.readInt();
            this.m_needUnpack = true;
            this.m_dirty = false;
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException((Exception)e);
        }
    }

    public int getPartCount() throws JMSException {
        return this.m_partCount;
    }

    public progress.message.jclient.Part getPart(int index) throws JMSException {
        if (this.m_needUnpack) {
            this.unpackPartsContentsIfNecessary();
        }
        Object part = null;
        try {
            part = this.m_parts.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw JMSExceptionUtil.createJMSException((String)(prAccessor.getString((String)"INVALID_INDEX") + e.getMessage()), (Exception)e);
        }
        return part;
    }

    public progress.message.jclient.Part getPart(String cid) throws JMSException {
        if (this.m_needUnpack) {
            this.unpackPartsContentsIfNecessary();
        }
        for (int i = 0; i < this.m_partCount; ++i) {
            Part part = (Part)this.m_parts.elementAt(i);
            progress.message.jclient.Header header = part.getHeader();
            if (header.getContentId() == null || !header.getContentId().equals(cid)) continue;
            return part;
        }
        throw JMSExceptionUtil.createJMSException((String)prAccessor.getString((String)"PART_NOT_EXIST"), null);
    }

    public boolean doesPartExist(String cid) throws JMSException {
        return this.getPart(cid) != null;
    }

    public javax.jms.Message getMessageFromPart(int index) throws JMSException {
        Part part = (Part)this.getPart(index);
        if (part.isMessagePart()) {
            return ((MessagePart)part).getMessage();
        }
        throw JMSExceptionUtil.createJMSException((String)prAccessor.getString((String)"NOT_MESSAGE"), null);
    }

    public javax.jms.Message getMessageFromPart(String cid) throws JMSException {
        Part part = (Part)this.getPart(cid);
        if (part.isMessagePart()) {
            return ((MessagePart)part).getMessage();
        }
        throw JMSExceptionUtil.createJMSException((String)prAccessor.getString((String)"NOT_MESSAGE"), null);
    }

    public boolean isMessagePart(int index) throws JMSException {
        Part part = (Part)this.getPart(index);
        if (part instanceof MessagePart) {
            return true;
        }
        return part.isMessagePart();
    }

    public boolean isMessagePart(String cid) throws JMSException {
        Part part = (Part)this.getPart(cid);
        if (part == null) {
            throw JMSExceptionUtil.createJMSException((String)prAccessor.getString((String)"PART_NOT_EXIST"), null);
        }
        if (part instanceof MessagePart) {
            return true;
        }
        return part.isMessagePart();
    }

    public void removePart(int index) throws JMSException {
        if (this.isReadOnly()) {
            throw new MessageNotWriteableException("");
        }
        if (this.m_needUnpack) {
            this.unpackPartsContentsIfNecessary();
        }
        try {
            this.m_parts.removeElementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw JMSExceptionUtil.createJMSException((String)(prAccessor.getString((String)"INVALID_INDEX") + e.getMessage()), (Exception)e);
        }
        --this.m_partCount;
        this.m_dirty = true;
    }

    public void removePart(String cid) throws JMSException {
        if (this.isReadOnly()) {
            throw new MessageNotWriteableException("");
        }
        if (this.m_needUnpack) {
            this.unpackPartsContentsIfNecessary();
        }
        for (int i = 0; i < this.m_partCount; ++i) {
            Part part = (Part)this.m_parts.elementAt(i);
            progress.message.jclient.Header header = part.getHeader();
            if (header.getContentId() == null || !header.getContentId().equals(cid)) continue;
            try {
                this.m_parts.removeElementAt(i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw JMSExceptionUtil.createJMSException((String)(prAccessor.getString((String)"INVALID_INDEX") + e.getMessage()), (Exception)e);
            }
            --this.m_partCount;
            this.m_dirty = true;
            return;
        }
        throw JMSExceptionUtil.createJMSException((String)prAccessor.getString((String)"PART_NOT_EXIST"), null);
    }

    public void addPart(progress.message.jclient.Part part) throws JMSException {
        this.internalAddPart(part, -1);
    }

    public void addPartAt(progress.message.jclient.Part part, int index) throws JMSException {
        if (index < 0) {
            throw new JMSException(prAccessor.getString((String)"INVALID_INDEX"));
        }
        this.internalAddPart(part, index);
    }

    private void internalAddPart(progress.message.jclient.Part part, int index) throws JMSException {
        String cid;
        if (this.isReadOnly()) {
            throw new MessageNotWriteableException("");
        }
        if (this.m_needUnpack) {
            this.unpackPartsContentsIfNecessary();
        }
        if ((cid = part.getHeader().getContentId()) != null) {
            Part aPart = null;
            try {
                aPart = (Part)this.getPart(cid);
            }
            catch (JMSException e) {
                // empty catch block
            }
            if (aPart != null) {
                throw JMSExceptionUtil.createJMSException((String)prAccessor.getString((String)"PART_EXISTS"), null);
            }
        }
        if (this.m_parts == null) {
            this.m_parts = new Vector();
        }
        ((Part)part).setParentMM(this);
        if (index < 0) {
            this.m_parts.addElement(part);
        } else {
            try {
                this.m_parts.insertElementAt(part, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw JMSExceptionUtil.createJMSException((String)(prAccessor.getString((String)"INVALID_INDEX") + e.getMessage()), (Exception)e);
            }
        }
        ++this.m_partCount;
        this.m_dirty = true;
    }

    public progress.message.jclient.Part createPart() {
        return new Part();
    }

    public progress.message.jclient.Part createPart(DataHandler handler) throws JMSException {
        return new Part(handler);
    }

    public progress.message.jclient.Part createPart(Object object, String type) throws JMSException {
        return new Part(object, type);
    }

    public progress.message.jclient.Part createMessagePart(javax.jms.Message msg) throws JMSException {
        if (msg instanceof BytesMessage) {
            return new MessagePart(msg, "application/x-sonicmq-bytesmessage");
        }
        if (msg instanceof MapMessage) {
            return new MessagePart(msg, "application/x-sonicmq-mapmessage");
        }
        if (msg instanceof progress.message.jclient.MultipartMessage) {
            return new MessagePart(msg, "application/x-sonicmq-multipartmessage");
        }
        if (msg instanceof ObjectMessage) {
            return new MessagePart(msg, "application/x-sonicmq-objectmessage");
        }
        if (msg instanceof StreamMessage) {
            return new MessagePart(msg, "application/x-sonicmq-streammessage");
        }
        if (msg instanceof TextMessage) {
            return new MessagePart(msg, "application/x-sonicmq-textmessage");
        }
        if (msg instanceof XMLMessage) {
            return new MessagePart(msg, "application/x-sonicmq-xmlmessage");
        }
        if (msg instanceof javax.jms.Message) {
            return new MessagePart(msg, "application/x-sonicmq-message");
        }
        throw new MessageFormatException(prAccessor.getString((String)"MSG_INVALID_BODY_TYPE"));
    }

    public boolean isReadOnly() throws JMSException {
        return super.isBodyReadOnly();
    }

    public void clearReadOnly() throws JMSException {
        super.setBodyReadOnly(false);
        if (this.m_parts == null) {
            return;
        }
        for (int i = 0; i < this.m_parts.size(); ++i) {
            Part apart = (Part)this.getPart(i);
            apart.setReadOnly(false);
        }
    }

    public String getProfileName() throws JMSException {
        return "x-sonicmq-multipart";
    }

    public void marshal() throws JMSException {
        if (!this.m_dirty) {
            return;
        }
        this.m_out = this.getEnvelope().getMessage();
        ((progress.message.zclient.Message)this.m_out).setBody(null);
        try {
            Part apart;
            this.m_out.writeInt(this.m_version);
            this.m_out.writeInt(this.m_partCount);
            if (this.m_partCount == 0) {
                return;
            }
            Enumeration parts = this.m_parts.elements();
            while (parts.hasMoreElements()) {
                apart = (Part)parts.nextElement();
                apart.marshalHeader(this.m_out);
            }
            parts = this.m_parts.elements();
            while (parts.hasMoreElements()) {
                apart = (Part)parts.nextElement();
                if (apart.isMessagePart()) {
                    MessagePart msgPart = (MessagePart)apart;
                    msgPart.marshalMessage(this.m_out);
                }
                apart.marshalPart(this.m_out);
            }
            this.m_dirty = false;
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException((Exception)e);
        }
    }

    public int getBodySize() throws JMSException {
        if (this.m_needUnpack) {
            this.unpackPartsContentsIfNecessary();
            this.m_dirty = true;
        }
        return super.getBodySize();
    }

    private void unpackPartsContentsIfNecessary() throws JMSException {
        int i;
        if (this.m_in == null) {
            throw JMSExceptionUtil.createJMSException((String)prAccessor.getString((String)"NO_INPUTSTREAM"), null);
        }
        this.m_parts = new Vector();
        for (i = 0; i < this.m_partCount; ++i) {
            Header header = new Header();
            Part part = null;
            header.unpack(this.m_in);
            part = header.isSonicmqMessageType() ? new MessagePart() : new Part();
            header.setParentPart(part);
            part.setHeader(header);
            this.m_parts.addElement(part);
        }
        for (i = 0; i < this.m_partCount; ++i) {
            Part part = (Part)this.m_parts.elementAt(i);
            part.setParentMM(this);
            part.unpackContent(this.m_in);
            part.setReadOnly(this.isReadOnly());
            if (!part.isMessagePart()) continue;
            ((MessagePart)part).unpackMessage(this.m_in);
        }
        this.m_needUnpack = false;
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.m_parts = null;
        this.m_partCount = 0;
        this.m_dirty = true;
        this.m_needUnpack = false;
    }

    public Object clone() {
        MultipartMessage msg = (MultipartMessage)((Object)super.clone());
        this.cloneInternal(msg);
        return msg;
    }

    public Object protectedClone() {
        MultipartMessage msg = (MultipartMessage)((Object)super.protectedClone());
        this.cloneInternal(msg);
        return msg;
    }

    private void cloneInternal(MultipartMessage msg) {
        if (this.m_parts != null) {
            msg.m_parts = new Vector();
            for (int i = 0; i < this.m_partCount; ++i) {
                Part part = (Part)this.m_parts.elementAt(i);
                Part copy = null;
                copy = part.isMessagePart() ? (Part)((MessagePart)part).clone() : (Part)part.clone();
                msg.m_parts.addElement(copy);
                copy.setParentMM(msg);
            }
        }
        if (msg.m_in != null) {
            msg.m_in = msg.getEnvelope().getMessage();
        }
        if (msg.m_out != null) {
            msg.m_in = msg.getEnvelope().getMessage();
        }
    }

    void setDirty(boolean dirty) {
        this.m_dirty = dirty;
    }
}

