/*
 * Decompiled with CFR 0.152.
 */
package progress.message.jimpl.xmessage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.JMSException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.jimpl.xmessage.XMLUtils;
import progress.message.jimpl.xmessage.XMLdomMessage;

public class XMLdomMessageImpl
implements XMLdomMessage {
    private Document m_doc = null;
    private String m_DocumentBuilderFactory;
    private static final String DEFAULT_DOM_PARSER = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private boolean m_namespaceAware = false;

    @Override
    public Document getDocument() throws JMSException {
        if (this.m_doc != null) {
            return this.m_doc;
        }
        this.configDocumentBuilderFactoryToDefaultDomParser();
        try {
            DocumentBuilderFactory plugfactory = DocumentBuilderFactory.newInstance();
            plugfactory.setNamespaceAware(this.m_namespaceAware);
            this.m_doc = plugfactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw JMSExceptionUtil.createJMSException((String)pce.getMessage(), (Exception)pce);
        }
        catch (FactoryConfigurationError fce) {
            throw JMSExceptionUtil.createJMSException((String)fce.getMessage(), null);
        }
        catch (NoClassDefFoundError nc) {
            throw JMSExceptionUtil.createJMSException((String)nc.getMessage(), null);
        }
        return this.m_doc;
    }

    @Override
    public void setDocument(Document aDoc) {
        this.m_doc = aDoc;
    }

    @Override
    public void marshal(OutputStream out) throws JMSException {
        try {
            String m_domString = XMLUtils.nodeToString(this.m_doc);
            out.write(m_domString.getBytes("UTF-8"));
            out.flush();
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException((Exception)e);
        }
    }

    @Override
    public void parse(InputStream in) throws JMSException {
        this.configDocumentBuilderFactoryToDefaultDomParser();
        try {
            DocumentBuilderFactory plugfactory = DocumentBuilderFactory.newInstance();
            plugfactory.setNamespaceAware(this.m_namespaceAware);
            this.m_doc = plugfactory.newDocumentBuilder().parse(new InputSource(in));
        }
        catch (SAXException saxe) {
            throw JMSExceptionUtil.createJMSException((String)saxe.getMessage(), (Exception)saxe);
        }
        catch (ParserConfigurationException pce) {
            throw JMSExceptionUtil.createJMSException((String)pce.getMessage(), (Exception)pce);
        }
        catch (FactoryConfigurationError fce) {
            throw JMSExceptionUtil.createJMSException((String)fce.getMessage(), null);
        }
        catch (NoClassDefFoundError nc) {
            throw JMSExceptionUtil.createJMSException((String)nc.getMessage(), null);
        }
        catch (IOException e) {
            throw JMSExceptionUtil.createJMSException((Exception)e);
        }
    }

    private void configDocumentBuilderFactoryToDefaultDomParser() {
        if (this.getDocumentBuilderFactory() == null) {
            this.setDocumentBuilderFactory(DEFAULT_DOM_PARSER);
        }
    }

    @Override
    public String getDocumentBuilderFactory() {
        if (this.m_DocumentBuilderFactory != null) {
            return this.m_DocumentBuilderFactory;
        }
        this.m_DocumentBuilderFactory = System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
        return this.m_DocumentBuilderFactory;
    }

    @Override
    public void setDocumentBuilderFactory(String classname) {
        this.m_DocumentBuilderFactory = classname;
    }

    @Override
    public void setNamespaceAware(boolean aware) {
        this.m_namespaceAware = aware;
    }

    @Override
    public boolean isNamespaceAware() {
        return this.m_namespaceAware;
    }
}

