/*
 * Decompiled with CFR 0.152.
 */
package com.progress.sonic.utilities.esb.admin;

import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.IArtifactTraversalContext;
import com.sonicsw.deploy.IArtifactTraverser;
import com.sonicsw.deploy.action.CopyAction;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;
import com.sonicsw.deploy.traversal.AbstractTraverser;
import com.sonicsw.deploy.traversal.TraverserContext;
import com.sonicsw.deploy.traversal.TraverserFactory;
import java.util.ArrayList;
import java.util.List;

public class ESBArtifactCopyJob {
    private IArtifactStorage srcStore = null;
    private IArtifactStorage destStore = null;
    private ExportPropertiesArtifact exportProperties = null;
    private boolean failOnError = true;
    private boolean cleanBeforeCopy = false;

    public ESBArtifactCopyJob(IArtifactStorage _src, IArtifactStorage _dest) {
        this(_src, _dest, new ExportPropertiesArtifact(), true);
    }

    public ESBArtifactCopyJob(IArtifactStorage _src, IArtifactStorage _dest, ExportPropertiesArtifact _expProps) {
        this(_src, _dest, _expProps, true);
    }

    public ESBArtifactCopyJob(IArtifactStorage _src, IArtifactStorage _dest, ExportPropertiesArtifact _expProps, boolean _fail) {
        this.srcStore = _src;
        this.destStore = _dest;
        this.exportProperties = _expProps;
        this.failOnError = _fail;
    }

    public final void setCleanBeforeCopy(boolean _cleanBeforeCopy) {
        this.cleanBeforeCopy = _cleanBeforeCopy;
    }

    public final void copy() throws Exception {
        IArtifact[] toCopy;
        if (this.exportProperties == null) {
            this.exportProperties = new ExportPropertiesArtifact();
            System.out.println("[WARN] Will use default/empty Exportproperties!");
        }
        List<IArtifact> ignores = this.filterIgnoreList(this.exportProperties.getIgnoreList());
        this.exportProperties.clearIgnoreList();
        this.exportProperties.addIgnore(ignores.toArray(new IArtifact[0]));
        TraverserContext ctxt = new TraverserContext(this.srcStore, this.exportProperties.getIgnoreList());
        ctxt.setTraverseCompressed(false);
        for (int i = 0; i < this.exportProperties.getRootList().length; ++i) {
            IArtifactTraverser traverser = TraverserFactory.createTraverser((IArtifact)this.exportProperties.getRootList()[i]);
            ((AbstractTraverser)traverser)._traverse((IArtifactTraversalContext)ctxt);
        }
        IArtifact[] errored = ctxt.getErrored();
        if (errored.length > 0) {
            ArrayList<IArtifact> errFiltered = new ArrayList<IArtifact>();
            for (IArtifact error : errored) {
                if (error.getDisplayType().equalsIgnoreCase("SonicFS") && error.getPath().contains(".esbdx(")) {
                    String path = error.getPath().substring(0, error.getPath().indexOf(".esbdx(") + 6);
                    SonicFSArtifact a = new SonicFSArtifact(path);
                    System.out.println("[WARN] esbdx file caused export error: " + error.getPath());
                    System.out.println("[WARN] Adding corrected esbdx path to export roots: " + path);
                    this.exportProperties.addRoot((IArtifact)a);
                    continue;
                }
                errFiltered.add(error);
            }
            errored = errFiltered.toArray(new IArtifact[0]);
        }
        if (errored.length > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("The following Artifacts could not be traversed : [\n");
            for (IArtifact error : errored) {
                buf.append("  " + error.getDisplayType() + ":" + error.getPath() + "\n");
            }
            buf.append("]\n");
            if (this.failOnError) {
                throw new Exception(buf.toString());
            }
            System.out.println("[WARN] " + buf.toString());
        }
        IArtifact[] result = ctxt.completeTraversal();
        if (this.cleanBeforeCopy) {
            this.destStore.deleteAll();
        }
        for (IArtifact a : this.exportProperties.getRootList()) {
            toCopy = new IArtifact[]{a};
            try {
                if (a.isDirectory()) continue;
                CopyAction.copyTo((IArtifactStorage)this.srcStore, (IArtifactStorage)this.destStore, (IArtifact[])toCopy);
            }
            catch (Exception e) {
                if (!this.failOnError) continue;
                throw new Exception(e);
            }
        }
        for (IArtifact a : result) {
            toCopy = new IArtifact[]{a};
            try {
                if (a.isDirectory()) continue;
                CopyAction.copyTo((IArtifactStorage)this.srcStore, (IArtifactStorage)this.destStore, (IArtifact[])toCopy);
            }
            catch (Exception e) {
                System.out.println("[WARN] " + e.getMessage());
            }
        }
    }

    private List<IArtifact> filterIgnoreList(IArtifact[] _ignores) {
        ArrayList<IArtifact> result = new ArrayList<IArtifact>();
        ArrayList<String> invalidIgnores = new ArrayList<String>();
        invalidIgnores.add("/Connections/http_defaultConnection");
        invalidIgnores.add("/Connections/jms_defaultConnection");
        invalidIgnores.add("/System/");
        for (IArtifact a : _ignores) {
            if (invalidIgnores.contains(a.getPath())) continue;
            result.add(a);
        }
        return result;
    }
}

