/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.sdm;

import com.aurea.maven.plugins.sonic.sdm.QueueMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class QueueMappings {
    private final List<QueueMapping> mappings = new ArrayList<QueueMapping>();

    public QueueMappings() {
    }

    public QueueMappings(Xpp3Dom dom, String defaultQueuesId) {
        this();
        Xpp3Dom[] queueMappingElements;
        for (Xpp3Dom queueMappingElement : queueMappingElements = dom.getChildren("queueMapping")) {
            this.addMapping(new QueueMapping(queueMappingElement));
        }
        Xpp3Dom defaultMappingElement = dom.getChild("defaultMapping");
        if (defaultMappingElement != null) {
            this.addMapping(new QueueMapping(defaultMappingElement));
        } else {
            this.addMapping(new QueueMapping(defaultQueuesId, ".*"));
        }
    }

    public void addMapping(QueueMapping mapping) {
        this.mappings.add(mapping);
    }

    public void removeMapping(QueueMapping mapping) {
        this.mappings.remove(mapping);
    }

    public List<QueueMapping> getMappings() {
        return Collections.unmodifiableList(this.mappings);
    }

    public QueueMapping getMappingForQueue(String queueName) throws MojoExecutionException {
        for (QueueMapping mapping : this.mappings) {
            if (!mapping.matches(queueName)) continue;
            return mapping;
        }
        throw new MojoExecutionException("Unable to find a matching queue mapping for queue " + queueName);
    }

    public String toString() {
        return "Queue mappings: " + this.mappings;
    }
}

