/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class JavaInvoker {
    private String mainClass = null;
    private String workDir = null;
    private Properties jvmProps = null;
    private List<String> classPath = null;
    private List<String> bootClassPath = null;
    private List<String> arguments = null;

    public JavaInvoker(String _mainClass) {
        this.setMainClass(_mainClass);
    }

    public final void setMainClass(String _mainClass) {
        this.mainClass = _mainClass;
    }

    public final void addToClassPath(String _path) {
        if (this.classPath == null) {
            this.classPath = new ArrayList<String>();
        }
        this.classPath.add(_path);
    }

    public final void addToBootClassPath(String _path) {
        if (this.bootClassPath == null) {
            this.bootClassPath = new ArrayList<String>();
        }
        this.bootClassPath.add(_path);
    }

    public final void setProperty(String _key, String _value) {
        if (this.jvmProps == null) {
            this.jvmProps = new Properties();
        }
        this.jvmProps.setProperty(_key, _value);
    }

    public final void addArgument(String _arg) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.add(_arg);
    }

    public final void setWorkingDir(String _dir) {
        this.workDir = _dir;
    }

    protected final String getWorkdir() {
        if (this.workDir != null) {
            return this.workDir;
        }
        return System.getProperty("user.dir");
    }

    public final void invoke() throws IOException {
        String cp;
        ArrayList<String> cmd = new ArrayList<String>();
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        if (isWindows) {
            java = java + ".exe";
        }
        cmd.add(java);
        if (this.jvmProps != null) {
            for (String string : this.jvmProps.keySet()) {
                String value = this.jvmProps.getProperty(string);
                cmd.add("-D" + string + "=" + value);
            }
        }
        if ((cp = this.assembleClasspath(this.bootClassPath)) != null) {
            cmd.add("-Xbootclasspath:" + cp);
        }
        if ((cp = this.assembleClasspath(this.classPath)) != null) {
            cmd.add("-classpath");
            cmd.add(cp);
        }
        cmd.add(this.mainClass);
        if (this.arguments != null) {
            cmd.addAll(this.arguments);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.directory(new File(this.getWorkdir()));
        processBuilder.redirectErrorStream(true);
        processBuilder.start();
    }

    private String assembleClasspath(List<String> _cpElements) {
        StringBuffer result = new StringBuffer();
        if (_cpElements != null) {
            for (String cpElem : _cpElements) {
                if (result.length() > 0) {
                    result.append(File.pathSeparator);
                }
                result.append(cpElem);
            }
        }
        if (result.length() > 0) {
            return result.toString();
        }
        return null;
    }
}

