/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.sdm.container.impl;

import com.aurea.maven.plugins.sonic.sdm.container.IContainerMap;
import com.aurea.maven.plugins.sonic.sdm.container.IContainerSetting;
import com.aurea.maven.plugins.sonic.sdm.container.IIncludePattern;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DefaultContainerMap
implements IContainerMap {
    private boolean useESBDefaultIncludes = true;
    private boolean useMFDefaultIncludes = true;
    private Set<IContainerSetting> esbContainerSettings = null;
    private Set<IContainerSetting> mfContainerSettings = null;
    private IContainerSetting defaultESBContainerSetting = null;
    private IContainerSetting defaultMFContainerSetting = null;

    @Override
    public boolean isUseESBDefaultIncludes() {
        return this.useESBDefaultIncludes;
    }

    @Override
    public boolean isUseMFDefaultIncludes() {
        return this.useMFDefaultIncludes;
    }

    @Override
    public final Set<IContainerSetting> getESBContainerSettings() {
        return this.esbContainerSettings;
    }

    @Override
    public final Set<IContainerSetting> getMFContainerSettings() {
        return this.mfContainerSettings;
    }

    @Override
    public final IContainerSetting getDefaultESBContainerSetting() {
        if (this.defaultESBContainerSetting == null) {
            this.defaultESBContainerSetting = this.getDefaultContainer(this.getESBContainerSettings());
        }
        return this.defaultESBContainerSetting;
    }

    @Override
    public final IContainerSetting getDefaultMFContainerSetting() {
        if (this.defaultMFContainerSetting == null) {
            this.defaultMFContainerSetting = this.getDefaultContainer(this.getMFContainerSettings());
        }
        return this.defaultMFContainerSetting;
    }

    @Override
    public final Map<String, Properties> matchESBContainerSettings(String _key) {
        return this.matchContainerSettings(_key, this.getESBContainerSettings());
    }

    @Override
    public final Map<String, Properties> matchMFContainerSettings(String _key) {
        return this.matchContainerSettings(_key, this.getMFContainerSettings());
    }

    private IContainerSetting getDefaultContainer(Set<IContainerSetting> _settings) {
        if (_settings != null) {
            for (IContainerSetting setting : _settings) {
                if (setting.getIncludes() == null || setting.getIncludes().isEmpty()) {
                    return setting;
                }
                if (setting.getIncludes().size() != 1 || setting.getIncludes().get(0).getPattern() != null) continue;
                return setting;
            }
        }
        return null;
    }

    private Map<String, Properties> matchContainerSettings(String _key, Set<IContainerSetting> _containerSettings) {
        HashMap<String, Properties> result = new HashMap<String, Properties>();
        if (_containerSettings != null) {
            block0: for (IContainerSetting setting : _containerSettings) {
                if (setting.getIncludes() == null) continue;
                for (IIncludePattern pattern : setting.getIncludes()) {
                    if (_key != null && !_key.matches(pattern.getPattern())) continue;
                    Properties props = pattern.getIncludeProperties();
                    result.put(setting.getName(), props != null ? props : new Properties());
                    Properties pro = (Properties)result.get(setting.getName());
                    pro.put("busConnection", setting.getBusConnection());
                    pro.put("routingHttpConnection", setting.getRoutingHttpConnection());
                    pro.put("enablePayloadCapture", setting.getEnablePayloadCapture());
                    pro.put("useForLookingGlass", setting.getUseForLookingGlass());
                    pro.put("useIntraContainerMessaging", setting.getUseIntraContainerMessaging());
                    pro.put("bootContainer", Boolean.toString(setting.isBootContainer()));
                    pro.put("backupContainer", setting.getBackupContainer());
                    pro.put("clone", Boolean.toString(setting.isClone()));
                    pro.put("Segment", setting.getSegment());
                    pro.put("containerParameterSet", setting.getContainerParameterSet());
                    pro.put("logDirectory", setting.getLogDirectory());
                    continue block0;
                }
            }
        }
        return result;
    }
}

