/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.util;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class InjectArtifactHandlerMojo
implements Mojo {
    private MavenProject project;
    private ArtifactHandlerManager artifactHandlerManager;
    private MavenSession session;
    private Log log;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Injecting the Artifact Handlers anyway.");
        this.getLog().info((CharSequence)("Setting ArtifactHandler on project-artifact: " + this.project.getId() + "..."));
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        artifacts.add(this.project.getArtifact());
        Set dependencyArtifacts = this.project.getDependencyArtifacts();
        if (dependencyArtifacts != null && !dependencyArtifacts.isEmpty()) {
            artifacts.addAll(dependencyArtifacts);
        }
        for (Artifact artifact : artifacts) {
            String type = artifact.getType();
            ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type);
            this.getLog().debug((CharSequence)("Artifact: " + artifact.getId() + "\nType: " + type + "\nArtifactHandler extension: " + handler.getExtension()));
            artifact.setArtifactHandler(handler);
        }
        this.getLog().info((CharSequence)"...done.");
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log _log) {
        this.log = _log;
    }
}

