/*
 * Copyright information goes here
 */
package com.sample.sonic.esbx.services.sample;

import com.sonicsw.esb.service.common.SFCParameters;
import com.sonicsw.esb.service.common.SFCServiceContext;
import com.sonicsw.esb.service.common.impl.AbstractSFCServiceImpl;
import com.sonicsw.xq.XQEnvelope;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQServiceException;
import org.apache.log4j.Logger;

/**
 * New Custom Service Description.
 * 
 * @author
 * @version 1.0
 */
public class SampleService extends AbstractSFCServiceImpl {


  // Initialization and runtime parameter names
  private final String paramMsgPart = "msgPart";

  // Access to the SFC's logging mechanism
  private final Logger log          = Logger.getLogger(this.getClass());

  /**
   * {@inheritDoc}
   */
  public final void doService(final SFCServiceContext _ctx, final XQEnvelope _envelope) throws XQServiceException {

    // get the message from the envelope
    final XQMessage message = _envelope.getMessage();

    // get the parameters from the Service Context
    final SFCParameters parameters = _ctx.getParameters();
    log.info("Processing incoming message");

    // initialize the part to be processed
    String processPartParam = parameters.getParameter(paramMsgPart);
    log.debug("Trying to find message part: " + processPartParam);
    // Custom Service Implementation Goes Here...

    log.info("Passing the message to the outbox.");
    _ctx.addIncomingToOutbox();
  }
}
