/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.esb;

import com.aurea.maven.plugins.sonic.esb.EsbPackageMojo;
import com.aurea.maven.plugins.sonic.sdm.container.impl.DefaultServiceType;
import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import com.progress.sonic.utilities.esb.admin.ESBAdmin;
import com.progress.sonic.utilities.esb.admin.ESBArtifactCopyJob;
import com.progress.sonic.utilities.esb.admin.EndpointAdmin;
import com.progress.sonic.utilities.esb.admin.ServiceAdmin;
import com.progress.sonic.utilities.mfutils.MFUtils;
import com.progress.sonic.utilities.mfutils.NullArtifactNotificationListener;
import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactNotificationListener;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.artifact.ESBArtifact;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.storage.FileArtifactStorage;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;
import com.sonicsw.esb.mgmtapi.config.IEndpointConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import no.geosoft.cc.util.SmartTokenizer;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public class MavenEsbSvcPackageMojo
extends EsbPackageMojo {
    private static final int DOMAIN_PING_TIMEOUT = 1000;
    MavenProjectHelper projectHelper;
    ArtifactHandler handler;
    private String classpathSeparator;
    private String ctClasspathPattern = null;
    private String ctPrependClasspath = null;
    private String typeClasspathPattern = null;
    private String typePrependClasspath = null;
    private String instancePrependClasspath = null;
    private boolean instanceSelfFirst;
    private boolean typeSelfFirst;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Packaging ESB ServiceType ...");
        this.project.getArtifact().setArtifactHandler(this.handler);
        this.getLog().debug((CharSequence)this.project.getArtifact().getArtifactHandler().getLanguage());
        try {
            this.createJarFile();
            super.doExecute();
        }
        catch (MojoExecutionException e) {
            this.getLog().error((CharSequence)("Error packaging ESB Service Type : " + e.getMessage()), (Throwable)e);
            throw new MojoExecutionException("Error packaging ESB Service Type : ", (Exception)((Object)e));
        }
    }

    private File createJarFile() throws MojoExecutionException {
        File jarFile;
        try {
            String jarFileName = this.getPackageXarDir() + "/SonicFS/" + this.getSonicFSResourcesDir() + "/" + this.getGroupId().replaceAll("\\.", "/") + "/" + this.getArtifactId() + "/" + this.getVersion() + "/" + this.getFinalAssemblyBaseName() + ".jar";
            jarFile = new File(jarFileName);
            jarFile.getParentFile().mkdirs();
            FileUtilities.copyFiles(this.project.getBasedir() + "/src/main/resources", this.getOutputDirectory() + "/classes");
            Archiver archiver = this.archiverManager.getArchiver(jarFile);
            archiver.setDestFile(jarFile);
            archiver.addDirectory(new File(this.getOutputDirectory() + "/classes"));
            archiver.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating ESB Servicetype Jar file", e);
        }
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected File createXarFile() throws Exception {
        block13: {
            String xarDir = this.getPackageXarDir();
            new File(xarDir).mkdirs();
            try {
                boolean connectedToDS = false;
                EndpointAdmin endpointAdmin = null;
                ServiceAdmin serviceAdmin = null;
                if (!MFUtils.pingDomain((String)this.getManagementUrl(), (int)1000)) {
                    this.getLog().warn((CharSequence)("Could not connect to Sonic Domain at " + this.getManagementUrl()));
                } else {
                    connectedToDS = true;
                    ESBAdmin esbAdmin = this.getMFUtils().getESBAdmin();
                    serviceAdmin = new ServiceAdmin(esbAdmin.getEsbApi());
                    endpointAdmin = new EndpointAdmin(esbAdmin.getEsbApi());
                }
                ArrayList<ESBArtifact> serviceTypes = new ArrayList<ESBArtifact>();
                try {
                    StringBuffer buf = new StringBuffer();
                    buf.append("SonicFS/System/SonicESB/7.0/properties/servicetypes");
                    buf.append(",");
                    buf.append("SonicFS/System/SonicESB/7.5/properties/servicetypes");
                    buf.append(",");
                    buf.append("SonicFS/System/SonicESB/properties/servicetypes");
                    FileUtilities.copyFiles(this.getSonicEsbSourceDirectory().getAbsolutePath(), xarDir, "**/*.properties,**/*.gif,**/*.xml", null, buf.toString(), true);
                    FileUtilities.copyFiles(this.getSonicEsbSourceDirectory().getAbsolutePath(), xarDir, "**/*.esbstyp", null, "ESB/ServiceTypes", true);
                    for (String srcFile : FileUtilities.getFileList(xarDir, "**/*.esbstyp", null)) {
                        File svcFile = new File(xarDir, srcFile);
                        Xpp3Dom svcDom = Xpp3DomBuilder.build((Reader)new XmlStreamReader(svcFile));
                        String svcName = svcDom.getAttribute("name");
                        serviceTypes.add(new ESBArtifact(ESBArtifact.SERVICE_TYPE, svcName));
                        File destFile = new File(svcFile.getParentFile(), svcName + ".xml");
                        svcFile.renameTo(destFile);
                        if (!connectedToDS) continue;
                        File serviceTypePropertiesFile = new File(xarDir + "/SonicFS/System/SonicESB/properties/servicetypes", svcName + ".properties");
                        Properties serviceTypeProperties = new Properties();
                        serviceTypeProperties.load(new FileInputStream(serviceTypePropertiesFile));
                        String serviceTypeInstance = serviceTypeProperties.getProperty("type.defaultInstance", svcName);
                        this.getLog().info((CharSequence)("Importing '" + svcName + "' ESB Service Type in Sonic Domain"));
                        serviceAdmin.importServiceType(destFile, serviceTypePropertiesFile, true);
                        String endpoint = serviceTypeInstance + ".Entry";
                        if (endpoint == null || endpoint.isEmpty()) continue;
                        if (!endpointAdmin.isEndpointExisting(endpoint)) {
                            this.getLog().info((CharSequence)("Creating '" + endpoint + "' endpoint in Sonic Domain for ESB Service Type " + svcName));
                        }
                        IEndpointConfig endpointConfig = endpointAdmin.createTopicEndpoint(endpoint);
                        if (!serviceAdmin.isServiceConfigExisting(serviceTypeInstance)) {
                            this.getLog().info((CharSequence)("Creating '" + serviceTypeInstance + "' service config in Sonic Domain for ESB Service Type " + svcName));
                        }
                        serviceAdmin.createServiceTypeConfig(serviceTypeInstance, svcName, endpointConfig, false);
                    }
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Error copying files", e);
                }
                this.injectServiceClasspath(xarDir);
                if (serviceTypes.size() <= 0) break block13;
                try {
                    FileArtifactStorage fas = new FileArtifactStorage();
                    fas.addNotificationListener((IArtifactNotificationListener)new NullArtifactNotificationListener());
                    fas.setRoot(xarDir);
                    ExportPropertiesArtifact expProperties = new ExportPropertiesArtifact();
                    expProperties.addRoot((IArtifact)new SonicFSArtifact("/"));
                    expProperties.addRoot((IArtifact[])serviceTypes.toArray(new ESBArtifact[0]));
                    expProperties.addIgnore((IArtifact)new SonicFSArtifact("workspace/"));
                    if (connectedToDS) {
                        new ESBArtifactCopyJob((IArtifactStorage)fas, (IArtifactStorage)this.getMFUtils().getDSArtifactStorage(), expProperties, false).copy();
                        this.getLog().info((CharSequence)"ESB Service type imported into local DS");
                    }
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)"Failed to import ESB Service Type into local DS", (Throwable)e);
                }
            }
            finally {
                this.getMFUtils().cleanup();
            }
        }
        return super.createXarFile();
    }

    @Override
    protected String getXarExcludePatterns() {
        if (this.xarExcludes != null) {
            return this.xarExcludes;
        }
        return super.getXarExcludePatterns() + ",**/ServiceTypes/*";
    }

    private void injectServiceClasspath(String _xarDir) throws MojoExecutionException {
        String[] stFiles;
        SmartTokenizer st;
        this.getLog().info((CharSequence)"Setting Service Type classpath ...");
        String[] jarFiles = FileUtilities.getFileList(_xarDir + "/SonicFS", "**/*.jar", null);
        ArrayList<String> instanceJars = new ArrayList<String>();
        ArrayList<String> typeJars = new ArrayList<String>();
        ArrayList<String> ctJars = new ArrayList<String>();
        if (this.typePrependClasspath != null) {
            st = new SmartTokenizer(this.typePrependClasspath, this.classpathSeparator);
            while (st.hasMoreTokens()) {
                typeJars.add(st.nextToken());
            }
        }
        if (this.instancePrependClasspath != null) {
            st = new SmartTokenizer(this.instancePrependClasspath, this.classpathSeparator);
            while (st.hasMoreTokens()) {
                instanceJars.add(st.nextToken());
            }
        }
        if (this.ctPrependClasspath != null) {
            st = new SmartTokenizer(this.ctPrependClasspath, this.classpathSeparator);
            while (st.hasMoreTokens()) {
                ctJars.add(st.nextToken());
            }
        }
        for (int i = 0; i < jarFiles.length; ++i) {
            String jar = jarFiles[i].replaceAll("\\\\", "/");
            this.getLog().debug((CharSequence)("TBO: Jar File: " + jar));
            if (this.typeClasspathPattern != null) {
                this.getLog().debug((CharSequence)("The Type Classpath Pattern = " + this.typeClasspathPattern));
                if (jar.matches(this.typeClasspathPattern)) {
                    this.getLog().debug((CharSequence)"there is a match");
                    typeJars.add("sonicfs:///" + jar);
                    jar = null;
                } else {
                    this.getLog().debug((CharSequence)"THERE IS NO MATCH");
                }
            }
            if (jar != null && this.ctClasspathPattern != null && jar.matches(this.ctClasspathPattern)) {
                ctJars.add("sonicfs:///" + jar);
                jar = null;
            }
            if (jar == null) continue;
            instanceJars.add("sonicfs:///" + jar);
        }
        String svcTypeDir = this.getPackageXarDir() + "/ESB/ServiceTypes";
        for (String stFileName : stFiles = FileUtilities.getFileList(svcTypeDir, "*.xml", null)) {
            this.getLog().debug((CharSequence)("TBO: File Name: " + stFileName));
            DefaultServiceType st2 = new DefaultServiceType();
            File stFile = new File(svcTypeDir, stFileName);
            try {
                st2.load(new FileInputStream(stFile));
                this.getLog().debug((CharSequence)"TBO: File Loaded");
                st2.setInstanceClasspath(instanceJars, this.instanceSelfFirst);
                this.getLog().debug((CharSequence)"TBO: Instance Classpath Set");
                st2.setTypeClasspath(typeJars, this.typeSelfFirst);
                this.getLog().debug((CharSequence)"TBO: Type Classpath Set");
                st2.setContainerClasspath(ctJars);
                this.getLog().debug((CharSequence)"TBO: File Container Path Set");
                st2.save(stFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }
}

