/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.sdm;

import com.aurea.maven.plugins.sonic.AbstractSonicMojo;
import java.io.File;
import java.io.Reader;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public abstract class AbstractSdmMojo
extends AbstractSonicMojo {
    protected File getTargetSDMDir() {
        return new File(this.getOutputDirectory(), "sonicesb/sdm");
    }

    protected File getGeneratedPropertiesFile() {
        return new File(this.getTargetSDMDir(), "/generated.tailoring.properties");
    }

    protected File getGeneratedTopologyFile() {
        return new File(this.getTargetSDMDir(), "/generated.Topology.xml");
    }

    protected File getMasterTopologyFile() {
        return new File(this.getTargetSDMDir(), "/Topology.xml");
    }

    protected Properties buildPropertiesFromTopology(File topoFile) throws MojoExecutionException {
        try {
            Properties generated = new Properties();
            XmlStreamReader topoReader = new XmlStreamReader(topoFile);
            Xpp3Dom topology = Xpp3DomBuilder.build((Reader)topoReader);
            Xpp3Dom parameters = topology.getChild("Parameters");
            for (Xpp3Dom parameter : parameters.getChildren()) {
                String id = this.getChildElementValue(parameter, "Id");
                String value = this.getChildElementValue(parameter, "Value");
                this.getLog().debug((CharSequence)("Adding Property: " + id + " -- " + value));
                generated.put(id, value);
            }
            return generated;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception while reading topology file: " + topoFile.getName(), e);
        }
    }

    protected String getChildElementValue(Xpp3Dom parent, String name) {
        Xpp3Dom childElement = parent.getChild(name);
        if (childElement != null) {
            return childElement.getValue();
        }
        throw new IllegalArgumentException("Child element " + name + " does not exist in element " + parent.getName());
    }
}

