/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.sdm;

import com.aurea.maven.plugins.sonic.sdm.AbstractSdmMojo;
import com.aurea.maven.plugins.sonic.sdm.util.ESBDeploymentModel;
import com.aurea.maven.plugins.sonic.sdm.util.ESBDeploymentModelBuilder;
import com.aurea.maven.plugins.util.VelocityRunner;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class VelocityGeneratorMojo
extends AbstractSdmMojo {
    private List<String> templateFiles;
    private String propFileName;
    private String aiOutputDirName = "ai";

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        ESBDeploymentModelBuilder builder = new ESBDeploymentModelBuilder(this.project, this.getLog());
        ESBDeploymentModel model = null;
        try {
            model = builder.getModel();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error building Deployment Model", e);
        }
        this.getLog().info((CharSequence)"Executing Velocity ....");
        VelocityRunner runner = VelocityRunner.getInstance(this.project);
        runner.setOutputDirectory(this.aiOutputDirName);
        runner.addProperty("env", System.getenv());
        runner.addProperty("system", System.getProperties());
        runner.addProperties("user", this.propFileName);
        runner.addProperty("model", model);
        for (String tplFile : this.templateFiles) {
            this.getLog().debug((CharSequence)("Generating Template: " + tplFile));
            try {
                runner.run(tplFile, new File(tplFile).getName());
            }
            catch (Exception e) {
                throw new MojoExecutionException("Template generation failed.", e);
            }
        }
    }
}

