/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.topology.utils;

import com.aurea.maven.plugins.sonic.topology.utils.MachineConfig;
import java.io.Serializable;
import java.util.ArrayList;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MachineHolder
implements Serializable {
    private static final long serialVersionUID = 1L;
    ArrayList<MachineConfig> machineConfigs = new ArrayList();

    public void addMachineConfig(MachineConfig mc) {
        this.machineConfigs.add(mc);
    }

    public void removeMachineConfig(MachineConfig mc) {
        if (this.machineConfigs.contains(mc)) {
            this.machineConfigs.remove(mc);
        }
    }

    public ArrayList<MachineConfig> getMachineConfigs() {
        return this.machineConfigs;
    }

    public void createMachineXmlContent(Xpp3Dom topology) {
        Xpp3Dom machines = new Xpp3Dom("Machines");
        Xpp3Dom machine = null;
        Xpp3Dom machineId = null;
        Xpp3Dom alternateId = null;
        Xpp3Dom logicalHosts = null;
        Xpp3Dom logicalHost = null;
        Xpp3Dom settings = null;
        for (MachineConfig mc : this.getMachineConfigs()) {
            if (mc.getMachineId().equals("")) continue;
            machine = new Xpp3Dom("Machine");
            machineId = new Xpp3Dom("Id");
            machineId.setValue(mc.getMachineId());
            machine.addChild(machineId);
            for (String altid : mc.getAlternateIds()) {
                if (altid.equals("")) continue;
                alternateId = new Xpp3Dom("AlternateId");
                alternateId.setValue(altid);
                machine.addChild(alternateId);
            }
            for (String loghost : mc.getLogicalhosts()) {
                if (loghost.equals("")) continue;
                logicalHost = new Xpp3Dom("LogicalHost");
                logicalHost.setValue(loghost);
                if (logicalHosts == null) {
                    logicalHosts = new Xpp3Dom("LogicalHosts");
                }
                logicalHosts.addChild(logicalHost);
            }
            if (mc.getContainerDir() != null && !mc.getContainerDir().equals("")) {
                if (settings == null) {
                    settings = new Xpp3Dom("Settings");
                }
                Xpp3Dom location = new Xpp3Dom("Locations");
                Xpp3Dom containerDir = new Xpp3Dom("ContainersDir");
                containerDir.setValue(mc.getContainerDir());
                location.addChild(containerDir);
                settings.addChild(location);
            }
            if (mc.getEncryptPWD() != null && !mc.getEncryptPWD().equals("")) {
                if (settings == null) {
                    settings = new Xpp3Dom("Settings");
                }
                Xpp3Dom encryption = new Xpp3Dom("BootfilesEncryptionPassword");
                encryption.setValue(mc.getEncryptPWD());
                settings.addChild(encryption);
            }
            if (mc.getRegisterAsService() != null && !mc.getRegisterAsService().equals("")) {
                if (settings == null) {
                    settings = new Xpp3Dom("Settings");
                }
                Xpp3Dom winService = new Xpp3Dom("RegisterBootContainersAsServices");
                winService.setValue(mc.getRegisterAsService());
                settings.addChild(winService);
            }
            if (mc.getServiceStartupTime() != null && !mc.getServiceStartupTime().equals("")) {
                if (settings == null) {
                    settings = new Xpp3Dom("Settings");
                }
                Xpp3Dom timeout = new Xpp3Dom("WindowsServicesStartupTimeout");
                timeout.setValue(mc.getServiceStartupTime());
                settings.addChild(timeout);
            }
            machine.addChild(logicalHosts);
            if (settings != null) {
                machine.addChild(settings);
            }
            machines.addChild(machine);
        }
        topology.addChild(machines);
    }
}

