/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic.esb;

import com.aurea.maven.plugins.sonic.esb.AbstractESBMojo;
import com.aurea.maven.plugins.sonic.utils.DependencyAnalyzer;
import com.aurea.maven.plugins.sonic.utils.FileUtilities;
import com.progress.sonic.utilities.esb.admin.XarAnalyzer;
import com.progress.sonic.utilities.mfutils.MFUtils;
import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.artifact.ArtifactFactory;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;
import com.sonicsw.xqimpl.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class AbstractESBConnectMojo
extends AbstractESBMojo {
    protected final File deployGenSrcDir = null;
    protected final File testableDeployGenSrcDir = null;
    protected String connectServiceLocation;
    protected String wadlFiles;
    protected String wadlPackage;
    protected String wadlBaseUrl;
    protected File targetGenTestSrcDir;
    private String dxsiVersion;
    private String domain;
    private String user;
    private String password;
    private String mgmtUrl;
    protected MFUtils mfUtils = null;

    protected MFUtils getMFUtils() throws MojoExecutionException {
        if (this.mfUtils == null) {
            this.getLog().info((CharSequence)"Connecting to Sonic Domain ...");
            this.getLog().debug((CharSequence)("Domain: " + this.getDomainName()));
            this.getLog().debug((CharSequence)("ManagementURL: " + this.getManagementUrl()));
            this.getLog().debug((CharSequence)("User: " + this.getAdminUser()));
            this.getLog().debug((CharSequence)("Password: " + this.getAdminPassword()));
            this.mfUtils = new MFUtils(this.getDomainName(), this.getManagementUrl(), this.getAdminUser(), this.getAdminPassword());
        }
        return this.mfUtils;
    }

    protected String getDomainName() throws MojoExecutionException {
        return this.domain;
    }

    protected String getAdminUser() throws MojoExecutionException {
        return this.user;
    }

    protected String getAdminPassword() throws MojoExecutionException {
        return this.password;
    }

    protected String getManagementUrl() throws MojoExecutionException {
        return this.mgmtUrl;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.exportXQHome();
    }

    private void exportXQHome() {
        try {
            String tmpDir;
            File pluginTmp;
            File xsdTmp;
            String xqVersion = Version.getMajorMinorVersion();
            if ("10.0".equals(xqVersion) || "12.0".equals(xqVersion)) {
                xqVersion = "2015";
            }
            if (!(xsdTmp = new File(pluginTmp = new File(tmpDir = System.getProperty("java.io.tmpdir"), "sonicesb-maven-plugin"), "ESB" + xqVersion)).exists()) {
                this.getLog().debug((CharSequence)("Exporting XSD files to " + xsdTmp.getAbsolutePath()));
                String path = "ESB/schema/" + xqVersion + "/";
                String[] schemas = this.getResourceListing(path);
                File outputDir = new File(xsdTmp, "schema");
                outputDir.mkdirs();
                for (String file : schemas) {
                    this.exportResource(path, file, outputDir);
                }
            }
            System.setProperty("com.sonicsw.xq.home", xsdTmp.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getRulesFileName() {
        return this.getFinalAssemblyBaseName() + "-Tailoring.xml";
    }

    protected void addExportIgnoresForDependencies(ExportPropertiesArtifact _expProps) {
        IArtifact sonicfs;
        String[] dxsiIgnoreList = new String[]{"System/DataXtend/" + this.dxsiVersion + "/lib/commons-beanutils.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/commons-codec.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/commons-collections.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/commons-httpclient.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/commons-io-2.0.1.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/commons-jxpath.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/commons-lang.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/commons-vfs.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/jta.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/saaj-api.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/saaj-impl.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/antlr.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/velocity.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/jsr173_1.0_api.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/javassist.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/hibernate3.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/empty.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/ehcache.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/dom4j.jar", "System/DataXtend/" + this.dxsiVersion + "/lib/c3p0.jar"};
        String[] connectIgnoreList = new String[]{"System/SonicESB/%VERSION%/lib/esb_connect.jar", "System/SonicESB/%VERSION%/lib/spring-context-support.jar", "System/SonicESB/%VERSION%/lib/spring-jms.jar", "System/SonicESB/%VERSION%/lib/spring-tx.jar", "System/SonicESB/%VERSION%/lib/spring-web.jar", "System/SonicESB/%VERSION%/lib/asm.jar", "System/SonicESB/%VERSION%/lib/camel-cxfjetty.jar", "System/SonicESB/%VERSION%/lib/camel-sonicesb.jar", "System/SonicESB/%VERSION%/lib/connect-datacontenthandlers.jar", "System/SonicESB/%VERSION%/lib/connect-security.jar", "System/SonicESB/%VERSION%/lib/jaxb-impl.jar", "System/SonicESB/%VERSION%/lib/jaxb-xjc.jar", "System/SonicESB/%VERSION%/lib/saaj-impl.jar", "System/SonicESB/%VERSION%/lib/commons-codec.jar", "System/SonicESB/%VERSION%/lib/commons-collections.jar", "System/SonicESB/%VERSION%/lib/commons-httpclient.jar", "System/SonicESB/%VERSION%/lib/commons-lang.jar", "System/SonicESB/%VERSION%/lib/commons-logging-api.jar", "System/SonicESB/%VERSION%/lib/jsr311-api.jar", "System/SonicESB/%VERSION%/lib/jaxb-api.jar", "System/SonicESB/%VERSION%/lib/saaj-api.jar", "System/SonicESB/%VERSION%/lib/jaxen.jar", "System/SonicESB/%VERSION%/lib/abdera-core.jar", "System/SonicESB/%VERSION%/lib/abdera-extensions-json.jar", "System/SonicESB/%VERSION%/lib/abdera-extensions-main.jar", "System/SonicESB/%VERSION%/lib/abdera-i18n.jar", "System/SonicESB/%VERSION%/lib/abdera-parser.jar", "System/SonicESB/%VERSION%/lib/camel-core.jar", "System/SonicESB/%VERSION%/lib/camel-cxf.jar", "System/SonicESB/%VERSION%/lib/camel-http.jar", "System/SonicESB/%VERSION%/lib/camel-jetty.jar", "System/SonicESB/%VERSION%/lib/camel-jms.jar", "System/SonicESB/%VERSION%/lib/camel-spring.jar", "System/SonicESB/%VERSION%/lib/cxf-api.jar", "System/SonicESB/%VERSION%/lib/cxf-common-schemas.jar", "System/SonicESB/%VERSION%/lib/cxf-common-utilities.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-bindings-soap.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-bindings-xml.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-core.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-databinding-aegis.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-databinding-jaxb.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-frontend-jaxrs.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-frontend-jaxws.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-frontend-simple.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-javascript.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-transports-http.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-transports-http-jetty.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-transports-local.jar", "System/SonicESB/%VERSION%/lib/cxf-rt-ws-addr.jar", "System/SonicESB/%VERSION%/lib/cxf-tools-common.jar", "System/SonicESB/%VERSION%/lib/cxf-tools-java2ws.jar", "System/SonicESB/%VERSION%/lib/cxf-tools-validator.jar", "System/SonicESB/%VERSION%/lib/cxf-tools-wsdlto-core.jar", "System/SonicESB/%VERSION%/lib/cxf-tools-wsdlto-databinding-jaxb.jar", "System/SonicESB/%VERSION%/lib/cxf-tools-wsdlto-frontend-jaxws.jar", "System/SonicESB/%VERSION%/lib/geronimo-activation_1.1_spec.jar", "System/SonicESB/%VERSION%/lib/geronimo-annotation_1.0_spec.jar", "System/SonicESB/%VERSION%/lib/geronimo-javamail_1.4_spec.jar", "System/SonicESB/%VERSION%/lib/geronimo-jaxws_2.1_spec.jar", "System/SonicESB/%VERSION%/lib/geronimo-jms_1.1_spec.jar", "System/SonicESB/%VERSION%/lib/geronimo-servlet_2.4_spec.jar", "System/SonicESB/%VERSION%/lib/geronimo-servlet_2.5_spec.jar", "System/SonicESB/%VERSION%/lib/geronimo-stax-api_1.0_spec.jar", "System/SonicESB/%VERSION%/lib/geronimo-ws-metadata_2.0_spec.jar", "System/SonicESB/%VERSION%/lib/neethi.jar", "System/SonicESB/%VERSION%/lib/velocity.jar", "System/SonicESB/%VERSION%/lib/axiom-api.jar", "System/SonicESB/%VERSION%/lib/axiom-impl.jar", "System/SonicESB/%VERSION%/lib/XmlSchema.jar", "System/SonicESB/%VERSION%/lib/xmlbeans.jar", "System/SonicESB/%VERSION%/lib/jettison.jar", "System/SonicESB/%VERSION%/lib/wstx-asl.jar", "System/SonicESB/%VERSION%/lib/commons-management.jar", "System/SonicESB/%VERSION%/lib/jetty.jar", "System/SonicESB/%VERSION%/lib/jetty-client.jar", "System/SonicESB/%VERSION%/lib/jetty-sslengine.jar", "System/SonicESB/%VERSION%/lib/jetty-util.jar", "System/SonicESB/%VERSION%/lib/jetty-util5.jar", "System/SonicESB/%VERSION%/lib/slf4j-api.jar", "System/SonicESB/%VERSION%/lib/slf4j-jdk14.jar", "System/SonicESB/%VERSION%/lib/spring-security-core.jar", "System/SonicESB/%VERSION%/lib/spring-security-core-tiger.jar", "System/SonicESB/%VERSION%/lib/oro.jar", "System/SonicESB/%VERSION%/lib/wsdl4j.jar", "System/SonicESB/%VERSION%/lib/xml-resolver.jar"};
        this.getLog().info((CharSequence)"Building Artifact ignore List from Dependencies : ...");
        for (String xarFile : FileUtilities.getFileList(this.getDependencyDirectory(), "xar/**/*.xar", null)) {
            this.getLog().info((CharSequence)("Analyzing xar file: " + xarFile));
            XarAnalyzer analyzer = new XarAnalyzer(new File(this.getDependencyDirectory(), xarFile));
            for (IArtifact a : analyzer.getAllArtifacts()) {
                this.getLog().debug((CharSequence)("Adding artifact to ignore list: " + a.getPath()));
                _expProps.addIgnore(a);
            }
        }
        this.getLog().info((CharSequence)"Setting the Ignore-List for Sonic Connect");
        for (String library : connectIgnoreList) {
            this.getLog().debug((CharSequence)("TBO : Sonic Connect Fix - Adding " + library + " to the export ignore list"));
            sonicfs = ArtifactFactory.createArtifact((String)"SonicFS", (String)library);
            _expProps.addIgnore(sonicfs);
        }
        this.getLog().info((CharSequence)"Setting the Ignore-List for Sonic DXSI Libraries");
        for (String library : dxsiIgnoreList) {
            this.getLog().debug((CharSequence)("TBO : DXSI Fix - Adding " + library + " to the export ignore list"));
            sonicfs = ArtifactFactory.createArtifact((String)"SonicFS", (String)library);
            _expProps.addIgnore(sonicfs);
        }
        DependencyAnalyzer da = new DependencyAnalyzer(this.getDependencyDirectory());
        for (String jarFile : da.getDependencyJars()) {
            IArtifact a;
            String jarURL = this.getSonicFSResourcesDir() + "/" + jarFile.replaceAll("\\\\", "/");
            a = ArtifactFactory.createArtifact((String)"SonicFS", (String)jarURL);
            _expProps.addIgnore(a);
        }
    }

    private void exportResource(String path, String file, File outputDir) throws IOException {
        this.getLog().debug((CharSequence)("Exporting " + file + " to " + outputDir.getAbsolutePath()));
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        File destFile = new File(outputDir, file);
        String resource = path + file;
        try (InputStream input = classloader.getResourceAsStream(resource);
             FileOutputStream out = new FileOutputStream(destFile);){
            int read;
            byte[] bytes = new byte[1024];
            while ((read = input.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
        }
    }

    private String[] getResourceListing(String path) throws IOException, URISyntaxException, MojoExecutionException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        URL dirURL = classloader.getResource(path);
        if (dirURL == null) {
            throw new MojoExecutionException("Cannot list files from resource " + path);
        }
        if (dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list();
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));){
                Enumeration<JarEntry> entries = jar.entries();
                HashSet<String> result = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(path) || name.equals(path)) continue;
                    result.add(name.substring(path.length()));
                }
                String[] stringArray = result.toArray(new String[result.size()]);
                return stringArray;
            }
        }
        throw new MojoExecutionException("Cannot list files for URL " + dirURL);
    }
}

