/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class VelocityRunner {
    private static VelocityRunner instance = null;
    private VelocityContext context = null;
    private MavenProject project = null;
    private File outputDirectory = null;

    private VelocityRunner(MavenProject project) {
        try {
            Velocity.init();
            this.context = new VelocityContext();
            this.project = project;
            Velocity.setProperty((String)"file.resource.loader.path", (Object)project.getBasedir());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static VelocityRunner getInstance(MavenProject project) {
        if (instance == null) {
            instance = new VelocityRunner(project);
        }
        return instance;
    }

    public static VelocityRunner getInstance() throws Exception {
        if (instance == null) {
            throw new Exception("VelocityRunner not initialized.");
        }
        return instance;
    }

    public void setOutputDirectory(String outputDirName) {
        this.outputDirectory = new File(this.project.getBuild().getDirectory(), outputDirName);
    }

    public void addProperties(String prefix, String propFileName) {
        File propFile;
        Properties props = new Properties();
        if (propFileName != null && (propFile = new File(this.project.getBasedir() + "/" + propFileName)).exists() && propFile.canRead()) {
            try {
                props.load(new FileInputStream(propFile));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addProperty(prefix, props);
    }

    public void addProperty(String key, Object value) {
        this.context.put(key, value);
    }

    public void run(String tplFile, String outFileName) throws Exception {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        BufferedWriter out = null;
        try {
            Template template = Velocity.getTemplate((String)tplFile);
            File outFile = new File(this.outputDirectory.getAbsoluteFile(), outFileName);
            outFile.getParentFile().mkdirs();
            out = new BufferedWriter(new FileWriter(outFile));
            template.merge((Context)this.context, (Writer)out);
        }
        catch (Exception e) {
            throw new Exception("Template generation failed ...");
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

