/*
 * Decompiled with CFR 0.152.
 */
package com.aurea.maven.plugins.sonic;

import com.aurea.maven.plugins.sonic.AbstractSonicMojo;
import com.aurea.maven.plugins.sonic.utils.ZipUtilities;
import com.progress.sonic.utilities.esb.admin.ESBArtifactCopyJob;
import com.progress.sonic.utilities.mfutils.MFUtils;
import com.progress.sonic.utilities.mfutils.NullArtifactNotificationListener;
import com.sonicsw.deploy.IArtifact;
import com.sonicsw.deploy.IArtifactNotificationListener;
import com.sonicsw.deploy.IArtifactStorage;
import com.sonicsw.deploy.artifact.SonicFSArtifact;
import com.sonicsw.deploy.storage.FileArtifactStorage;
import com.sonicsw.deploy.tools.common.ExportPropertiesArtifact;
import java.io.File;
import java.io.IOException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class SonicUnpackDependenciesMojo
extends AbstractSonicMojo {
    private static final int DOMAIN_PING_TIMEOUT = 1000;
    private String domain;
    private String user;
    private String password;
    private String mgmtUrl;
    private MavenSession session;
    protected BuildPluginManager pluginManager;
    private File markersDirectory = null;
    protected MFUtils mfUtils = null;

    protected MFUtils getMFUtils() throws MojoExecutionException {
        if (this.mfUtils == null) {
            this.getLog().info((CharSequence)"Connecting to Sonic Domain ...");
            this.getLog().debug((CharSequence)("Domain: " + this.getDomainName()));
            this.getLog().debug((CharSequence)("ManagementURL: " + this.getManagementUrl()));
            this.getLog().debug((CharSequence)("User: " + this.getAdminUser()));
            this.getLog().debug((CharSequence)("Password: " + this.getAdminPassword()));
            this.mfUtils = new MFUtils(this.getDomainName(), this.getManagementUrl(), this.getAdminUser(), this.getAdminPassword());
        }
        return this.mfUtils;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            this.markersDirectory = new File(this.getDependencyDirectory(), "markers");
            this.unpackSonicCompile();
            this.unpackDxsiXars();
            this.unpackTopologyConfig();
            this.unpackSonicProvided();
            this.copyDependentJars();
            this.copySonicExtensions();
        }
        catch (Exception ex) {
            if (ex.getCause() != null && ex.getCause().getMessage() != null && ex.getCause().getMessage().contains("MDEP-98")) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }

    private void unpackTopologyConfig() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"2.7")), (String)MojoExecutor.goal((String)"unpack-dependencies"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(this.getDependencyDirectory() + "/topology")), MojoExecutor.element((String)MojoExecutor.name((String)"excludeScope"), (String)"provided"), MojoExecutor.element((String)MojoExecutor.name((String)"markersDirectory"), (String)this.markersDirectory.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"includeTypes"), (String)"topology"), MojoExecutor.element((String)MojoExecutor.name((String)"useRepositoryLayout"), (String)"false"), MojoExecutor.element((String)MojoExecutor.name((String)"useSubDirectoryPerType"), (String)"false")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        try {
            FileUtils.deleteDirectory((File)this.markersDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void unpackSonicCompile() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"2.7")), (String)MojoExecutor.goal((String)"unpack-dependencies"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(this.getDependencyDirectory() + "/xar/compile")), MojoExecutor.element((String)MojoExecutor.name((String)"excludeScope"), (String)"provided"), MojoExecutor.element((String)MojoExecutor.name((String)"markersDirectory"), (String)this.markersDirectory.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"includeTypes"), (String)"zip,esb,esbstyp,connect"), MojoExecutor.element((String)MojoExecutor.name((String)"useRepositoryLayout"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"useSubDirectoryPerType"), (String)"true")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        try {
            FileUtils.deleteDirectory((File)this.markersDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackDxsiXars() throws MojoExecutionException {
        String[] xarFiles;
        File dxsiExtractDir = new File(this.getDependencyDirectory(), "dxsi");
        File dependencyTmpDir = new File(dxsiExtractDir, "dependencyTmp");
        File xarTmpDir = new File(dxsiExtractDir, "xarTmp");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"2.7")), (String)MojoExecutor.goal((String)"unpack-dependencies"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)dependencyTmpDir.getPath()), MojoExecutor.element((String)MojoExecutor.name((String)"excludeScope"), (String)"provided"), MojoExecutor.element((String)MojoExecutor.name((String)"includeScope"), (String)"compile"), MojoExecutor.element((String)MojoExecutor.name((String)"markersDirectory"), (String)this.markersDirectory.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"includeTypes"), (String)"dxsi"), MojoExecutor.element((String)MojoExecutor.name((String)"useRepositoryLayout"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"useSubDirectoryPerType"), (String)"true")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        String[] xarExtension = new String[]{"xar"};
        for (String xarFilename : xarFiles = FileUtils.getFilesFromExtension((String)dependencyTmpDir.getPath(), (String[])xarExtension)) {
            ZipUtilities.doUnzipAction(xarFilename, xarTmpDir.getPath());
        }
        try {
            FileUtils.deleteDirectory((File)new File(xarTmpDir, "ESB"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            FileArtifactStorage fas = new FileArtifactStorage();
            fas.addNotificationListener((IArtifactNotificationListener)new NullArtifactNotificationListener());
            fas.setRoot(xarTmpDir.getAbsolutePath());
            ExportPropertiesArtifact expProperties = new ExportPropertiesArtifact();
            expProperties.addRoot((IArtifact)new SonicFSArtifact("/"));
            expProperties.addIgnore((IArtifact)new SonicFSArtifact("workspace/"));
            if (!MFUtils.pingDomain((String)this.getManagementUrl(), (int)1000)) {
                this.getLog().warn((CharSequence)("Could not connect to Sonic Domain at " + this.getManagementUrl()));
            } else {
                new ESBArtifactCopyJob((IArtifactStorage)fas, (IArtifactStorage)this.getMFUtils().getDSArtifactStorage(), expProperties, false).copy();
                this.getLog().info((CharSequence)"DXSI Environment Imported!");
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Failed to import ESB Service Type into local DS", (Throwable)e);
        }
        finally {
            this.getMFUtils().cleanup();
        }
    }

    protected String getDomainName() throws MojoExecutionException {
        return this.domain;
    }

    protected String getAdminUser() throws MojoExecutionException {
        return this.user;
    }

    protected String getAdminPassword() throws MojoExecutionException {
        return this.password;
    }

    protected String getManagementUrl() throws MojoExecutionException {
        return this.mgmtUrl;
    }

    private void unpackSonicProvided() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"2.7")), (String)MojoExecutor.goal((String)"unpack-dependencies"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(this.getDependencyDirectory() + "/xar/provided")), MojoExecutor.element((String)MojoExecutor.name((String)"excludeScope"), (String)"compile"), MojoExecutor.element((String)MojoExecutor.name((String)"includeScope"), (String)"provided"), MojoExecutor.element((String)MojoExecutor.name((String)"markersDirectory"), (String)this.markersDirectory.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"includeTypes"), (String)"esbstyp,esb"), MojoExecutor.element((String)MojoExecutor.name((String)"useRepositoryLayout"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"useSubDirectoryPerType"), (String)"true")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        try {
            FileUtils.deleteDirectory((File)this.markersDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copyDependentJars() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"TBO-DEBUG- COPY JAR FILES");
        this.getLog().debug((CharSequence)("TBO-DEBUG- Output Directory: " + this.getDependencyDirectory() + "/jar"));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"2.7")), (String)MojoExecutor.goal((String)"copy-dependencies"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(this.getDependencyDirectory() + "/jar")), MojoExecutor.element((String)MojoExecutor.name((String)"excludeScope"), (String)"test"), MojoExecutor.element((String)MojoExecutor.name((String)"includeScope"), (String)"runtime"), MojoExecutor.element((String)MojoExecutor.name((String)"markersDirectory"), (String)this.markersDirectory.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"excludeGroupIds"), (String)"com.aurea.sonic.mq,com.aurea.sonic.esb,junit,org.mockito"), MojoExecutor.element((String)MojoExecutor.name((String)"excludeArtifactIds"), (String)"esb_mockups"), MojoExecutor.element((String)MojoExecutor.name((String)"includeTypes"), (String)"jar"), MojoExecutor.element((String)MojoExecutor.name((String)"useRepositoryLayout"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"useSubDirectoryPerType"), (String)"false")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        this.getLog().debug((CharSequence)"TBO-DEBUG- COPY JAR FILES - END");
        try {
            FileUtils.deleteDirectory((File)this.markersDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copySonicExtensions() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"2.7")), (String)MojoExecutor.goal((String)"copy-dependencies"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)(this.getDependencyDirectory() + "/jar")), MojoExecutor.element((String)MojoExecutor.name((String)"includeScope"), (String)"runtime"), MojoExecutor.element((String)MojoExecutor.name((String)"markersDirectory"), (String)this.markersDirectory.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"includeGroupIds"), (String)"com.progress.sonic.mqx,com.progress.sonic.esbx,com.aurea.sonic.mqx,com.aurea.sonic.esbx"), MojoExecutor.element((String)MojoExecutor.name((String)"includeTypes"), (String)"jar"), MojoExecutor.element((String)MojoExecutor.name((String)"useRepositoryLayout"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"useSubDirectoryPerType"), (String)"false")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        try {
            FileUtils.deleteDirectory((File)this.markersDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

